/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadNotesTask
extends AbstractDownloadTask {
    private DownloadTask downloadTask;

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadBoundingBoxTask(new BoundingBoxDownloader(downloadArea), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = url.endsWith(".bz2") ? new DownloadBzip2RawUrlTask(new OsmServerLocationReader(url), progressMonitor) : new DownloadRawUrlTask(new OsmServerLocationReader(url), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Notes", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/api/0.6/notes.*", "https?://.*/(.*\\.osn(.bz2)?)"};
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    class DownloadBzip2RawUrlTask
    extends DownloadTask {
        public DownloadBzip2RawUrlTask(OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(reader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor subMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotesBzip2(subMonitor);
            }
            catch (Exception e) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(e);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(e));
            }
        }
    }

    class DownloadRawUrlTask
    extends DownloadTask {
        public DownloadRawUrlTask(OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(reader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor subMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotes(subMonitor);
            }
            catch (Exception e) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(e);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(e));
            }
        }
    }

    class DownloadBoundingBoxTask
    extends DownloadTask {
        public DownloadBoundingBoxTask(OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(reader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor subMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseNotes(null, null, subMonitor);
            }
            catch (Exception e) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadNotesTask.this.rememberException(e);
                }
                DownloadNotesTask.this.rememberException(new OsmTransferException(e));
            }
        }
    }

    abstract class DownloadTask
    extends PleaseWaitRunnable {
        protected OsmServerReader reader;
        protected List<Note> notesData;

        public DownloadTask(OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading Notes", new Object[0]), progressMonitor, false);
            this.reader = reader;
        }

        @Override
        protected void finish() {
            if (DownloadNotesTask.this.isCanceled() || DownloadNotesTask.this.isFailed()) {
                return;
            }
            if (this.notesData == null) {
                return;
            }
            if (Main.isDebugEnabled()) {
                Main.debug("Notes downloaded: " + this.notesData.size());
            }
            List<NoteLayer> noteLayers = null;
            if (Main.map != null) {
                noteLayers = Main.map.mapView.getLayersOfType(NoteLayer.class);
            }
            if (noteLayers != null && noteLayers.size() > 0) {
                NoteLayer layer = noteLayers.get(0);
                layer.getNoteData().addNotes(this.notesData);
            } else {
                NoteLayer layer = new NoteLayer(this.notesData, I18n.tr("Notes", new Object[0]));
                Main.main.addLayer(layer);
            }
        }

        @Override
        protected void cancel() {
            DownloadNotesTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public abstract void realRun() throws IOException, SAXException, OsmTransferException;
    }
}

