/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
extends AbstractDownloadTask {
    private DownloadTask downloadTask;
    protected String newLayerName = null;

    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/(.*\\.gpx)", "https?://.*exportgpx.*", "https?://.*(osm|openstreetmap).org/trace/\\p{Digit}+/data", "https?://.*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download GPS", new Object[0]);
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(newLayer, new BoundingBoxDownloader(downloadArea), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, String url, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        if (url.matches("https?://.*(osm|openstreetmap).org/trace/\\p{Digit}+/data") || url.matches("https?://.*exportgpx.*") || url.matches("https?://.*/(.*\\.gpx)")) {
            this.downloadTask = new DownloadTask(newLayer, new OsmServerLocationReader(url), progressMonitor);
            Matcher matcher = Pattern.compile("https?://.*/(.*\\.gpx)").matcher(url);
            this.newLayerName = matcher.matches() ? matcher.group(1) : null;
            return Main.worker.submit(this.downloadTask);
        }
        if (url.matches("https?://.*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*")) {
            String[] table = url.split("\\?|=|&");
            for (int i = 0; i < table.length; ++i) {
                if (!"bbox".equals(table[i]) || i >= table.length - 1) continue;
                return this.download(newLayer, new Bounds(table[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    public static final boolean isFromServer(String url) {
        return url != null && (url.matches("https?://.*(osm|openstreetmap).org/trace/\\p{Digit}+/data") || url.matches("https?://.*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*"));
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]), progressMonitor, false);
            this.reader = reader;
            this.newLayer = newLayer;
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                ProgressMonitor subMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                this.rawData = this.reader.parseRawGps(subMonitor);
            }
            catch (Exception e) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadGpsTask.this.rememberException(e);
                }
                DownloadGpsTask.this.rememberException(new OsmTransferException(e));
            }
        }

        @Override
        protected void finish() {
            if (DownloadGpsTask.this.isCanceled() || DownloadGpsTask.this.isFailed()) {
                return;
            }
            if (this.rawData == null) {
                return;
            }
            String name = DownloadGpsTask.this.newLayerName != null ? DownloadGpsTask.this.newLayerName : I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxImporter.GpxImporterData layers = GpxImporter.loadLayers(this.rawData, this.reader.isGpxParsedProperly(), name, I18n.tr("Markers from {0}", name));
            GpxLayer gpxLayer = this.addOrMergeLayer(layers.getGpxLayer(), this.findGpxMergeLayer());
            this.addOrMergeLayer(layers.getMarkerLayer(), this.findMarkerMergeLayer(gpxLayer));
            layers.getPostLayerTask().run();
        }

        private <L extends Layer> L addOrMergeLayer(L layer, L mergeLayer) {
            if (layer == null) {
                return null;
            }
            if (this.newLayer || mergeLayer == null) {
                Main.main.addLayer(layer);
                return layer;
            }
            mergeLayer.mergeFrom(layer);
            Main.map.repaint();
            return mergeLayer;
        }

        private GpxLayer findGpxMergeLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            boolean merge = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            Layer active = Main.map.mapView.getActiveLayer();
            if (active instanceof GpxLayer && (merge || ((GpxLayer)active).data.fromServer)) {
                return (GpxLayer)active;
            }
            for (GpxLayer l : Main.map.mapView.getLayersOfType(GpxLayer.class)) {
                if (!merge && !l.data.fromServer) continue;
                return l;
            }
            return null;
        }

        private MarkerLayer findMarkerMergeLayer(GpxLayer fromLayer) {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            for (MarkerLayer l : Main.map.mapView.getLayersOfType(MarkerLayer.class)) {
                if (fromLayer == null || l.fromLayer != fromLayer) continue;
                return l;
            }
            return null;
        }

        @Override
        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

