/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.XmlWriter;

public abstract class AbstractDownloadTask
implements DownloadTask {
    private List<Object> errorMessages = new ArrayList<Object>();
    private boolean canceled = false;
    private boolean failed = false;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    protected void rememberErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    protected void rememberException(Exception exception) {
        this.errorMessages.add(exception);
    }

    @Override
    public List<Object> getErrorObjects() {
        return this.errorMessages;
    }

    @Override
    public String acceptsDocumentationSummary() {
        StringBuilder buf = new StringBuilder("<tr><td>");
        buf.append(this.getTitle());
        buf.append(":</td><td>");
        String[] patterns = this.getPatterns();
        if (patterns.length > 0) {
            buf.append("<ul>");
            for (String pattern : patterns) {
                buf.append("<li>");
                buf.append(XmlWriter.encode(pattern));
                buf.append("</li>");
            }
            buf.append("</ul>");
        }
        buf.append("</td></tr>");
        return buf.toString();
    }

    public boolean acceptsUrl(String url) {
        if (url == null) {
            return false;
        }
        for (String p : this.getPatterns()) {
            if (!url.matches(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isSafeForRemotecontrolRequests() {
        return false;
    }

    @Override
    public boolean acceptsUrl(String url, boolean isRemotecontrol) {
        if (isRemotecontrol && !this.isSafeForRemotecontrolRequests()) {
            return false;
        }
        return this.acceptsUrl(url);
    }

    @Override
    public String getTitle() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPatterns() {
        return new String[0];
    }
}

