/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class WireframeToggleAction
extends ToggleAction {
    public WireframeToggleAction() {
        super(I18n.tr("Wireframe View", new Object[0]), null, I18n.tr("Enable/disable rendering the map as wireframe only", new Object[0]), Shortcut.registerShortcut("menu:view:wireframe", I18n.tr("Toggle Wireframe view", new Object[0]), 87, 5006), false);
        this.putValue("toolbar", "wireframe");
        Main.toolbar.register(this);
        this.setSelected(MapRendererFactory.getInstance().isWireframeMapRendererActive());
        this.notifySelectedState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.main.hasEditLayer());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        if (this.isSelected()) {
            MapRendererFactory.getInstance().activate(WireframeMapRenderer.class);
        } else {
            MapRendererFactory.getInstance().activate(StyledMapRenderer.class);
        }
        this.notifySelectedState();
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.repaint();
        }
    }
}

