/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.DiscardTagsHook;
import org.openstreetmap.josm.actions.upload.FixDataHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.ValidateUploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class UploadAction
extends JosmAction {
    private static final List<UploadHook> uploadHooks = new LinkedList<UploadHook>();
    private static final List<UploadHook> lateUploadHooks = new LinkedList<UploadHook>();

    public static void registerUploadHook(UploadHook hook) {
        UploadAction.registerUploadHook(hook, false);
    }

    public static void registerUploadHook(UploadHook hook, boolean late) {
        if (hook == null) {
            return;
        }
        if (late) {
            if (!lateUploadHooks.contains(hook)) {
                lateUploadHooks.add(0, hook);
            }
        } else if (!uploadHooks.contains(hook)) {
            uploadHooks.add(0, hook);
        }
    }

    public static void unregisterUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (uploadHooks.contains(hook)) {
            uploadHooks.remove(hook);
        }
        if (lateUploadHooks.contains(hook)) {
            lateUploadHooks.remove(hook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data", new Object[0]), "upload", I18n.tr("Upload all changes in the active data layer to the OSM server", new Object[0]), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data", new Object[0])), 38, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Upload"));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(UploadAction.getEditLayer() != null);
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer) {
        return UploadAction.checkPreUploadConditions(layer, layer instanceof OsmDataLayer ? new APIDataSet(((OsmDataLayer)layer).data) : null);
    }

    protected static void alertUnresolvedConflicts(OsmDataLayer layer) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The data to be uploaded participates in unresolved conflicts of layer ''{0}''.<br>You have to resolve them first.</html>", layer.getName()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Upload#PrimitivesParticipateInConflicts"));
    }

    public static boolean warnUploadDiscouraged(AbstractModifiableLayer layer) {
        return GuiHelper.warnUser(I18n.tr("Upload discouraged", new Object[0]), "<html>" + I18n.tr("You are about to upload data from the layer ''{0}''.<br /><br />Sending data from this layer is <b>strongly discouraged</b>. If you continue,<br />it may require you subsequently have to revert your changes, or force other contributors to.<br /><br />Are you sure you want to continue?", layer.getName()) + "</html>", ImageProvider.get("upload"), I18n.tr("Ignore this hint and upload anyway", new Object[0]));
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer, APIDataSet apiData) {
        OsmDataLayer osmLayer;
        ConflictCollection conflicts;
        if (layer.isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(layer)) {
            return false;
        }
        if (layer instanceof OsmDataLayer && apiData.participatesInConflict(conflicts = (osmLayer = (OsmDataLayer)layer).getConflicts())) {
            UploadAction.alertUnresolvedConflicts(osmLayer);
            return false;
        }
        if (apiData != null) {
            for (UploadHook hook : uploadHooks) {
                if (hook.checkUpload(apiData)) continue;
                return false;
            }
        }
        return true;
    }

    public void uploadData(final OsmDataLayer layer, APIDataSet apiData) {
        if (apiData.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        if (!UploadAction.checkPreUploadConditions(layer, apiData)) {
            return;
        }
        final UploadDialog dialog = UploadDialog.getUploadDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> tags = new HashMap<String, String>(layer.data.getChangeSetTags());
                if (!tags.containsKey("source")) {
                    tags.put("source", dialog.getLastChangesetSourceFromHistory());
                }
                if (!tags.containsKey("comment")) {
                    tags.put("comment", dialog.getLastChangesetCommentFromHistory());
                }
                dialog.setDefaultChangesetTags(tags);
            }
        });
        dialog.setUploadedPrimitives(apiData);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        dialog.rememberUserInput();
        for (UploadHook hook : lateUploadHooks) {
            if (hook.checkUpload(apiData)) continue;
            return;
        }
        Main.worker.execute(new UploadPrimitivesTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), layer, apiData, UploadDialog.getUploadDialog().getChangeset()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        APIDataSet apiData = new APIDataSet(Main.main.getCurrentDataSet());
        this.uploadData(Main.main.getEditLayer(), apiData);
    }

    static {
        uploadHooks.add(new ValidateUploadHook());
        uploadHooks.add(new FixDataHook());
        uploadHooks.add(new ApiPreconditionCheckerHook());
        uploadHooks.add(new RelationUploadOrderHook());
        lateUploadHooks.add(new DiscardTagsHook());
    }
}

