/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateSelectionAction
extends JosmAction {
    public static void handlePrimitiveGoneException(long id, OsmPrimitiveType type) {
        MultiFetchServerObjectReader reader = new MultiFetchServerObjectReader();
        reader.append(UpdateSelectionAction.getCurrentDataSet(), id, type);
        try {
            DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
            Main.main.getEditLayer().mergeFrom(ds);
        }
        catch (Exception e) {
            ExceptionDialogUtil.explainException(e);
        }
    }

    public static void updatePrimitives(Collection<OsmPrimitive> selection) {
        UpdatePrimitivesTask task = new UpdatePrimitivesTask(Main.main.getEditLayer(), selection);
        Main.worker.submit(task);
    }

    public static void updatePrimitive(PrimitiveId id) throws IllegalStateException, IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, "id");
        if (UpdateSelectionAction.getEditLayer() == null) {
            throw new IllegalStateException(I18n.tr("No current dataset found", new Object[0]));
        }
        OsmPrimitive primitive = UpdateSelectionAction.getEditLayer().data.getPrimitiveById(id);
        if (primitive == null) {
            throw new IllegalStateException(I18n.tr("Did not find an object with id {0} in the current dataset", id));
        }
        UpdateSelectionAction.updatePrimitives(Collections.singleton(primitive));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selection", new Object[0]), "updatedata", I18n.tr("Updates the currently selected objects from the server (re-downloads data)", new Object[0]), Shortcut.registerShortcut("file:updateselection", I18n.tr("File: {0}", I18n.tr("Update selection", new Object[0])), 85, 5008), true, "updateselection", true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateSelection"));
    }

    public UpdateSelectionAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, true);
    }

    @Override
    protected void updateEnabledState() {
        if (UpdateSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UpdateSelectionAction.getCurrentDataSet().getAllSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> toUpdate = this.getData();
        if (toUpdate.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected objects to update.", new Object[0]), I18n.tr("Selection empty", new Object[0]), 1);
            return;
        }
        UpdateSelectionAction.updatePrimitives(toUpdate);
    }

    public Collection<OsmPrimitive> getData() {
        return UpdateSelectionAction.getCurrentDataSet().getAllSelected();
    }
}

