/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.RemoveNodesCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnJoinNodeWayAction
extends JosmAction {
    public UnJoinNodeWayAction() {
        super(I18n.tr("Disconnect Node from Way", new Object[0]), "unjoinnodeway", I18n.tr("Disconnect nodes from a way they currently belong to", new Object[0]), Shortcut.registerShortcut("tools:unjoinnodeway", I18n.tr("Tool: {0}", I18n.tr("Disconnect Node from Way", new Object[0])), 74, 5004), true);
        this.putValue("help", HelpUtil.ht("/Action/UnJoinNodeWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = UnJoinNodeWayAction.getCurrentDataSet().getSelected();
        List<Node> selectedNodes = OsmPrimitive.getFilteredList(selection, Node.class);
        List<Way> selectedWays = OsmPrimitive.getFilteredList(selection, Way.class);
        List<Way> applicableWays = this.getApplicableWays(selectedWays, selectedNodes);
        if (applicableWays == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Select at least one node to be disconnected.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        if (applicableWays.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("Selected node cannot be disconnected from anything.", "Selected nodes cannot be disconnected from anything.", selectedNodes.size(), new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        if (applicableWays.size() > 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", selectedNodes.size(), new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        if (applicableWays.get(0).getRealNodesCount() < selectedNodes.size() + 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("The affected way would disappear after disconnecting the selected node.", "The affected way would disappear after disconnecting the selected nodes.", selectedNodes.size(), new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        Way selectedWay = applicableWays.get(0);
        Main.main.undoRedo.add(new RemoveNodesCommand(selectedWay, selectedNodes));
        Main.map.repaint();
    }

    private List<Way> getApplicableWays(List<Way> selectedWays, List<Node> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return null;
        }
        ArrayList<Way> result = new ArrayList<Way>(OsmPrimitive.getFilteredList(selectedNodes.get(0).getReferrers(), Way.class));
        for (int i = 1; i < selectedNodes.size(); ++i) {
            List<OsmPrimitive> ref = selectedNodes.get(i).getReferrers();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (ref.contains(it.next())) continue;
                it.remove();
            }
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (((Way)it.next()).getNodesCount() > 2) continue;
            it.remove();
        }
        if (selectedWays.isEmpty()) {
            return result;
        }
        it = result.iterator();
        while (it.hasNext()) {
            if (selectedWays.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    @Override
    protected void updateEnabledState() {
        if (UnJoinNodeWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UnJoinNodeWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

