/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnGlueAction
extends JosmAction {
    private Node selectedNode;
    private Way selectedWay;
    private Set<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways", new Object[0]), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways.", new Object[0]), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways", new Object[0])), 71, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = UnGlueAction.getCurrentDataSet().getSelected();
        String errMsg = null;
        int errorTime = Notification.TIME_DEFAULT;
        if (this.checkSelection(selection)) {
            if (!this.checkAndConfirmOutlyingUnglue()) {
                return;
            }
            int count = 0;
            for (Way w : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
                if (!w.isUsable() || w.getNodesCount() < 1) continue;
                ++count;
            }
            if (count < 2) {
                boolean selfCrossing = false;
                if (count == 1) {
                    selfCrossing = this.unglueSelfCrossingWay();
                }
                if (!selfCrossing) {
                    if (this.checkForUnglueNode(selection)) {
                        this.unglueNode(e);
                    } else {
                        errorTime = Notification.TIME_SHORT;
                        errMsg = I18n.tr("This node is not glued to anything else.", new Object[0]);
                    }
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelection2(selection)) {
            if (!this.checkAndConfirmOutlyingUnglue()) {
                return;
            }
            HashSet<Node> tmpNodes = new HashSet<Node>();
            for (Node n : this.selectedNodes) {
                int count = 0;
                for (Way w : OsmPrimitive.getFilteredList(n.getReferrers(), Way.class)) {
                    if (!w.isUsable()) continue;
                    ++count;
                }
                if (count < 2) continue;
                tmpNodes.add(n);
            }
            if (tmpNodes.size() < 1) {
                errMsg = selection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.", new Object[0]) : I18n.tr("None of this way''s nodes are glued to anything else.", new Object[0]);
            } else {
                this.selectedNodes = tmpNodes;
                this.unglueWays2();
            }
        } else {
            errorTime = Notification.TIME_VERY_LONG;
            errMsg = I18n.tr("The current selection cannot be used for unglueing.", new Object[0]) + "\n" + "\n" + I18n.tr("Select either:", new Object[0]) + "\n" + I18n.tr("* One tagged node, or", new Object[0]) + "\n" + I18n.tr("* One node that is used by more than one way, or", new Object[0]) + "\n" + I18n.tr("* One node that is used by more than one way and one of those ways, or", new Object[0]) + "\n" + I18n.tr("* One way that has one or more nodes that are used by more than one way, or", new Object[0]) + "\n" + I18n.tr("* One way and one or more of its nodes that are used by more than one way.", new Object[0]) + "\n" + "\n" + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.", new Object[0]);
        }
        if (errMsg != null) {
            new Notification(errMsg).setIcon(0).setDuration(errorTime).show();
        }
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    private void unglueNode(ActionEvent e) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node c = new Node(this.selectedNode);
        c.removeAll();
        UnGlueAction.getCurrentDataSet().clearSelection(c);
        cmds.add(new ChangeCommand(this.selectedNode, c));
        Node n = new Node(this.selectedNode, true);
        if (e.getSource() instanceof JPanel) {
            MapView mv = Main.map.mapView;
            n.setCoor(mv.getLatLon(mv.lastMEvent.getX(), mv.lastMEvent.getY()));
        }
        cmds.add(new AddCommand(n));
        this.fixRelations(this.selectedNode, cmds, Collections.singletonList(n));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Unglued Node", new Object[0]), cmds));
        UnGlueAction.getCurrentDataSet().setSelected(n);
        Main.map.mapView.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() != 1) {
            return false;
        }
        OsmPrimitive n = (OsmPrimitive)selection.toArray()[0];
        if (!(n instanceof Node)) {
            return false;
        }
        if (OsmPrimitive.getFilteredList(n.getReferrers(), Way.class).isEmpty()) {
            return false;
        }
        this.selectedNode = (Node)n;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        int size = selection.size();
        if (size < 1 || size > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (size != 1 && this.selectedWay == null) continue;
                return size == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (size != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelection2(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() < 1) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node n = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(n)) {
                return false;
            }
            this.selectedNodes.add(n);
        }
        if (this.selectedNodes.size() < 1) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private Way modifyWay(Node originalNode, Way w, List<Command> cmds, List<Node> newNodes) {
        Node newNode = new Node(originalNode, true);
        newNodes.add(newNode);
        cmds.add(new AddCommand(newNode));
        ArrayList<Node> nn = new ArrayList<Node>();
        for (Node pushNode : w.getNodes()) {
            if (originalNode == pushNode) {
                pushNode = newNode;
            }
            nn.add(pushNode);
        }
        Way newWay = new Way(w);
        newWay.setNodes(nn);
        return newWay;
    }

    private void fixRelations(Node originalNode, List<Command> cmds, List<Node> newNodes) {
        for (Relation r : OsmPrimitive.getFilteredList(originalNode.getReferrers(), Relation.class)) {
            if (r.isDeleted()) continue;
            Relation newRel = null;
            HashMap<String, Integer> rolesToReAdd = null;
            int i = 0;
            for (RelationMember rm : r.getMembers()) {
                if (rm.isNode() && rm.getMember() == originalNode) {
                    if (newRel == null) {
                        newRel = new Relation(r);
                        rolesToReAdd = new HashMap<String, Integer>();
                    }
                    rolesToReAdd.put(rm.getRole(), i);
                }
                ++i;
            }
            if (newRel == null) continue;
            for (Node n : newNodes) {
                for (Map.Entry role : rolesToReAdd.entrySet()) {
                    newRel.addMember((Integer)role.getValue() + 1, new RelationMember((String)role.getKey(), n));
                }
            }
            cmds.add(new ChangeCommand(r, newRel));
        }
    }

    private void unglueWays() {
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> newNodes = new LinkedList<Node>();
        if (this.selectedWay == null) {
            Way wayWithSelectedNode = null;
            LinkedList<Way> parentWays = new LinkedList<Way>();
            for (OsmPrimitive osm : this.selectedNode.getReferrers()) {
                if (!osm.isUsable() || !(osm instanceof Way)) continue;
                Way w = (Way)osm;
                if (wayWithSelectedNode == null && !w.isFirstLastNode(this.selectedNode)) {
                    wayWithSelectedNode = w;
                    continue;
                }
                parentWays.add(w);
            }
            if (wayWithSelectedNode == null) {
                parentWays.removeFirst();
            }
            for (Way w : parentWays) {
                cmds.add(new ChangeCommand(w, this.modifyWay(this.selectedNode, w, cmds, newNodes)));
            }
        } else {
            cmds.add(new ChangeCommand(this.selectedWay, this.modifyWay(this.selectedNode, this.selectedWay, cmds, newNodes)));
        }
        this.fixRelations(this.selectedNode, cmds, newNodes);
        this.execCommands(cmds, newNodes);
    }

    private void execCommands(List<Command> cmds, List<Node> newNodes) {
        Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Dupe into {0} node", "Dupe into {0} nodes", newNodes.size() + 1, newNodes.size() + 1), cmds));
        UnGlueAction.getCurrentDataSet().setSelected(newNodes.get(0));
    }

    private boolean unglueSelfCrossingWay() {
        LinkedList<Command> cmds = new LinkedList<Command>();
        Way way = null;
        for (Way w : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            way = w;
        }
        List<Node> oldNodes = way.getNodes();
        ArrayList<Node> newNodes = new ArrayList<Node>(oldNodes.size());
        ArrayList<Node> addNodes = new ArrayList<Node>();
        boolean seen = false;
        for (Node n : oldNodes) {
            if (n == this.selectedNode) {
                if (seen) {
                    Node newNode = new Node(n, true);
                    newNodes.add(newNode);
                    cmds.add(new AddCommand(newNode));
                    newNodes.add(newNode);
                    addNodes.add(newNode);
                    continue;
                }
                newNodes.add(n);
                seen = true;
                continue;
            }
            newNodes.add(n);
        }
        if (addNodes.isEmpty()) {
            return false;
        }
        cmds.add(new ChangeNodesCommand(way, newNodes));
        this.fixRelations(this.selectedNode, cmds, addNodes);
        this.execCommands(cmds, addNodes);
        return true;
    }

    private void unglueWays2() {
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> allNewNodes = new LinkedList<Node>();
        Way tmpWay = this.selectedWay;
        for (Node n : this.selectedNodes) {
            LinkedList<Node> newNodes = new LinkedList<Node>();
            tmpWay = this.modifyWay(n, tmpWay, cmds, newNodes);
            this.fixRelations(n, cmds, newNodes);
            allNewNodes.addAll(newNodes);
        }
        cmds.add(new ChangeCommand(this.selectedWay, tmpWay));
        Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), this.selectedNodes.size() + allNewNodes.size()), cmds));
        UnGlueAction.getCurrentDataSet().setSelected(allNewNodes);
    }

    @Override
    protected void updateEnabledState() {
        if (UnGlueAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UnGlueAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    protected boolean checkAndConfirmOutlyingUnglue() {
        ArrayList<Node> primitives = new ArrayList<Node>(2 + (this.selectedNodes == null ? 0 : this.selectedNodes.size()));
        if (this.selectedNodes != null) {
            primitives.addAll(this.selectedNodes);
        }
        if (this.selectedNode != null) {
            primitives.add(this.selectedNode);
        }
        return Command.checkAndConfirmOutlyingOperation("unglue", I18n.tr("Unglue confirmation", new Object[0]), I18n.tr("You are about to unglue nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to unglue?", new Object[0]), I18n.tr("You are about to unglue incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to unglue?", new Object[0]), primitives, null);
    }
}

