/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class ToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();

    public ToggleAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        super(name, icon, tooltip, shortcut, registerInToolbar, toolbarId, installAdapters);
        this.setSelected(false);
    }

    public ToggleAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar);
        this.setSelected(false);
    }

    protected final void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public final boolean isSelected() {
        Object selected = this.getValue("SwingSelectedKey");
        if (selected instanceof Boolean) {
            return (Boolean)selected;
        }
        Main.warn(this.getClass().getName() + " does not define a boolean for SELECTED_KEY but " + selected + ". You should report it to JOSM developers.");
        return false;
    }

    public final void addButtonModel(ButtonModel model) {
        if (model != null && !this.buttonModels.contains(model)) {
            this.buttonModels.add(model);
            model.setSelected(this.isSelected());
        }
    }

    public final void removeButtonModel(ButtonModel model) {
        if (model != null && this.buttonModels.contains(model)) {
            this.buttonModels.remove(model);
        }
    }

    protected void notifySelectedState() {
        boolean selected = this.isSelected();
        for (ButtonModel model : this.buttonModels) {
            if (model.isSelected() == selected) continue;
            model.setSelected(selected);
        }
    }

    protected final void toggleSelectedState(ActionEvent e) {
        if (!(e != null && (e.getSource() instanceof JToggleButton || e.getSource() instanceof JCheckBox || e.getSource() instanceof JRadioButton || e.getSource() instanceof JCheckBoxMenuItem || e.getSource() instanceof JRadioButtonMenuItem))) {
            this.setSelected(!this.isSelected());
        }
    }
}

