/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way", new Object[0]), "splitway", I18n.tr("Split a way at the selected node.", new Object[0]), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way", new Object[0])), 80, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = SplitWayAction.getCurrentDataSet().getSelected();
        List<Node> selectedNodes = OsmPrimitive.getFilteredList(selection, Node.class);
        List<Way> selectedWays = OsmPrimitive.getFilteredList(selection, Way.class);
        List<Relation> selectedRelations = OsmPrimitive.getFilteredList(selection, Relation.class);
        List<Way> applicableWays = this.getApplicableWays(selectedWays, selectedNodes);
        if (applicableWays == null) {
            new Notification(I18n.tr("The current selection cannot be used for splitting - no node is selected.", new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.tr("The selected nodes do not share the same way.", new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.size() > 1) {
            Iterator<Way> it = applicableWays.iterator();
            block0: while (it.hasNext()) {
                Way w = it.next();
                for (Node n : selectedNodes) {
                    if (w.isInnerNode(n)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", selectedNodes.size(), new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.size() > 1) {
            new Notification(I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", selectedNodes.size(), new Object[0])).setIcon(2).show();
            return;
        }
        Way selectedWay = applicableWays.get(0);
        List<List<Node>> wayChunks = SplitWayAction.buildSplitChunks(selectedWay, selectedNodes);
        if (wayChunks != null) {
            ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>(selectedWays.size() + selectedRelations.size());
            sel.addAll(selectedWays);
            sel.addAll(selectedRelations);
            SplitWayResult result = SplitWayAction.splitWay(SplitWayAction.getEditLayer(), selectedWay, wayChunks, sel);
            Main.main.undoRedo.add(result.getCommand());
            SplitWayAction.getCurrentDataSet().setSelected(result.getNewSelection());
        }
    }

    private List<Way> getApplicableWays(List<Way> selectedWays, List<Node> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return null;
        }
        if (selectedNodes.size() == 1) {
            Node n = selectedNodes.get(0);
            List<Way> referedWays = OsmPrimitive.getFilteredList(n.getReferrers(), Way.class);
            Way inTheMiddle = null;
            boolean foundSelected = false;
            for (Way w : referedWays) {
                if (selectedWays.contains(w)) {
                    foundSelected = true;
                }
                if (w.getNode(0) == n || w.getNode(w.getNodesCount() - 1) == n) continue;
                if (inTheMiddle == null) {
                    inTheMiddle = w;
                    continue;
                }
                inTheMiddle = null;
                break;
            }
            if (foundSelected && inTheMiddle != null) {
                return Collections.singletonList(inTheMiddle);
            }
        }
        ArrayList<Way> result = new ArrayList<Way>(OsmPrimitive.getFilteredList(selectedNodes.get(0).getReferrers(), Way.class));
        for (int i = 1; i < selectedNodes.size(); ++i) {
            List<OsmPrimitive> ref = selectedNodes.get(i).getReferrers();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (ref.contains(it.next())) continue;
                it.remove();
            }
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (((Way)it.next()).getNodesCount() > 2) continue;
            it.remove();
        }
        if (selectedWays.isEmpty()) {
            return result;
        }
        it = result.iterator();
        while (it.hasNext()) {
            if (selectedWays.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    public static List<List<Node>> buildSplitChunks(Way wayToSplit, List<Node> splitPoints) {
        CheckParameterUtil.ensureParameterNotNull(wayToSplit, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(splitPoints, "splitPoints");
        HashSet<Node> nodeSet = new HashSet<Node>(splitPoints);
        LinkedList<List<Node>> wayChunks = new LinkedList<List<Node>>();
        ArrayList<Node> currentWayChunk = new ArrayList<Node>();
        wayChunks.add(currentWayChunk);
        Iterator<Node> it = wayToSplit.getNodes().iterator();
        while (it.hasNext()) {
            Node currentNode = it.next();
            boolean atEndOfWay = currentWayChunk.isEmpty() || !it.hasNext();
            currentWayChunk.add(currentNode);
            if (!nodeSet.contains(currentNode) || atEndOfWay) continue;
            currentWayChunk = new ArrayList();
            currentWayChunk.add(currentNode);
            wayChunks.add(currentWayChunk);
        }
        List lastWayChunk = (List)wayChunks.get(wayChunks.size() - 1);
        if (wayChunks.size() >= 2 && ((List)wayChunks.get(0)).get(0) == lastWayChunk.get(lastWayChunk.size() - 1) && !nodeSet.contains(((List)wayChunks.get(0)).get(0))) {
            if (wayChunks.size() == 2) {
                new Notification(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0])).setIcon(2).show();
                return null;
            }
            lastWayChunk.remove(lastWayChunk.size() - 1);
            lastWayChunk.addAll((Collection)wayChunks.get(0));
            wayChunks.remove(wayChunks.size() - 1);
            wayChunks.set(0, lastWayChunk);
        }
        if (wayChunks.size() < 2) {
            if (((List)wayChunks.get(0)).get(0) == ((List)wayChunks.get(0)).get(((List)wayChunks.get(0)).size() - 1)) {
                new Notification(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0])).setIcon(2).show();
            } else {
                new Notification(I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)", new Object[0])).setIcon(2).show();
            }
            return null;
        }
        return wayChunks;
    }

    public static SplitWayResult splitWay(OsmDataLayer layer, Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection) {
        ArrayList<Command> commandList = new ArrayList<Command>(wayChunks.size());
        ArrayList<? extends OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(selection.size() + wayChunks.size());
        newSelection.addAll(selection);
        Iterator<List<Node>> chunkIt = wayChunks.iterator();
        Collection<String> nowarnroles = Main.pref.getCollection("way.split.roles.nowarn", Arrays.asList("outer", "inner", "forward", "backward", "north", "south", "east", "west"));
        Way changedWay = new Way(way);
        changedWay.setNodes(chunkIt.next());
        commandList.add(new ChangeCommand(way, changedWay));
        if (!newSelection.contains(way)) {
            newSelection.add(way);
        }
        ArrayList<Way> newWays = new ArrayList<Way>();
        while (chunkIt.hasNext()) {
            Way wayToAdd = new Way();
            wayToAdd.setKeys(way.getKeys());
            newWays.add(wayToAdd);
            wayToAdd.setNodes(chunkIt.next());
            commandList.add(new AddCommand(layer, wayToAdd));
            newSelection.add(wayToAdd);
        }
        boolean warnmerole = false;
        boolean warnme = false;
        for (Relation r : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!r.isUsable()) continue;
            Relation c = null;
            String type = r.get("type");
            if (type == null) {
                type = "";
            }
            int i_c = 0;
            int i_r = 0;
            List<RelationMember> relationMembers = r.getMembers();
            for (RelationMember rm : relationMembers) {
                if (rm.isWay() && rm.getMember() == way) {
                    boolean insert = true;
                    if ("restriction".equals(type)) {
                        String role = rm.getRole();
                        if ("from".equals(role) || "to".equals(role)) {
                            OsmPrimitive via = null;
                            for (RelationMember rmv : r.getMembers()) {
                                if (!"via".equals(rmv.getRole())) continue;
                                via = rmv.getMember();
                            }
                            ArrayList<Node> nodes = new ArrayList<Node>();
                            if (via != null) {
                                if (via instanceof Node) {
                                    nodes.add((Node)via);
                                } else if (via instanceof Way) {
                                    nodes.add(((Way)via).lastNode());
                                    nodes.add(((Way)via).firstNode());
                                }
                            }
                            Way res = null;
                            for (Node n : nodes) {
                                if (!changedWay.isFirstLastNode(n)) continue;
                                res = way;
                            }
                            if (res == null) {
                                for (Way wayToAdd : newWays) {
                                    for (Node n : nodes) {
                                        if (!wayToAdd.isFirstLastNode(n)) continue;
                                        res = wayToAdd;
                                    }
                                }
                                if (res != null) {
                                    if (c == null) {
                                        c = new Relation(r);
                                    }
                                    c.addMember(new RelationMember(role, res));
                                    c.removeMembersFor(way);
                                    insert = false;
                                }
                            } else {
                                insert = false;
                            }
                        } else if (!"via".equals(role)) {
                            warnme = true;
                        }
                    } else if (!"route".equals(type) && !"multipolygon".equals(type)) {
                        warnme = true;
                    }
                    if (c == null) {
                        c = new Relation(r);
                    }
                    if (insert) {
                        if (rm.hasRole() && !nowarnroles.contains(rm.getRole())) {
                            warnmerole = true;
                        }
                        Boolean backwards = null;
                        int k = 1;
                        while (i_r - k >= 0 || i_r + k < relationMembers.size()) {
                            Way w;
                            if (i_r - k >= 0 && relationMembers.get(i_r - k).isWay()) {
                                w = relationMembers.get(i_r - k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = false;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = true;
                                break;
                            }
                            if (i_r + k < relationMembers.size() && relationMembers.get(i_r + k).isWay()) {
                                w = relationMembers.get(i_r + k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = true;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = false;
                                break;
                            }
                            ++k;
                        }
                        int j = i_c;
                        for (Way wayToAdd : newWays) {
                            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
                            ++j;
                            if (backwards != null && backwards.booleanValue()) {
                                c.addMember(i_c, em);
                                continue;
                            }
                            c.addMember(j, em);
                        }
                        i_c = j;
                    }
                }
                ++i_c;
                ++i_r;
            }
            if (c == null) continue;
            commandList.add(new ChangeCommand(layer, r, c));
        }
        if (warnmerole) {
            new Notification(I18n.tr("A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0])).setIcon(2).show();
        } else if (warnme) {
            new Notification(I18n.tr("A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0])).setIcon(2).show();
        }
        return new SplitWayResult(new SequenceCommand(I18n.trn("Split way {0} into {1} part", "Split way {0} into {1} parts", wayChunks.size(), way.getDisplayName(DefaultNameFormatter.getInstance()), wayChunks.size()), commandList), newSelection, way, newWays);
    }

    public static SplitWayResult split(OsmDataLayer layer, Way way, List<Node> atNodes, Collection<? extends OsmPrimitive> selection) {
        List<List<Node>> chunks = SplitWayAction.buildSplitChunks(way, atNodes);
        if (chunks == null) {
            return null;
        }
        return SplitWayAction.splitWay(layer, way, chunks, selection);
    }

    @Override
    protected void updateEnabledState() {
        if (SplitWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SplitWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;
        private Way originalWay;
        private List<Way> newWays;

        public SplitWayResult(Command command, List<? extends PrimitiveId> newSelection, Way originalWay, List<Way> newWays) {
            this.command = command;
            this.newSelection = newSelection;
            this.originalWay = originalWay;
            this.newWays = newWays;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }

        public Way getOriginalWay() {
            return this.originalWay;
        }

        public List<Way> getNewWays() {
            return this.newWays;
        }
    }
}

