/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class SimplifyWayAction
extends JosmAction {
    public static final double EARTH_RAD = 6378137.0;

    public SimplifyWayAction() {
        super(I18n.tr("Simplify Way", new Object[0]), "simplify", I18n.tr("Delete unnecessary nodes from a way.", new Object[0]), Shortcut.registerShortcut("tools:simplify", I18n.tr("Tool: {0}", I18n.tr("Simplify Way", new Object[0])), 89, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/SimplifyWay"));
    }

    protected boolean confirmWayWithNodesOutsideBoundingBox(List<? extends OsmPrimitive> primitives) {
        return DeleteCommand.checkAndConfirmOutlyingDelete(primitives, null);
    }

    protected void alertSelectAtLeastOneWay() {
        new Notification(I18n.tr("Please select at least one way to simplify.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).setHelpTopic(HelpUtil.ht("/Action/SimplifyWay#SelectAWayToSimplify")).show();
    }

    protected boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes", new Object[0]), ImageProvider.get("ok"), I18n.tr("Simplify all selected ways", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Cancel operation", new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("The selection contains {0} ways. Are you sure you want to simplify them all?", numWays), I18n.tr("Simplify ways?", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Action/SimplifyWay#ConfirmSimplifyAll"));
        return ret == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = SimplifyWayAction.getCurrentDataSet();
        ds.beginUpdate();
        try {
            List<Way> ways = OsmPrimitive.getFilteredList(ds.getSelected(), Way.class);
            if (ways.isEmpty()) {
                this.alertSelectAtLeastOneWay();
                return;
            }
            if (!this.confirmWayWithNodesOutsideBoundingBox(ways)) {
                return;
            }
            if (ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
                return;
            }
            LinkedList<Command> allCommands = new LinkedList<Command>();
            for (Way way : ways) {
                SequenceCommand simplifyCommand = this.simplifyWay(way);
                if (simplifyCommand == null) continue;
                allCommands.add(simplifyCommand);
            }
            if (allCommands.isEmpty()) {
                return;
            }
            SequenceCommand rootCommand = new SequenceCommand(I18n.trn("Simplify {0} way", "Simplify {0} ways", allCommands.size(), allCommands.size()), allCommands);
            Main.main.undoRedo.add(rootCommand);
        }
        finally {
            ds.endUpdate();
        }
        Main.map.repaint();
    }

    protected boolean isRequiredNode(Way way, Node node) {
        boolean isRequired;
        boolean bl = isRequired = Collections.frequency(way.getNodes(), node) > 1;
        if (!isRequired) {
            LinkedList<OsmPrimitive> parents = new LinkedList<OsmPrimitive>();
            parents.addAll(node.getReferrers());
            parents.remove(way);
            boolean bl2 = isRequired = !parents.isEmpty();
        }
        if (!isRequired) {
            isRequired = node.isTagged();
        }
        return isRequired;
    }

    public final SequenceCommand simplifyWay(Way w) {
        return this.simplifyWay(w, Main.pref.getDouble("simplify-way.max-error", 3.0));
    }

    public SequenceCommand simplifyWay(Way w, double threshold) {
        int lower = 0;
        int i = 0;
        ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
        while (i < w.getNodesCount()) {
            if (this.isRequiredNode(w, w.getNode(i))) {
                newNodes.add(w.getNode(i));
                ++i;
                ++lower;
                continue;
            }
            ++i;
            while (i < w.getNodesCount() && !this.isRequiredNode(w, w.getNode(i))) {
                ++i;
            }
            this.buildSimplifiedNodeList(w.getNodes(), lower, Math.min(w.getNodesCount() - 1, i), threshold, newNodes);
            lower = i++;
        }
        HashSet<Node> delNodes = new HashSet<Node>();
        delNodes.addAll(w.getNodes());
        delNodes.removeAll(newNodes);
        if (delNodes.isEmpty()) {
            return null;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        Way newWay = new Way(w);
        newWay.setNodes(newNodes);
        cmds.add(new ChangeCommand(w, newWay));
        cmds.add(new DeleteCommand(delNodes));
        w.getDataSet().clearSelection(delNodes);
        return new SequenceCommand(I18n.trn("Simplify Way (remove {0} node)", "Simplify Way (remove {0} nodes)", delNodes.size(), delNodes.size()), cmds);
    }

    protected void buildSimplifiedNodeList(List<Node> wnew, int from, int to, double threshold, List<Node> simplifiedNodes) {
        Node fromN = wnew.get(from);
        Node toN = wnew.get(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = wnew.get(i);
            double xte = Math.abs(6378137.0 * SimplifyWayAction.xtd(fromN.getCoor().lat() * Math.PI / 180.0, fromN.getCoor().lon() * Math.PI / 180.0, toN.getCoor().lat() * Math.PI / 180.0, toN.getCoor().lon() * Math.PI / 180.0, n.getCoor().lat() * Math.PI / 180.0, n.getCoor().lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= threshold) {
            this.buildSimplifiedNodeList(wnew, from, imax, threshold, simplifiedNodes);
            this.buildSimplifiedNodeList(wnew, imax, to, threshold, simplifiedNodes);
        } else {
            if (simplifiedNodes.isEmpty() || simplifiedNodes.get(simplifiedNodes.size() - 1) != fromN) {
                simplifiedNodes.add(fromN);
            }
            if (fromN != toN) {
                simplifiedNodes.add(toN);
            }
        }
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    public static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    public static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double distAD = SimplifyWayAction.dist(lat1, lon1, lat3, lon3);
        double crsAD = SimplifyWayAction.course(lat1, lon1, lat3, lon3);
        double crsAB = SimplifyWayAction.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(distAD) * Math.sin(crsAD - crsAB));
    }

    @Override
    protected void updateEnabledState() {
        if (SimplifyWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SimplifyWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

