/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReportBugAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    private static void shortenParam(ListIterator<String> it, String[] param, String source, String target) {
        if (source != null && target.length() < source.length() && param[1].startsWith(source)) {
            it.set(param[0] + "=" + param[1].replace(source, target));
        }
    }

    public static String getReportHeader() {
        DataSet dataset;
        StringBuilder text = new StringBuilder();
        text.append(Version.getInstance().getReleaseAttributes());
        text.append("\n");
        text.append("Identification: " + Version.getInstance().getAgentString());
        text.append("\n");
        text.append("Memory Usage: ");
        text.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        text.append(" MB / ");
        text.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        text.append(" MB (");
        text.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        text.append(" MB allocated, but free)");
        text.append("\n");
        text.append("Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("java.vm.name"));
        text.append("\n");
        if (Main.platform.getClass() == PlatformHookUnixoid.class) {
            String webStartDetails;
            String packageDetails = ((PlatformHookUnixoid)Main.platform).getJavaPackageDetails();
            if (packageDetails != null) {
                text.append("Java package: ");
                text.append(packageDetails);
                text.append("\n");
            }
            if (Package.getPackage("javax.jnlp") != null && (webStartDetails = ((PlatformHookUnixoid)Main.platform).getWebStartPackageDetails()) != null) {
                text.append("WebStart package: ");
                text.append(webStartDetails);
                text.append("\n");
            }
        }
        try {
            String envJavaHome = System.getenv("JAVA_HOME");
            String envJavaHomeAlt = Main.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}";
            String propJavaHome = System.getProperty("java.home");
            String propJavaHomeAlt = "<java.home>";
            ArrayList<String> vmArguments = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
            ListIterator<String> it = vmArguments.listIterator();
            while (it.hasNext()) {
                String value = (String)it.next();
                if (value.contains("=")) {
                    String[] param = value.split("=");
                    if (param[0].toLowerCase().startsWith("-dproxy")) {
                        it.set(param[0] + "=xxx");
                        continue;
                    }
                    ShowStatusReportAction.shortenParam(it, param, envJavaHome, envJavaHomeAlt);
                    ShowStatusReportAction.shortenParam(it, param, propJavaHome, "<java.home>");
                    continue;
                }
                if (!value.startsWith("-X")) continue;
                it.remove();
            }
            if (!vmArguments.isEmpty()) {
                text.append("VM arguments: " + ((Object)vmArguments).toString().replace("\\\\", "\\"));
                text.append("\n");
            }
        }
        catch (SecurityException envJavaHome) {
            // empty catch block
        }
        if (Main.commandLineArgs.length > 0) {
            text.append("Program arguments: " + Arrays.toString(Main.commandLineArgs));
            text.append("\n");
        }
        if (Main.main != null && (dataset = Main.main.getCurrentDataSet()) != null) {
            String result = DatasetConsistencyTest.runTests(dataset);
            if (result.length() == 0) {
                text.append("Dataset consistency test: No problems found\n");
            } else {
                text.append("\nDataset consistency test:\n" + result + "\n");
            }
        }
        text.append("\n");
        text.append(PluginHandler.getBugReportText());
        text.append("\n");
        Collection<String> errorsWarnings = Main.getLastErrorAndWarnings();
        if (!errorsWarnings.isEmpty()) {
            text.append("Last errors/warnings:\n");
            for (String s : errorsWarnings) {
                text.append("- ").append(s).append("\n");
            }
            text.append("\n");
        }
        return text.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder text = new StringBuilder();
        String reportHeader = ShowStatusReportAction.getReportHeader();
        text.append(reportHeader);
        try {
            Map<String, Preferences.Setting<?>> settings = Main.pref.getAllSettings();
            HashSet<String> keys = new HashSet<String>(settings.keySet());
            for (String string : keys) {
                if (!string.startsWith("marker.show") && !string.contains("username") && !string.contains("password") && !string.contains("access-token")) continue;
                settings.remove(string);
            }
            for (Map.Entry entry : settings.entrySet()) {
                text.append((String)entry.getKey()).append("=").append(((Preferences.Setting)entry.getValue()).getValue().toString()).append("\n");
            }
        }
        catch (Exception x) {
            Main.error(x);
        }
        JosmTextArea ta = new JosmTextArea(text.toString());
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        ta.setEditable(false);
        JScrollPane sp = new JScrollPane(ta);
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Status Report", new Object[0]), new String[]{I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0])});
        ed.setButtonIcons(new String[]{"copy", "bug", "cancel"});
        ed.setContent(sp, false);
        ed.setMinimumSize(new Dimension(380, 200));
        ed.setPreferredSize(new Dimension(700, Main.parent.getHeight() - 50));
        switch (ed.showDialog().getValue()) {
            case 1: {
                Utils.copyToClipboard(text.toString());
                break;
            }
            case 2: {
                ReportBugAction.reportBug(reportHeader);
            }
        }
    }
}

