/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class SessionLoadAction
extends DiskAccessAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionLoad"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractFileChooser fc = SessionLoadAction.createAndOpenFileChooser(true, false, I18n.tr("Open session", new Object[0]), Arrays.asList(SessionImporter.FILE_FILTER, FileFilterAllFiles.getInstance()), SessionImporter.FILE_FILTER, 0, "lastDirectory");
        if (fc == null) {
            return;
        }
        File file = fc.getSelectedFile();
        boolean zip = file.getName().toLowerCase().endsWith(".joz");
        Main.worker.submit(new Loader(file, zip));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private final URI uri;
        private final InputStream is;
        private final boolean zip;
        private List<Layer> layers;
        private Layer active;
        private List<Runnable> postLoadTasks;
        private ViewportData viewport;

        public Loader(File file, boolean zip) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            this.file = file;
            this.uri = null;
            this.is = null;
            this.zip = zip;
        }

        public Loader(InputStream is, URI uri, boolean zip) {
            super(I18n.tr("Loading session ''{0}''", uri));
            CheckParameterUtil.ensureParameterNotNull(is, "is");
            CheckParameterUtil.ensureParameterNotNull(uri, "uri");
            this.file = null;
            this.uri = uri;
            this.is = is;
            this.zip = zip;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Loader.this.canceled) {
                        return;
                    }
                    if (!Loader.this.layers.isEmpty()) {
                        boolean noMap;
                        Layer firstLayer = (Layer)Loader.this.layers.iterator().next();
                        boolean bl = noMap = Main.map == null;
                        if (noMap) {
                            Main.main.createMapFrame(firstLayer, Loader.this.viewport);
                        }
                        for (Layer l : Loader.this.layers) {
                            if (Loader.this.canceled) {
                                return;
                            }
                            Main.main.addLayer(l);
                        }
                        if (Loader.this.active != null) {
                            Main.map.mapView.setActiveLayer(Loader.this.active);
                        }
                        if (noMap) {
                            Main.map.setVisible(true);
                        }
                    }
                    for (Runnable task : Loader.this.postLoadTasks) {
                        if (Loader.this.canceled) {
                            return;
                        }
                        if (task == null) continue;
                        task.run();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() {
            try {
                ProgressMonitor monitor = this.getProgressMonitor();
                SessionReader reader = new SessionReader();
                boolean tempFile = false;
                try {
                    if (this.file == null) {
                        this.file = File.createTempFile("session_", ".joz", Utils.getJosmTempDir());
                        tempFile = true;
                        try (FileOutputStream out = new FileOutputStream(this.file);){
                            Utils.copyStream(this.is, out);
                        }
                    }
                    reader.loadSession(this.file, this.zip, monitor);
                    this.layers = reader.getLayers();
                    this.active = reader.getActive();
                    this.postLoadTasks = reader.getPostLoadTasks();
                    this.viewport = reader.getViewport();
                }
                finally {
                    if (tempFile) {
                        if (!this.file.delete()) {
                            this.file.deleteOnExit();
                        }
                        this.file = null;
                    }
                }
            }
            catch (IllegalDataException e) {
                this.handleException(I18n.tr("Data Error", new Object[0]), e);
            }
            catch (IOException e) {
                this.handleException(I18n.tr("IO Error", new Object[0]), e);
            }
            catch (Exception e) {
                this.cancel();
                throw e;
            }
        }

        private void handleException(String dialogTitle, Exception e) {
            Main.error(e);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.uri != null ? this.uri : this.file.getName(), e.getMessage()), dialogTitle, 0, null);
            this.cancel();
        }
    }
}

