/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public class SelectByInternalPointAction
extends JosmAction {
    public static Collection<OsmPrimitive> getSurroundingObjects(EastNorth internalPoint) {
        DataSet ds = SelectByInternalPointAction.getCurrentDataSet();
        if (ds == null) {
            return Collections.emptySet();
        }
        Node n = new Node(internalPoint);
        TreeMap<Double, OsmPrimitive> found = new TreeMap<Double, OsmPrimitive>();
        for (Way w : ds.getWays()) {
            if (!w.isUsable() || !w.isClosed() || !w.isSelectable() || !Geometry.nodeInsidePolygon(n, w.getNodes())) continue;
            found.put(Geometry.closedWayArea(w), w);
        }
        for (Relation r : ds.getRelations()) {
            if (!r.isUsable() || !r.isMultipolygon() || !Geometry.isNodeInsideMultiPolygon(n, r, null)) continue;
            for (RelationMember m : r.getMembers()) {
                if (!m.isWay() || !m.getWay().isClosed()) continue;
                found.values().remove(m.getWay());
            }
            BBox bBox = r.getBBox();
            EastNorth en1 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getTopLeft());
            EastNorth en2 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getBottomRight());
            double s = Math.abs((en1.east() - en2.east()) * (en1.north() - en2.north()));
            if (s == 0.0) {
                s = 1.0E8;
            }
            found.put(s, r);
        }
        return found.values();
    }

    public static OsmPrimitive getSmallestSurroundingObject(EastNorth internalPoint) {
        Collection<OsmPrimitive> surroundingObjects = SelectByInternalPointAction.getSurroundingObjects(internalPoint);
        return surroundingObjects.isEmpty() ? null : surroundingObjects.iterator().next();
    }

    public static void performSelection(EastNorth internalPoint, boolean doAdd, boolean doRemove) {
        Collection<OsmPrimitive> surroundingObjects = SelectByInternalPointAction.getSurroundingObjects(internalPoint);
        if (surroundingObjects.isEmpty()) {
            return;
        }
        if (doRemove) {
            ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(SelectByInternalPointAction.getCurrentDataSet().getSelected());
            newSelection.removeAll(surroundingObjects);
            SelectByInternalPointAction.getCurrentDataSet().setSelected(newSelection);
        } else if (doAdd) {
            ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(SelectByInternalPointAction.getCurrentDataSet().getSelected());
            newSelection.add(surroundingObjects.iterator().next());
            SelectByInternalPointAction.getCurrentDataSet().setSelected(newSelection);
        } else {
            SelectByInternalPointAction.getCurrentDataSet().setSelected(surroundingObjects.iterator().next());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException();
    }
}

