/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

public class SearchNotesDownloadAction
extends JosmAction {
    public SearchNotesDownloadAction() {
        super(I18n.tr("Search Notes...", new Object[0]), "note_search", I18n.tr("Download notes from the note search API", new Object[0]), null, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HistoryComboBox searchTermBox = new HistoryComboBox();
        LinkedList<String> searchHistory = new LinkedList<String>(Main.pref.getCollection("osm.notes.searchHistory", new LinkedList<String>()));
        Collections.reverse(searchHistory);
        searchTermBox.setPossibleItems(searchHistory);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.anchor = 23;
        contentPanel.add((Component)new JLabel(I18n.tr("Search the OSM API for notes containing words:", new Object[0])), gc);
        gc.gridy = 1;
        contentPanel.add((Component)searchTermBox, gc);
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Search for notes", new Object[0]), new String[]{I18n.tr("Search for notes", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setContent(contentPanel);
        ed.setButtonIcons(new String[]{"note_search", "cancel"});
        ed.showDialog();
        if (ed.getValue() != 1) {
            return;
        }
        String searchTerm = searchTermBox.getText();
        if (searchTerm == null || searchTerm.trim().isEmpty()) {
            Notification notification = new Notification(I18n.tr("You must enter a search term", new Object[0]));
            notification.setIcon(2);
            notification.show();
            return;
        }
        searchTermBox.addCurrentItemToHistory();
        Main.pref.putCollection("osm.notes.searchHistory", searchTermBox.getHistory());
        searchTerm = searchTerm.trim();
        int noteLimit = Main.pref.getInteger("osm.notes.downloadLimit", 1000);
        int closedLimit = Main.pref.getInteger("osm.notes.daysCloased", 7);
        StringBuilder sb = new StringBuilder();
        sb.append(OsmApi.getOsmApi().getBaseUrl());
        sb.append("notes/search?limit=");
        sb.append(noteLimit);
        sb.append("&closed=");
        sb.append(closedLimit);
        sb.append("&q=");
        try {
            sb.append(URLEncoder.encode(searchTerm, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Main.error(ex, true);
            return;
        }
        new DownloadNotesTask().loadUrl(false, sb.toString(), null);
    }
}

