/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    private File file;

    public SaveActionBase(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean saved = this.doSave();
        if (saved) {
            this.addToFileOpenHistory();
        }
    }

    public boolean doSave() {
        Layer layer;
        if (Main.isDisplayingMapView() && (layer = Main.map.mapView.getActiveLayer()) != null && layer.isSavable()) {
            return this.doSave(layer);
        }
        return false;
    }

    public boolean doSave(Layer layer) {
        if (!layer.checkSaveConditions()) {
            return false;
        }
        this.file = this.getFile(layer);
        return SaveActionBase.doInternalSave(layer, this.file);
    }

    public static boolean doSave(Layer layer, File file, boolean checkSaveConditions) {
        if (checkSaveConditions && !layer.checkSaveConditions()) {
            return false;
        }
        return SaveActionBase.doInternalSave(layer, file);
    }

    private static boolean doInternalSave(Layer layer, File file) {
        if (file == null) {
            return false;
        }
        try {
            boolean exported = false;
            boolean canceled = false;
            for (FileExporter exporter : ExtensionFileFilter.exporters) {
                if (!exporter.acceptFile(file, layer)) continue;
                exporter.exportData(file, layer);
                exported = true;
                canceled = exporter.isCanceled();
                break;
            }
            if (!exported) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No Exporter found! Nothing saved.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return false;
            }
            if (canceled) {
                return false;
            }
            layer.setName(file.getName());
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
            Main.parent.repaint();
        }
        catch (IOException e) {
            Main.error(e);
            return false;
        }
        return true;
    }

    protected abstract File getFile(Layer var1);

    @Override
    protected void updateEnabledState() {
        boolean check;
        boolean bl = check = Main.isDisplayingMapView() && Main.map.mapView.getActiveLayer() != null;
        if (!check) {
            this.setEnabled(false);
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        this.setEnabled(layer != null && layer.isSavable());
    }

    public static File createAndOpenSaveFileChooser(String title, ExtensionFileFilter filter) {
        AbstractFileChooser fc = SaveActionBase.createAndOpenFileChooser(false, false, title, filter, 0, null);
        return SaveActionBase.checkFileAndConfirmOverWrite(fc, filter.getDefaultExtension());
    }

    public static File createAndOpenSaveFileChooser(String title, String extension) {
        AbstractFileChooser fc = SaveActionBase.createAndOpenFileChooser(false, false, title, extension);
        return SaveActionBase.checkFileAndConfirmOverWrite(fc, extension);
    }

    private static File checkFileAndConfirmOverWrite(AbstractFileChooser fc, String extension) {
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        FileFilter ff = fc.getFileFilter();
        if (!ff.accept(file)) {
            for (FileFilter cff : fc.getChoosableFileFilters()) {
                if (!cff.accept(file)) continue;
                fc.setFileFilter(cff);
                return file;
            }
            String fn = file.getPath();
            if (ff instanceof ExtensionFileFilter) {
                fn = fn + "." + ((ExtensionFileFilter)ff).getDefaultExtension();
            } else if (extension != null) {
                fn = fn + "." + extension;
            }
            file = new File(fn);
            if (!SaveActionBase.confirmOverwrite(file)) {
                return null;
            }
        }
        return file;
    }

    public static boolean confirmOverwrite(File file) {
        if (file == null || file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])});
            dialog.setContent(I18n.tr("File exists. Overwrite?", new Object[0]));
            dialog.setButtonIcons(new String[]{"save_as", "cancel"});
            dialog.showDialog();
            return dialog.getValue() == 1;
        }
        return true;
    }

    protected void addToFileOpenHistory() {
        String filepath;
        try {
            filepath = this.file.getCanonicalPath();
        }
        catch (IOException ign) {
            return;
        }
        int maxsize = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
        Collection<String> oldHistory = Main.pref.getCollection("file-open.history");
        LinkedList<String> history = new LinkedList<String>(oldHistory);
        history.remove(filepath);
        history.add(0, filepath);
        Main.pref.putCollectionBounded("file-open.history", maxsize, history);
    }
}

