/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RestartAction
extends JosmAction {
    public RestartAction() {
        super(I18n.tr("Restart", new Object[0]), "restart", I18n.tr("Restart the application.", new Object[0]), Shortcut.registerShortcut("file:restart", I18n.tr("File: {0}", I18n.tr("Restart", new Object[0])), 74, 5010), false);
        this.putValue("help", HelpUtil.ht("/Action/Restart"));
        this.putValue("toolbar", "action/restart");
        Main.toolbar.register(this);
        this.setEnabled(RestartAction.isRestartSupported());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String scriptRestart = System.getProperty("josm.restart");
        if ("true".equals(scriptRestart)) {
            Main.exitJosm(true, 9);
        }
        try {
            RestartAction.restartJOSM();
        }
        catch (IOException ex) {
            Main.error(ex);
        }
    }

    public static boolean isRestartSupported() {
        return System.getProperty("sun.java.command") != null;
    }

    public static void restartJOSM() throws IOException {
        if (RestartAction.isRestartSupported() && !Main.exitJosm(false, 0)) {
            return;
        }
        try {
            final ArrayList<String> cmd = new ArrayList<String>();
            if (Main.isPlatformOsx() && System.getProperty("java.library.path").contains("/JOSM.app/Contents/MacOS")) {
                cmd.add("/usr/bin/osascript");
                for (String line : "tell application \"System Events\"\nrepeat until not (exists process \"JOSM\")\ndelay 0.2\nend repeat\nend tell\ntell application \"JOSM\" to activate".split("\n")) {
                    cmd.add("-e");
                    cmd.add(line);
                }
            } else {
                String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + (Main.isPlatformWindows() ? "java.exe" : "java");
                if (!new File(java).isFile()) {
                    throw new IOException("Unable to find suitable java runtime at " + java);
                }
                cmd.add(java);
                List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                if (Main.isDebugEnabled()) {
                    Main.debug("VM arguments: " + arguments.toString());
                }
                for (String arg : arguments) {
                    if ((arg = arg.replace("-Djnlpx.remove=true", "-Djnlpx.remove=false")).contains("-agentlib")) continue;
                    cmd.add(arg);
                }
                String[] mainCommand = System.getProperty("sun.java.command").split(" ");
                String jarPath = mainCommand[0];
                for (int i = 1; i < mainCommand.length && !jarPath.endsWith(".jar"); ++i) {
                    jarPath = jarPath + " " + mainCommand[i];
                }
                if (jarPath.endsWith(".jar")) {
                    cmd.add("-jar");
                    cmd.add(new File(jarPath).getPath());
                } else {
                    cmd.add("-cp");
                    cmd.add("\"" + System.getProperty("java.class.path") + "\"");
                    cmd.add(mainCommand[0]);
                }
                String jnlp = System.getProperty("jnlpx.origFilenameArg");
                if (jnlp != null) {
                    cmd.add(jnlp);
                }
                cmd.addAll(Arrays.asList(Main.commandLineArgs));
            }
            Main.info("Restart " + cmd);
            if (Main.isDebugEnabled() && Main.pref.getBoolean("restart.debug.simulation")) {
                Main.debug("Restart cancelled to get debug info");
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
                    }
                    catch (IOException e) {
                        Main.error(e);
                    }
                }
            });
            System.exit(0);
        }
        catch (Exception e) {
            throw new IOException("Error while trying to restart the application", e);
        }
    }

    public static HelpAwareOptionPane.ButtonSpec getRestartButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Restart", new Object[0]), ImageProvider.get("restart"), I18n.tr("Restart the application.", new Object[0]), HelpUtil.ht("/Action/Restart"), RestartAction.isRestartSupported());
    }

    public static HelpAwareOptionPane.ButtonSpec getCancelButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to restart later.", new Object[0]), null);
    }

    public static HelpAwareOptionPane.ButtonSpec[] getButtonSpecs() {
        return new HelpAwareOptionPane.ButtonSpec[]{RestartAction.getRestartButtonSpec(), RestartAction.getCancelButtonSpec()};
    }
}

