/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class PurgeAction
extends JosmAction {
    protected OsmDataLayer layer;
    JCheckBox cbClearUndoRedo;
    protected Set<OsmPrimitive> toPurge;
    protected Set<OsmPrimitive> toPurgeChecked;
    protected Set<OsmPrimitive> makeIncomplete;
    protected List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge...", new Object[0]), "purge", I18n.tr("Forget objects but do not delete them on server when uploading.", new Object[0]), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge", new Object[0])), 80, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = PurgeAction.getCurrentDataSet().getAllSelected();
        this.layer = Main.main.getEditLayer();
        this.toPurge = new HashSet<OsmPrimitive>(sel);
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        this.toPurgeChecked = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> toPurgeRecursive = new HashSet<OsmPrimitive>();
        while (!this.toPurge.isEmpty()) {
            for (OsmPrimitive osm : this.toPurge) {
                for (OsmPrimitive parent : osm.getReferrers()) {
                    if (this.toPurge.contains(parent) || this.toPurgeChecked.contains(parent) || toPurgeRecursive.contains(parent) || !(parent instanceof Way) && (!(parent instanceof Relation) || !osm.isNew())) continue;
                    this.toPurgeAdditionally.add(parent);
                    toPurgeRecursive.add(parent);
                }
                this.toPurgeChecked.add(osm);
            }
            this.toPurge = toPurgeRecursive;
            toPurgeRecursive = new HashSet();
        }
        this.makeIncomplete = new HashSet<OsmPrimitive>();
        block3: for (OsmPrimitive child : this.toPurgeChecked) {
            if (child.isNew()) continue;
            for (OsmPrimitive parent : child.getReferrers()) {
                if (!(parent instanceof Relation) || this.toPurgeChecked.contains(parent)) continue;
                this.makeIncomplete.add(child);
                continue block3;
            }
        }
        if (Main.pref.getBoolean("purge.add_untagged_waynodes", true)) {
            HashSet<Node> wayNodes = new HashSet<Node>();
            for (OsmPrimitive osm : this.toPurgeChecked) {
                if (!(osm instanceof Way)) continue;
                Way w = (Way)osm;
                block6: for (Node n : w.getNodes()) {
                    if (n.isTagged() || this.toPurgeChecked.contains(n)) continue;
                    for (OsmPrimitive ref : n.getReferrers()) {
                        if (ref == w || this.toPurgeChecked.contains(ref)) continue;
                        continue block6;
                    }
                    wayNodes.add(n);
                }
            }
            this.toPurgeChecked.addAll(wayNodes);
            this.toPurgeAdditionally.addAll(wayNodes);
        }
        if (Main.pref.getBoolean("purge.add_relations_with_only_incomplete_members", true)) {
            HashSet<Relation> relSet = new HashSet<Relation>();
            for (OsmPrimitive osm : this.toPurgeChecked) {
                for (OsmPrimitive parent : osm.getReferrers()) {
                    if (!(parent instanceof Relation) || this.toPurgeChecked.contains(parent) || !this.hasOnlyIncompleteMembers((Relation)parent, this.toPurgeChecked, relSet)) continue;
                    relSet.add((Relation)parent);
                }
            }
            ArrayList<Relation> relLst = new ArrayList<Relation>(relSet);
            for (int i = 0; i < relLst.size(); ++i) {
                for (OsmPrimitive parent : ((Relation)relLst.get(i)).getReferrers()) {
                    if (this.toPurgeChecked.contains(parent) || !this.hasOnlyIncompleteMembers((Relation)parent, this.toPurgeChecked, relLst)) continue;
                    relLst.add((Relation)parent);
                }
            }
            relSet = new HashSet(relLst);
            this.toPurgeChecked.addAll(relSet);
            this.toPurgeAdditionally.addAll(relSet);
        }
        boolean modified = false;
        for (OsmPrimitive osm : this.toPurgeChecked) {
            if (!osm.isModified()) continue;
            modified = true;
            break;
        }
        ExtendedDialog confirmDlg = new ExtendedDialog(Main.parent, I18n.tr("Confirm Purging", new Object[0]), new String[]{I18n.tr("Purge", new Object[0]), I18n.tr("Cancel", new Object[0])});
        confirmDlg.setContent(this.buildPanel(modified), false);
        confirmDlg.setButtonIcons(new String[]{"ok", "cancel"});
        int answer = confirmDlg.showDialog().getValue();
        if (answer != 1) {
            return;
        }
        Main.pref.put("purge.clear_undo_redo", this.cbClearUndoRedo.isSelected());
        Main.main.undoRedo.add(new PurgeCommand(Main.main.getEditLayer(), this.toPurgeChecked, this.makeIncomplete));
        if (this.cbClearUndoRedo.isSelected()) {
            Main.main.undoRedo.clean();
            PurgeAction.getCurrentDataSet().clearSelectionHistory();
        }
    }

    private JPanel buildPanel(boolean modified) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.", new Object[0]) + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:", new Object[0]) + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            Collections.sort(this.toPurgeAdditionally, new Comparator<OsmPrimitive>(){

                @Override
                public int compare(OsmPrimitive o1, OsmPrimitive o2) {
                    int type = o2.getType().compareTo(o1.getType());
                    if (type != 0) {
                        return type;
                    }
                    return Long.valueOf(o1.getUniqueId()).compareTo(o2.getUniqueId());
                }
            });
            JList<OsmPrimitive> list = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[this.toPurgeAdditionally.size()]));
            list.setCellRenderer(new OsmPrimitivRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<? extends OsmPrimitive> list, OsmPrimitive value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent(list, value, index, true, false);
                }
            });
            JScrollPane scroll = new JScrollPane(list);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setMinimumSize(new Dimension(250, 300));
            pnl.add((Component)scroll, GBC.std().fill(1).weight(1.0, 1.0));
            JButton addToSelection = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            addToSelection.setMargin(new Insets(0, 0, 0, 0));
            pnl.add((Component)addToSelection, GBC.eol().anchor(16).weight(0.0, 1.0).insets(2, 0, 0, 3));
        }
        if (modified) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>", new Object[0]), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer", new Object[0]));
        this.cbClearUndoRedo.setSelected(Main.pref.getBoolean("purge.clear_undo_redo", false));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)this.cbClearUndoRedo, GBC.eol());
        return pnl;
    }

    @Override
    protected void updateEnabledState() {
        if (PurgeAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!PurgeAction.getCurrentDataSet().selectionEmpty());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private boolean hasOnlyIncompleteMembers(Relation r, Collection<OsmPrimitive> toPurge, Collection<? extends OsmPrimitive> moreToPurge) {
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete() || toPurge.contains(m.getMember()) || moreToPurge.contains(m.getMember())) continue;
            return false;
        }
        return true;
    }
}

