/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;

public class PreferenceToggleAction
extends JosmAction
implements Preferences.PreferenceChangedListener {
    private final JCheckBoxMenuItem checkbox;
    private final String prefKey;
    private final boolean prefDefault;

    public PreferenceToggleAction(String name, String tooltip, String prefKey, boolean prefDefault) {
        super(name, null, tooltip, null, false);
        this.putValue("toolbar", "toggle-" + prefKey);
        this.prefKey = prefKey;
        this.prefDefault = prefDefault;
        this.checkbox = new JCheckBoxMenuItem(this);
        this.checkbox.setSelected(Main.pref.getBoolean(prefKey, prefDefault));
        Main.pref.addPreferenceChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Main.pref.put(this.prefKey, this.checkbox.isSelected());
    }

    public JCheckBoxMenuItem getCheckbox() {
        return this.checkbox;
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (this.prefKey.equals(e.getKey())) {
            this.checkbox.setSelected(Main.pref.getBoolean(this.prefKey, this.prefDefault));
        }
    }
}

