/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.TextTagParser;
import org.openstreetmap.josm.tools.Utils;

public final class PasteTagsAction
extends JosmAction {
    private static final String help = HelpUtil.ht("/Action/PasteTags");

    public PasteTagsAction() {
        super(I18n.tr("Paste Tags", new Object[0]), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items.", new Object[0]), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009), true);
        this.putValue("help", help);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = PasteTagsAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        String buf = Utils.getClipboardContent();
        if (buf == null || buf.isEmpty() || buf.matches("((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+")) {
            PasteTagsAction.pasteTagsFromJOSMBuffer(selection);
        } else {
            PasteTagsAction.pasteTagsFromText(selection, buf);
        }
    }

    public static boolean pasteTagsFromText(Collection<OsmPrimitive> selection, String text) {
        Map<String, String> tags = TextTagParser.readTagsFromText(text);
        if (tags == null || tags.isEmpty()) {
            TextTagParser.showBadBufferMessage(help);
            return false;
        }
        if (!TextTagParser.validateTags(tags)) {
            return false;
        }
        ArrayList<Command> commands = new ArrayList<Command>(tags.size());
        Iterator<Map.Entry<String, String>> i$ = tags.entrySet().iterator();
        while (i$.hasNext()) {
            String v;
            Map.Entry<String, String> entry;
            commands.add(new ChangePropertyCommand(selection, entry.getKey(), "".equals(v = (entry = i$.next()).getValue()) ? null : v));
        }
        PasteTagsAction.commitCommands(selection, commands);
        return !commands.isEmpty();
    }

    public static boolean pasteTagsFromJOSMBuffer(Collection<OsmPrimitive> selection) {
        List<PrimitiveData> directlyAdded = Main.pasteBuffer.getDirectlyAdded();
        if (directlyAdded == null || directlyAdded.isEmpty()) {
            return false;
        }
        TagPaster tagPaster = new TagPaster(directlyAdded, selection);
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Tag tag : tagPaster.execute()) {
            commands.add(new ChangePropertyCommand(selection, tag.getKey(), "".equals(tag.getValue()) ? null : tag.getValue()));
        }
        PasteTagsAction.commitCommands(selection, commands);
        return true;
    }

    private static void commitCommands(Collection<OsmPrimitive> selection, List<Command> commands) {
        if (!commands.isEmpty()) {
            String title1 = I18n.trn("Pasting {0} tag", "Pasting {0} tags", commands.size(), commands.size());
            String title2 = I18n.trn("to {0} object", "to {0} objects", selection.size(), selection.size());
            Main.main.undoRedo.add(new SequenceCommand(title1 + " " + title2, commands));
        }
    }

    @Override
    protected void updateEnabledState() {
        if (PasteTagsAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!PasteTagsAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    public static class TagPaster {
        private final Collection<PrimitiveData> source;
        private final Collection<OsmPrimitive> target;
        private final List<Tag> commands = new ArrayList<Tag>();

        public TagPaster(Collection<PrimitiveData> source, Collection<OsmPrimitive> target) {
            this.source = source;
            this.target = target;
        }

        protected boolean isHeteogeneousSource() {
            int count = 0;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.NODE).isEmpty() ? count + 1 : count;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.WAY).isEmpty() ? count + 1 : count;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.RELATION).isEmpty() ? count + 1 : count;
            return count > 1;
        }

        protected <T extends PrimitiveData> Collection<? extends PrimitiveData> getSourcePrimitivesByType(OsmPrimitiveType type) {
            return PrimitiveData.getFilteredList(this.source, type);
        }

        protected <T extends OsmPrimitive> TagCollection getSourceTagsByType(OsmPrimitiveType type) {
            return TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(type));
        }

        protected <T extends OsmPrimitive> boolean hasSourceTagsByType(OsmPrimitiveType type) {
            return !this.getSourceTagsByType(type).isEmpty();
        }

        protected void buildChangeCommand(Collection<? extends OsmPrimitive> selection, TagCollection tc) {
            for (String key : tc.getKeys()) {
                this.commands.add(new Tag(key, tc.getValues(key).iterator().next()));
            }
        }

        protected Map<OsmPrimitiveType, Integer> getSourceStatistics() {
            HashMap<OsmPrimitiveType, Integer> ret = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                if (this.getSourceTagsByType(type).isEmpty()) continue;
                ret.put(type, this.getSourcePrimitivesByType(type).size());
            }
            return ret;
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            HashMap<OsmPrimitiveType, Integer> ret = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                int count = OsmPrimitive.getFilteredList(this.target, type.getOsmClass()).size();
                if (count <= 0) continue;
                ret.put(type, count);
            }
            return ret;
        }

        protected void pasteFromHomogeneousSource() {
            TagCollection tc = null;
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                TagCollection tc1 = this.getSourceTagsByType(type);
                if (tc1.isEmpty()) continue;
                tc = tc1;
            }
            if (tc == null) {
                return;
            }
            if (!tc.isApplicableToPrimitive()) {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog(Main.parent);
                dialog.populate(tc, this.getSourceStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                this.buildChangeCommand(this.target, dialog.getResolution());
            } else {
                this.buildChangeCommand(this.target, tc);
            }
        }

        protected <T extends OsmPrimitive> boolean hasTargetPrimitives(Class<T> type) {
            return !OsmPrimitive.getFilteredList(this.target, type).isEmpty();
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict(Collection<OsmPrimitive> targets) {
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                TagCollection tc;
                if (!this.hasTargetPrimitives(type.getOsmClass()) || (tc = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(type))).isEmpty() || tc.isApplicableToPrimitive()) continue;
                return false;
            }
            return true;
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict(this.target)) {
                for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                    if (!this.hasSourceTagsByType(type) || !this.hasTargetPrimitives(type.getOsmClass())) continue;
                    this.buildChangeCommand(this.target, this.getSourceTagsByType(type));
                }
            } else {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog(Main.parent);
                dialog.populate(this.getSourceTagsByType(OsmPrimitiveType.NODE), this.getSourceTagsByType(OsmPrimitiveType.WAY), this.getSourceTagsByType(OsmPrimitiveType.RELATION), this.getSourceStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                    if (!this.hasSourceTagsByType(type) || !this.hasTargetPrimitives(type.getOsmClass())) continue;
                    this.buildChangeCommand(OsmPrimitive.getFilteredList(this.target, type.getOsmClass()), dialog.getResolution(type));
                }
            }
        }

        public List<Tag> execute() {
            this.commands.clear();
            if (this.isHeteogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.commands;
        }
    }
}

