/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteAction
extends JosmAction
implements PrimitiveDeepCopy.PasteBufferChangedListener {
    public PasteAction() {
        super(I18n.tr("Paste", new Object[0]), "paste", I18n.tr("Paste contents of paste buffer.", new Object[0]), Shortcut.registerShortcut("system:paste", I18n.tr("Edit: {0}", I18n.tr("Paste", new Object[0])), 86, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Paste"));
        Main.registerActionShortcut(this, Shortcut.registerShortcut("system:paste:cua", I18n.tr("Edit: {0}", I18n.tr("Paste", new Object[0])), 155, 5005));
        Main.pasteBuffer.addPasteBufferChangedListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.pasteData(Main.pasteBuffer, Main.pasteSource, e);
    }

    public void pasteData(PrimitiveDeepCopy pasteBuffer, Layer source, ActionEvent e) {
        double maxEast = -1.0E100;
        double minEast = 1.0E100;
        double maxNorth = -1.0E100;
        double minNorth = 1.0E100;
        boolean incomplete = false;
        for (PrimitiveData data : pasteBuffer.getAll()) {
            NodeData n;
            if (data instanceof NodeData && (n = (NodeData)data).getEastNorth() != null) {
                double east = n.getEastNorth().east();
                double north = n.getEastNorth().north();
                if (east > maxEast) {
                    maxEast = east;
                }
                if (east < minEast) {
                    minEast = east;
                }
                if (north > maxNorth) {
                    maxNorth = north;
                }
                if (north < minNorth) {
                    minNorth = north;
                }
            }
            if (!data.isIncomplete()) continue;
            incomplete = true;
        }
        if (incomplete && !this.confirmDeleteIncomplete()) {
            return;
        }
        EastNorth mPosition = Main.map.mapView.getCenter();
        if (e != null && !this.getValue("Name").equals(e.getActionCommand())) {
            Point mp = MouseInfo.getPointerInfo().getLocation();
            Point tl = Main.map.mapView.getLocationOnScreen();
            Point pos = new Point(mp.x - tl.x, mp.y - tl.y);
            if (Main.map.mapView.contains(pos)) {
                mPosition = Main.map.mapView.getEastNorth(pos.x, pos.y);
            }
        }
        double offsetEast = mPosition.east() - (maxEast + minEast) / 2.0;
        double offsetNorth = mPosition.north() - (maxNorth + minNorth) / 2.0;
        ArrayList<PrimitiveData> bufferCopy = new ArrayList<PrimitiveData>();
        ArrayList<PrimitiveData> toSelect = new ArrayList<PrimitiveData>();
        HashMap<Long, Long> newNodeIds = new HashMap<Long, Long>();
        HashMap<Long, Long> newWayIds = new HashMap<Long, Long>();
        HashMap<Long, Long> newRelationIds = new HashMap<Long, Long>();
        for (PrimitiveData data : pasteBuffer.getAll()) {
            if (data.isIncomplete()) continue;
            PrimitiveData copy = data.makeCopy();
            copy.clearOsmMetadata();
            if (data instanceof NodeData) {
                newNodeIds.put(data.getUniqueId(), copy.getUniqueId());
            } else if (data instanceof WayData) {
                newWayIds.put(data.getUniqueId(), copy.getUniqueId());
            } else if (data instanceof RelationData) {
                newRelationIds.put(data.getUniqueId(), copy.getUniqueId());
            }
            bufferCopy.add(copy);
            if (!pasteBuffer.getDirectlyAdded().contains(data)) continue;
            toSelect.add(copy);
        }
        for (PrimitiveData data : bufferCopy) {
            if (data instanceof NodeData) {
                NodeData nodeData = (NodeData)data;
                if (Main.main.getEditLayer() != source) continue;
                nodeData.setEastNorth(nodeData.getEastNorth().add(offsetEast, offsetNorth));
                continue;
            }
            if (data instanceof WayData) {
                ArrayList<Long> newNodes = new ArrayList<Long>();
                for (Long oldNodeId : ((WayData)data).getNodes()) {
                    Long newNodeId = (Long)newNodeIds.get(oldNodeId);
                    if (newNodeId == null) continue;
                    newNodes.add(newNodeId);
                }
                ((WayData)data).setNodes(newNodes);
                continue;
            }
            if (!(data instanceof RelationData)) continue;
            ArrayList<RelationMemberData> newMembers = new ArrayList<RelationMemberData>();
            for (RelationMemberData member : ((RelationData)data).getMembers()) {
                OsmPrimitiveType memberType = member.getMemberType();
                Long newId = null;
                switch (memberType) {
                    case NODE: {
                        newId = (Long)newNodeIds.get(member.getMemberId());
                        break;
                    }
                    case WAY: {
                        newId = (Long)newWayIds.get(member.getMemberId());
                        break;
                    }
                    case RELATION: {
                        newId = (Long)newRelationIds.get(member.getMemberId());
                    }
                }
                if (newId == null) continue;
                newMembers.add(new RelationMemberData(member.getRole(), memberType, newId));
            }
            ((RelationData)data).setMembers(newMembers);
        }
        Main.main.undoRedo.add(new AddPrimitivesCommand(bufferCopy, toSelect));
        Main.map.mapView.repaint();
    }

    protected boolean confirmDeleteIncomplete() {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Delete incomplete members?", new Object[0]), new String[]{I18n.tr("Paste without incomplete members", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setButtonIcons(new String[]{"dialogs/relation/deletemembers", "cancel"});
        ed.setContent(I18n.tr("The copied data contains incomplete objects.  When pasting the incomplete objects are removed.  Do you want to paste the data without the incomplete objects?", new Object[0]));
        ed.showDialog();
        return ed.getValue() == 1;
    }

    @Override
    protected void updateEnabledState() {
        if (PasteAction.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!Main.pasteBuffer.isEmpty());
    }

    @Override
    public void pasteBufferChanged(PrimitiveDeepCopy pasteBuffer) {
        this.updateEnabledState();
    }
}

