/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class OrthogonalizeAction
extends JosmAction {
    private static final String USAGE = I18n.tr("<h3>When one or more ways are selected, the shape is adjusted such, that all angles are 90 or 180 degrees.</h3>You can add two nodes to the selection. Then, the direction is fixed by these two reference nodes. (Afterwards, you can undo the movement for certain nodes:<br>Select them and press the shortcut for Orthogonalize / Undo. The default is Shift-Q.)", new Object[0]);
    private static final double TOLERANCE1 = Math.toRadians(45.0);
    private static final double TOLERANCE2 = Math.toRadians(45.0);
    private static final Map<Node, EastNorth> rememberMovements = new HashMap<Node, EastNorth>();

    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape", new Object[0]), "ortho", I18n.tr("Move nodes so all angles are 90 or 180 degrees", new Object[0]), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape", new Object[0])), 81, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/OrthogonalizeShape"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String msg;
        if (!this.isEnabled()) {
            return;
        }
        if ("EPSG:4326".equals(Main.getProjection().toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, msg = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 3, 0)) {
            return;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<WayData> wayDataList = new ArrayList<WayData>();
        Collection<OsmPrimitive> sel = OrthogonalizeAction.getCurrentDataSet().getSelected();
        try {
            for (OsmPrimitive p : sel) {
                if (p instanceof Node) {
                    nodeList.add((Node)p);
                    continue;
                }
                if (!(p instanceof Way)) throw new InvalidUserInputException(I18n.tr("Selection must consist only of ways and nodes.", new Object[0]));
                wayDataList.add(new WayData((Way)p));
            }
            if (wayDataList.isEmpty()) {
                throw new InvalidUserInputException("usage");
            }
            if (nodeList.size() != 2 && !nodeList.isEmpty()) throw new InvalidUserInputException("usage");
            rememberMovements.clear();
            LinkedList<Command> commands = new LinkedList<Command>();
            if (nodeList.size() == 2) {
                commands.addAll(OrthogonalizeAction.orthogonalize(wayDataList, nodeList));
            } else {
                if (!nodeList.isEmpty()) throw new IllegalStateException();
                List<List<WayData>> groups = OrthogonalizeAction.buildGroups(wayDataList);
                for (List<WayData> g : groups) {
                    commands.addAll(OrthogonalizeAction.orthogonalize(g, nodeList));
                }
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), commands));
            Main.map.repaint();
            return;
        }
        catch (InvalidUserInputException ex) {
            String msg2 = "usage".equals(ex.getMessage()) ? "<h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE : ex.getMessage() + "<br><hr><h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE;
            new Notification(msg2).setIcon(1).setDuration(Notification.TIME_VERY_LONG).show();
        }
    }

    private static List<List<WayData>> buildGroups(List<WayData> wayDataList) {
        ArrayList<List<WayData>> groups = new ArrayList<List<WayData>>();
        HashSet<WayData> remaining = new HashSet<WayData>(wayDataList);
        while (!remaining.isEmpty()) {
            ArrayList<WayData> group = new ArrayList<WayData>();
            groups.add(group);
            Iterator it = remaining.iterator();
            WayData next = (WayData)it.next();
            it.remove();
            OrthogonalizeAction.extendGroupRec(group, next, new ArrayList<WayData>(remaining));
            remaining.removeAll(group);
        }
        return groups;
    }

    private static void extendGroupRec(List<WayData> group, WayData newGroupMember, List<WayData> remaining) {
        group.add(newGroupMember);
        for (int i = 0; i < remaining.size(); ++i) {
            WayData candidate = remaining.get(i);
            if (candidate == null || Collections.disjoint(candidate.way.getNodes(), newGroupMember.way.getNodes())) continue;
            remaining.set(i, null);
            OrthogonalizeAction.extendGroupRec(group, candidate, remaining);
        }
    }

    private static Collection<Command> orthogonalize(List<WayData> wayDataList, List<Node> headingNodes) throws InvalidUserInputException {
        Direction[][] ORIENTATIONS;
        double headingAll;
        try {
            if (headingNodes.isEmpty()) {
                wayDataList.get(0).calcDirections(Direction.RIGHT);
                double refHeading = wayDataList.get((int)0).heading;
                for (WayData w : wayDataList) {
                    w.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(w.heading - refHeading, TOLERANCE2);
                    w.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                    if (OrthogonalizeAction.angleToDirectionChange(refHeading - w.heading, TOLERANCE2) == 0) continue;
                    throw new RuntimeException();
                }
                EastNorth totSum = new EastNorth(0.0, 0.0);
                for (WayData w : wayDataList) {
                    totSum = EN.sum(totSum, w.segSum);
                }
                headingAll = EN.polar(new EastNorth(0.0, 0.0), totSum);
            } else {
                headingAll = EN.polar(headingNodes.get(0).getEastNorth(), headingNodes.get(1).getEastNorth());
                for (WayData w : wayDataList) {
                    w.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(w.heading - headingAll, TOLERANCE2);
                    w.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                }
            }
        }
        catch (RejectedAngleException ex) {
            throw new InvalidUserInputException(I18n.tr("<html>Please make sure all selected ways head in a similar direction<br>or orthogonalize them one by one.</html>", new Object[0]), ex);
        }
        HashSet<Node> allNodes = new HashSet<Node>();
        for (WayData w : wayDataList) {
            for (Node n : w.way.getNodes()) {
                allNodes.add(n);
            }
        }
        HashMap<Node, Double> nX = new HashMap<Node, Double>();
        HashMap<Node, Double> nY = new HashMap<Node, Double>();
        EastNorth pivot = new EastNorth(0.0, 0.0);
        for (Node n : allNodes) {
            pivot = EN.sum(pivot, n.getEastNorth());
        }
        pivot = new EastNorth(pivot.east() / (double)allNodes.size(), pivot.north() / (double)allNodes.size());
        for (Node n : allNodes) {
            EastNorth tmp = EN.rotateCC(pivot, n.getEastNorth(), -headingAll);
            nX.put(n, tmp.east());
            nY.put(n, tmp.north());
        }
        Direction[] HORIZONTAL = new Direction[]{Direction.RIGHT, Direction.LEFT};
        Direction[] VERTICAL = new Direction[]{Direction.UP, Direction.DOWN};
        for (Direction[] orientation : ORIENTATIONS = new Direction[][]{HORIZONTAL, VERTICAL}) {
            HashSet s = new HashSet(allNodes);
            int s_size = s.size();
            for (int dummy = 0; dummy < s_size && !s.isEmpty(); ++dummy) {
                Node dummy_n = (Node)s.iterator().next();
                HashSet<Node> cs = new HashSet<Node>();
                cs.add(dummy_n);
                boolean somethingHappened = true;
                while (somethingHappened) {
                    somethingHappened = false;
                    for (WayData w : wayDataList) {
                        for (int i = 0; i < w.nSeg; ++i) {
                            Node n1 = w.way.getNodes().get(i);
                            Node n2 = w.way.getNodes().get(i + 1);
                            if (!Arrays.asList(orientation).contains((Object)w.segDirections[i])) continue;
                            if (cs.contains(n1) && !cs.contains(n2)) {
                                cs.add(n2);
                                somethingHappened = true;
                            }
                            if (!cs.contains(n2) || cs.contains(n1)) continue;
                            cs.add(n1);
                            somethingHappened = true;
                        }
                    }
                }
                for (Node n : cs) {
                    s.remove(n);
                }
                HashMap<Node, Double> nC = orientation == HORIZONTAL ? nY : nX;
                double average = 0.0;
                for (Node n : cs) {
                    average += ((Double)nC.get(n)).doubleValue();
                }
                average /= (double)cs.size();
                for (Node fn : headingNodes) {
                    if (!cs.contains(fn)) continue;
                    average = (Double)nC.get(fn);
                }
                if (orientation == VERTICAL && headingNodes.size() == 2 && cs.containsAll(headingNodes)) continue;
                for (Node n : cs) {
                    nC.put(n, average);
                }
            }
            if (s.isEmpty()) continue;
            throw new RuntimeException();
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        for (Node n : allNodes) {
            EastNorth tmp = new EastNorth((Double)nX.get(n), (Double)nY.get(n));
            tmp = EN.rotateCC(pivot, tmp, headingAll);
            double dx = tmp.east() - n.getEastNorth().east();
            double dy = tmp.north() - n.getEastNorth().north();
            if (headingNodes.contains(n)) {
                double EPSILON = 1.0E-6;
                if (Math.abs(dx) > Math.abs(1.0E-6 * tmp.east()) || Math.abs(dy) > Math.abs(1.0E-6 * tmp.east())) {
                    throw new AssertionError();
                }
                continue;
            }
            rememberMovements.put(n, new EastNorth(dx, dy));
            commands.add(new MoveCommand((OsmPrimitive)n, dx, dy));
        }
        return commands;
    }

    private static double standard_angle_0_to_2PI(double a) {
        while (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static double standard_angle_mPI_to_PI(double a) {
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static int angleToDirectionChange(double a, double deltaMax) throws RejectedAngleException {
        int dirChange;
        a = OrthogonalizeAction.standard_angle_mPI_to_PI(a);
        double d0 = Math.abs(a);
        double d90 = Math.abs(a - 1.5707963267948966);
        double d_m90 = Math.abs(a + 1.5707963267948966);
        if (d0 < deltaMax) {
            dirChange = 0;
        } else if (d90 < deltaMax) {
            dirChange = 1;
        } else if (d_m90 < deltaMax) {
            dirChange = -1;
        } else {
            double d180 = Math.abs((a = OrthogonalizeAction.standard_angle_0_to_2PI(a)) - Math.PI);
            if (d180 < deltaMax) {
                dirChange = 2;
            } else {
                throw new RejectedAngleException();
            }
        }
        return dirChange;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(OrthogonalizeAction.getCurrentDataSet() != null);
    }

    private static class RejectedAngleException
    extends Exception {
        RejectedAngleException() {
        }
    }

    private static class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String message) {
            super(message);
        }

        InvalidUserInputException(String message, Throwable cause) {
            super(message, cause);
        }

        InvalidUserInputException() {
        }
    }

    private static final class EN {
        public static EastNorth rotateCC(EastNorth pivot, EastNorth en, double angle) {
            double cosPhi = Math.cos(angle);
            double sinPhi = Math.sin(angle);
            double x = en.east() - pivot.east();
            double y = en.north() - pivot.north();
            double nx = cosPhi * x - sinPhi * y + pivot.east();
            double ny = sinPhi * x + cosPhi * y + pivot.north();
            return new EastNorth(nx, ny);
        }

        public static EastNorth sum(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() + en2.east(), en1.north() + en2.north());
        }

        public static EastNorth diff(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() - en2.east(), en1.north() - en2.north());
        }

        public static double polar(EastNorth en1, EastNorth en2) {
            return Math.atan2(en2.north() - en1.north(), en2.east() - en1.east());
        }
    }

    private static enum Direction {
        RIGHT,
        UP,
        LEFT,
        DOWN;


        public Direction changeBy(int directionChange) {
            int tmp = (this.ordinal() + directionChange) % 4;
            if (tmp < 0) {
                tmp += 4;
            }
            return Direction.values()[tmp];
        }
    }

    private static class WayData {
        public final Way way;
        public final int nSeg;
        public final int nNode;
        public Direction[] segDirections;
        public EastNorth segSum;
        public double heading;

        public WayData(Way pWay) {
            this.way = pWay;
            this.nNode = this.way.getNodes().size();
            this.nSeg = this.nNode - 1;
        }

        public void calcDirections(Direction pInitialDirection) throws InvalidUserInputException {
            Direction direction;
            EastNorth[] en = new EastNorth[this.nNode];
            for (int i = 0; i < this.nNode; ++i) {
                en[i] = new EastNorth(this.way.getNodes().get(i).getEastNorth().east(), this.way.getNodes().get(i).getEastNorth().north());
            }
            this.segDirections = new Direction[this.nSeg];
            this.segDirections[0] = direction = pInitialDirection;
            for (int i = 0; i < this.nSeg - 1; ++i) {
                double h1 = EN.polar(en[i], en[i + 1]);
                double h2 = EN.polar(en[i + 1], en[i + 2]);
                try {
                    direction = direction.changeBy(OrthogonalizeAction.angleToDirectionChange(h2 - h1, TOLERANCE1));
                }
                catch (RejectedAngleException ex) {
                    throw new InvalidUserInputException(I18n.tr("Please select ways with angles of approximately 90 or 180 degrees.", new Object[0]), ex);
                }
                this.segDirections[i + 1] = direction;
            }
            EastNorth h = new EastNorth(0.0, 0.0);
            EastNorth v = new EastNorth(0.0, 0.0);
            for (int i = 0; i < this.nSeg; ++i) {
                EastNorth segment = EN.diff(en[i + 1], en[i]);
                if (this.segDirections[i] == Direction.RIGHT) {
                    h = EN.sum(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.UP) {
                    v = EN.sum(v, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.LEFT) {
                    h = EN.diff(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.DOWN) {
                    v = EN.diff(v, segment);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.segSum = EN.sum(h, new EastNorth(v.north(), -v.east()));
            this.heading = EN.polar(new EastNorth(0.0, 0.0), this.segSum);
        }
    }

    public static class Undo
    extends JosmAction {
        public Undo() {
            super(I18n.tr("Orthogonalize Shape / Undo", new Object[0]), "ortho", I18n.tr("Undo orthogonalization for certain nodes", new Object[0]), Shortcut.registerShortcut("tools:orthogonalizeUndo", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape / Undo", new Object[0])), 81, 5005), true, "action/orthogonalize/undo", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<Command> commands = new LinkedList<Command>();
            Collection<OsmPrimitive> sel = Undo.getCurrentDataSet().getSelected();
            try {
                for (OsmPrimitive p : sel) {
                    if (!(p instanceof Node)) {
                        throw new InvalidUserInputException();
                    }
                    Node n = (Node)p;
                    if (!rememberMovements.containsKey(n)) continue;
                    EastNorth tmp = (EastNorth)rememberMovements.get(n);
                    commands.add(new MoveCommand((OsmPrimitive)n, -tmp.east(), -tmp.north()));
                    rememberMovements.remove(n);
                }
                if (commands.isEmpty()) {
                    throw new InvalidUserInputException();
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize / Undo", new Object[0]), commands));
                Main.map.repaint();
            }
            catch (InvalidUserInputException ex) {
                new Notification(I18n.tr("Orthogonalize Shape / Undo<br>Please select nodes that were moved by the previous Orthogonalize Shape action!", new Object[0])).setIcon(1).show();
            }
        }
    }
}

