/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmUrlTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadSessionTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class OpenLocationAction
extends JosmAction {
    protected final List<Class<? extends DownloadTask>> downloadTasks;

    public OpenLocationAction() {
        super(I18n.tr("Open Location...", new Object[0]), "openlocation", I18n.tr("Open an URL.", new Object[0]), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...", new Object[0])), 76, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/OpenLocation"));
        this.downloadTasks = new ArrayList<Class<? extends DownloadTask>>();
        this.addDownloadTaskClass(DownloadOsmTask.class);
        this.addDownloadTaskClass(DownloadGpsTask.class);
        this.addDownloadTaskClass(DownloadNotesTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeTask.class);
        this.addDownloadTaskClass(DownloadOsmUrlTask.class);
        this.addDownloadTaskClass(DownloadOsmCompressedTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeCompressedTask.class);
        this.addDownloadTaskClass(DownloadSessionTask.class);
    }

    protected void restoreUploadAddressHistory(HistoryComboBox cbHistory) {
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".uploadAddressHistory", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindUploadAddressHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".uploadAddressHistory", cbHistory.getHistory());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBox layer = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));
        layer.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        layer.setSelected(Main.pref.getBoolean("download.newlayer"));
        JPanel all = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.anchor = 23;
        all.add((Component)new JLabel(I18n.tr("Enter URL to download:", new Object[0])), gc);
        HistoryComboBox uploadAddresses = new HistoryComboBox();
        uploadAddresses.setToolTipText(I18n.tr("Enter an URL from where data should be downloaded", new Object[0]));
        this.restoreUploadAddressHistory(uploadAddresses);
        gc.gridy = 1;
        all.add((Component)uploadAddresses, gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weighty = 1.0;
        all.add((Component)layer, gc);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location", new Object[0]), new String[]{I18n.tr("Download URL", new Object[0]), I18n.tr("Cancel", new Object[0])});
        dialog.setContent(all, false);
        dialog.setButtonIcons(new String[]{"download", "cancel"});
        dialog.setToolTipTexts(new String[]{I18n.tr("Start downloading data", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        dialog.configureContextsensitiveHelp("/Action/OpenLocation", true);
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        this.remindUploadAddressHistory(uploadAddresses);
        this.openUrl(layer.isSelected(), Utils.strip(uploadAddresses.getText()));
    }

    public Collection<DownloadTask> findDownloadTasks(String url, boolean isRemotecontrol) {
        ArrayList<DownloadTask> result = new ArrayList<DownloadTask>();
        for (Class<? extends DownloadTask> taskClass : this.downloadTasks) {
            if (taskClass == null) continue;
            try {
                DownloadTask task = taskClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!task.acceptsUrl(url, isRemotecontrol)) continue;
                result.add(task);
            }
            catch (Exception e) {
                Main.error(e);
            }
        }
        return result;
    }

    public String findSummaryDocumentation() {
        StringBuilder result = new StringBuilder("<table>");
        for (Class<? extends DownloadTask> taskClass : this.downloadTasks) {
            if (taskClass == null) continue;
            try {
                DownloadTask task = taskClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                result.append(task.acceptsDocumentationSummary());
            }
            catch (Exception e) {
                Main.error(e);
            }
        }
        result.append("</table>");
        return result.toString();
    }

    public void openUrl(boolean newLayer, String url) {
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download Data", new Object[0]));
        Collection<DownloadTask> tasks = this.findDownloadTasks(url, false);
        DownloadTask task = null;
        Future<?> future = null;
        if (!tasks.isEmpty()) {
            try {
                task = tasks.iterator().next();
                future = task.loadUrl(newLayer, url, monitor);
            }
            catch (IllegalArgumentException e) {
                Main.error(e);
            }
        }
        if (future != null) {
            Main.worker.submit(new PostDownloadHandler(task, future));
        } else {
            String details = this.findSummaryDocumentation();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, "<html><p>" + I18n.tr("Cannot open URL ''{0}''<br>The following download tasks accept the URL patterns shown:<br>{1}", url, details) + "</p></html>", I18n.tr("Download Location", new Object[0]), 0, HelpUtil.ht("/Action/OpenLocation"));
        }
    }

    public final boolean addDownloadTaskClass(Class<? extends DownloadTask> taskClass) {
        return this.downloadTasks.add(taskClass);
    }
}

