/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class OpenFileAction
extends DiskAccessAction {
    public static final ExtensionFileFilter URL_FILE_FILTER = new ExtensionFileFilter("url", "url", I18n.tr("URL Files", new Object[0]) + " (*.url)");

    public OpenFileAction() {
        super(I18n.tr("Open...", new Object[0]), "open", I18n.tr("Open a file.", new Object[0]), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...", new Object[0])), 79, 5006));
        this.putValue("help", HelpUtil.ht("/Action/Open"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractFileChooser fc = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        OpenFileTask task = new OpenFileTask(Arrays.asList(files), fc.getFileFilter());
        task.setRecordHistory(true);
        Main.worker.submit(task);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(true);
    }

    public static void openFiles(List<File> fileList) {
        OpenFileAction.openFiles(fileList, false);
    }

    public static void openFiles(List<File> fileList, boolean recordHistory) {
        OpenFileTask task = new OpenFileTask(fileList, null);
        task.setRecordHistory(recordHistory);
        Main.worker.submit(task);
    }

    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private final List<File> files;
        private final List<File> successfullyOpenedFiles = new ArrayList<File>();
        private final Set<String> fileHistory = new LinkedHashSet<String>();
        private final Set<String> failedAll = new HashSet<String>();
        private final FileFilter fileFilter;
        private boolean canceled;
        private boolean recordHistory = false;

        public OpenFileTask(List<File> files, FileFilter fileFilter, String title) {
            super(title, false);
            this.files = new ArrayList<File>(files);
            this.fileFilter = fileFilter;
        }

        public OpenFileTask(List<File> files, FileFilter fileFilter) {
            this(files, fileFilter, I18n.tr("Opening files", new Object[0]));
        }

        public void setRecordHistory(boolean recordHistory) {
            this.recordHistory = recordHistory;
        }

        public boolean isRecordHistory() {
            return this.recordHistory;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> files, FileImporter importer) {
            StringBuilder msg = new StringBuilder();
            msg.append("<html>");
            msg.append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", files.size(), files.size(), importer.filter.getDescription())).append("<br>");
            msg.append("<ul>");
            for (File f : files) {
                msg.append("<li>").append(f.getAbsolutePath()).append("</li>");
            }
            msg.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#ImporterCantImportFiles"));
        }

        protected void alertFilesWithUnknownImporter(Collection<File> files) {
            StringBuilder msg = new StringBuilder();
            msg.append("<html>");
            msg.append(I18n.trn("Cannot open {0} file because file does not exist or no suitable file importer is available.", "Cannot open {0} files because files do not exist or no suitable file importer is available.", files.size(), files.size())).append("<br>");
            msg.append("<ul>");
            for (File f : files) {
                msg.append("<li>");
                msg.append(f.getAbsolutePath());
                msg.append(" (<i>");
                msg.append(f.exists() ? I18n.tr("no importer", new Object[0]) : I18n.tr("does not exist", new Object[0]));
                msg.append("</i>)</li>");
            }
            msg.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#MissingImporterForFiles"));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter chosenImporter = null;
            if (this.fileFilter != null) {
                for (FileImporter importer : ExtensionFileFilter.importers) {
                    if (!this.fileFilter.equals(importer.filter)) continue;
                    chosenImporter = importer;
                }
            }
            if (chosenImporter instanceof AllFormatsImporter) {
                chosenImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (chosenImporter != null) {
                LinkedList<File> filesNotMatchingWithImporter = new LinkedList<File>();
                LinkedList<File> filesMatchingWithImporter = new LinkedList<File>();
                for (final File f : this.files) {
                    if (!chosenImporter.acceptFile(f)) {
                        if (f.isDirectory()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", f.getAbsolutePath()), I18n.tr("Open file", new Object[0]), 0);
                                }
                            });
                            return;
                        }
                        filesNotMatchingWithImporter.add(f);
                        continue;
                    }
                    filesMatchingWithImporter.add(f);
                }
                if (!filesNotMatchingWithImporter.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter(filesNotMatchingWithImporter, chosenImporter);
                }
                if (!filesMatchingWithImporter.isEmpty()) {
                    this.importData(chosenImporter, filesMatchingWithImporter);
                }
            } else {
                MultiMap<FileImporter, File> importerMap = new MultiMap<FileImporter, File>();
                LinkedList<File> filesWithUnknownImporter = new LinkedList<File>();
                LinkedList<File> urlFiles = new LinkedList<File>();
                block13: for (File f : this.files) {
                    for (FileImporter importer : ExtensionFileFilter.importers) {
                        if (!importer.acceptFile(f)) continue;
                        importerMap.put(importer, f);
                        continue block13;
                    }
                    if (URL_FILE_FILTER.accept(f)) {
                        urlFiles.add(f);
                        continue;
                    }
                    filesWithUnknownImporter.add(f);
                }
                if (!filesWithUnknownImporter.isEmpty()) {
                    this.alertFilesWithUnknownImporter(filesWithUnknownImporter);
                }
                ArrayList importers = new ArrayList(importerMap.keySet());
                Collections.sort(importers);
                Collections.reverse(importers);
                for (FileImporter importer : importers) {
                    this.importData(importer, new ArrayList<File>(importerMap.get(importer)));
                }
                for (File urlFile : urlFiles) {
                    try {
                        BufferedReader reader = Files.newBufferedReader(urlFile.toPath(), StandardCharsets.UTF_8);
                        Throwable throwable = null;
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Matcher m = Pattern.compile(".*(https?://.*)").matcher(line);
                                if (!m.matches()) continue;
                                String url = m.group(1);
                                Main.main.menu.openLocation.openUrl(false, url);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        Main.error(e);
                    }
                }
            }
            if (this.recordHistory) {
                Collection<String> oldFileHistory = Main.pref.getCollection("file-open.history");
                this.fileHistory.addAll(oldFileHistory);
                this.fileHistory.removeAll(this.failedAll);
                int maxsize = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
                Main.pref.putCollectionBounded("file-open.history", maxsize, this.fileHistory);
            }
        }

        public void importData(FileImporter importer, List<File> files) {
            if (importer.isBatchImporter()) {
                if (this.canceled) {
                    return;
                }
                String msg = I18n.trn("Opening {0} file...", "Opening {0} files...", files.size(), files.size());
                this.getProgressMonitor().setCustomText(msg);
                this.getProgressMonitor().indeterminateSubTask(msg);
                if (importer.importDataHandleExceptions(files, this.getProgressMonitor().createSubTaskMonitor(files.size(), false))) {
                    this.successfullyOpenedFiles.addAll(files);
                }
            } else {
                for (File f : files) {
                    if (this.canceled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", f.getAbsolutePath()));
                    if (!importer.importDataHandleExceptions(f, this.getProgressMonitor().createSubTaskMonitor(1, false))) continue;
                    this.successfullyOpenedFiles.add(f);
                }
            }
            if (this.recordHistory && !importer.isBatchImporter()) {
                for (File f : files) {
                    try {
                        if (this.successfullyOpenedFiles.contains(f)) {
                            this.fileHistory.add(f.getCanonicalPath());
                            continue;
                        }
                        this.failedAll.add(f.getCanonicalPath());
                    }
                    catch (IOException e) {
                        Main.warn(e);
                    }
                }
            }
        }

        public List<File> getSuccessfullyOpenedFiles() {
            return this.successfullyOpenedFiles;
        }
    }
}

