/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MoveAction
extends JosmAction {
    private Direction myDirection;

    private static String calltosupermustbefirststatementinconstructortext(Direction dir) {
        String directiontext = dir == Direction.UP ? I18n.tr("up", new Object[0]) : (dir == Direction.DOWN ? I18n.tr("down", new Object[0]) : (dir == Direction.LEFT ? I18n.tr("left", new Object[0]) : I18n.tr("right", new Object[0])));
        return directiontext;
    }

    private static Shortcut calltosupermustbefirststatementinconstructor(Direction dir) {
        Shortcut sc = dir == Direction.UP ? Shortcut.registerShortcut("core:moveup", I18n.tr("Move objects {0}", I18n.tr("up", new Object[0])), 38, 5005) : (dir == Direction.DOWN ? Shortcut.registerShortcut("core:movedown", I18n.tr("Move objects {0}", I18n.tr("down", new Object[0])), 40, 5005) : (dir == Direction.LEFT ? Shortcut.registerShortcut("core:moveleft", I18n.tr("Move objects {0}", I18n.tr("left", new Object[0])), 37, 5005) : Shortcut.registerShortcut("core:moveright", I18n.tr("Move objects {0}", I18n.tr("right", new Object[0])), 39, 5005)));
        return sc;
    }

    public MoveAction(Direction dir) {
        super(I18n.tr("Move {0}", MoveAction.calltosupermustbefirststatementinconstructortext(dir)), null, I18n.tr("Moves Objects {0}", MoveAction.calltosupermustbefirststatementinconstructortext(dir)), MoveAction.calltosupermustbefirststatementinconstructor(dir), false);
        this.myDirection = dir;
        this.putValue("help", HelpUtil.ht("/Action/Move"));
        if (dir == Direction.UP) {
            this.putValue("toolbar", "action/move/up");
        } else if (dir == Direction.DOWN) {
            this.putValue("toolbar", "action/move/down");
        } else if (dir == Direction.LEFT) {
            this.putValue("toolbar", "action/move/left");
        } else {
            this.putValue("toolbar", "action/move/right");
        }
        Main.toolbar.register(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        EastNorth en1 = Main.map.mapView.getEastNorth(100, 100);
        EastNorth en2 = Main.map.mapView.getEastNorth(101, 101);
        double distx = en2.east() - en1.east();
        double disty = en2.north() - en1.north();
        switch (this.myDirection) {
            case UP: {
                distx = 0.0;
                disty = -disty;
                break;
            }
            case DOWN: {
                distx = 0.0;
                break;
            }
            case LEFT: {
                disty = 0.0;
                distx = -distx;
                break;
            }
            default: {
                disty = 0.0;
            }
        }
        Collection<OsmPrimitive> selection = MoveAction.getCurrentDataSet().getSelected();
        Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(selection);
        Command c = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        MoveAction.getCurrentDataSet().beginUpdate();
        if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
            ((MoveCommand)c).moveAgain(distx, disty);
        } else {
            c = new MoveCommand(selection, distx, disty);
            Main.main.undoRedo.add(c);
        }
        MoveAction.getCurrentDataSet().endUpdate();
        for (Node n : affectedNodes) {
            if (!n.getCoor().isOutSideWorld()) continue;
            ((MoveCommand)c).moveAgain(-distx, -disty);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (MoveAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MoveAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    public static enum Direction {
        UP,
        LEFT,
        RIGHT,
        DOWN;

    }
}

