/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction {
    private final JosmTextField url = new JosmTextField();
    private final JosmTextField lat = new JosmTextField();
    private final JosmTextField lon = new JosmTextField();
    private final JosmTextField zm = new JosmTextField();

    public JumpToAction() {
        super(I18n.tr("Jump To Position", new Object[0]), (ImageProvider)null, I18n.tr("Opens a dialog that allows to jump to a specific location", new Object[0]), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump To Position", new Object[0])), 74, 5006), true, "action/jumpto", true);
        this.putValue("help", HelpUtil.ht("/Action/JumpToPosition"));
    }

    public void showJumpToDialog() {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        MapView mv = Main.map.mapView;
        LatLon curPos = mv.getProjection().eastNorth2latlon(mv.getCenter());
        this.lat.setText(Double.toString(curPos.lat()));
        this.lon.setText(Double.toString(curPos.lon()));
        double dist = mv.getDist100Pixel();
        double zoomFactor = 1.0 / dist;
        this.zm.setText(Long.toString(Math.round(dist * 100.0) / 100L));
        this.updateUrl(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.", new Object[0]) + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org", new Object[0]) + "<br>" + "</html>"), "North");
        OsmLonLatListener x = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(x);
        this.lon.getDocument().addDocumentListener(x);
        this.zm.getDocument().addDocumentListener(x);
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "North");
        p.add((Component)new JLabel(I18n.tr("Latitude", new Object[0])), GBC.eol());
        p.add((Component)this.lat, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Longitude", new Object[0])), GBC.eol());
        p.add((Component)this.lon, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Zoom (in metres)", new Object[0])), GBC.eol());
        p.add((Component)this.zm, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("URL", new Object[0])), GBC.eol());
        p.add((Component)this.url, GBC.eol().fill(2));
        Object[] buttons = new Object[]{I18n.tr("Jump there", new Object[0]), I18n.tr("Cancel", new Object[0])};
        LatLon ll = null;
        double zoomLvl = 100.0;
        while (ll == null) {
            int option = JOptionPane.showOptionDialog(Main.parent, panel, I18n.tr("Jump to Position", new Object[0]), 2, -1, null, buttons, buttons[0]);
            if (option != 0) {
                return;
            }
            try {
                zoomLvl = Double.parseDouble(this.zm.getText());
                ll = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check.", new Object[0]), I18n.tr("Unable to parse Lon/Lat", new Object[0]), 0);
            }
        }
        mv.zoomToFactor(mv.getProjection().latlon2eastNorth(ll), zoomFactor * zoomLvl);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        String urlText = this.url.getText();
        Bounds b = OsmUrlToBounds.parse(urlText);
        if (b != null) {
            this.lat.setText(Double.toString((b.getMinLat() + b.getMaxLat()) / 2.0));
            this.lon.setText(Double.toString((b.getMinLon() + b.getMaxLon()) / 2.0));
            int zoomLvl = 16;
            int hashIndex = urlText.indexOf("#map");
            if (hashIndex >= 0) {
                zoomLvl = Integer.parseInt(urlText.substring(hashIndex + 5, urlText.indexOf(47, hashIndex)));
            } else {
                String[] args;
                for (String arg : args = urlText.substring(urlText.indexOf(63) + 1).split("&")) {
                    int eq = arg.indexOf(61);
                    if (eq == -1 || !"zoom".equalsIgnoreCase(arg.substring(0, eq))) continue;
                    zoomLvl = Integer.parseInt(arg.substring(eq + 1));
                    break;
                }
            }
            this.zm.setText(Double.toString(Math.round(1.0E7 * Math.pow(2.0, -1 * zoomLvl))));
        }
    }

    private void updateUrl(boolean force) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || force)) {
            return;
        }
        try {
            double dlat = Double.parseDouble(this.lat.getText());
            double dlon = Double.parseDouble(this.lon.getText());
            double m = Double.parseDouble(this.zm.getText());
            int zoomLvl = 18;
            if (m > 0.0) {
                zoomLvl = (int)Math.round(-1.0 * Math.log(m / 1.0E7) / Math.log(2.0));
            }
            this.url.setText(OsmUrlToBounds.getURL(dlat, dlon, zoomLvl));
        }
        catch (NumberFormatException x) {
            Main.debug(x.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showJumpToDialog();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView());
    }

    @Override
    protected void installAdapters() {
        super.installAdapters();
        Main.addMapFrameListener(new MapFrameListener(){

            @Override
            public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
                JumpToAction.this.updateEnabledState();
            }
        });
    }

    class OsmLonLatListener
    implements DocumentListener {
        OsmLonLatListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }
    }

    class OsmURLListener
    implements DocumentListener {
        OsmURLListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }
    }
}

