/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected Shortcut sc;
    private LayerChangeAdapter layerChangeAdapter;
    private SelectionChangeAdapter selectionChangeAdapter;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut", new Object[0]), 65535, 5000);
        }
        return this.sc;
    }

    @Deprecated
    public JosmAction(String name, Icon icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        super(name, icon);
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(tooltip);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", toolbarId);
        }
        if (registerInToolbar && Main.toolbar != null) {
            Main.toolbar.register(this);
        }
        if (installAdapters) {
            this.installAdapters();
        }
    }

    public JosmAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        super(name);
        if (icon != null) {
            icon.getResource().getImageIcon(this);
        }
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(tooltip);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", toolbarId);
        }
        if (registerInToolbar && Main.toolbar != null) {
            Main.toolbar.register(this);
        }
        if (installAdapters) {
            this.installAdapters();
        }
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        this(name, iconName == null ? null : new ImageProvider(iconName), tooltip, shortcut, registerInToolbar, toolbarId == null ? iconName : toolbarId, installAdapters);
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, boolean installAdapters) {
        this(name, iconName, tooltip, shortcut, registerInToolbar, null, installAdapters);
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        this(name, iconName, tooltip, shortcut, registerInToolbar, null, true);
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean installAdapters) {
        this.setHelpId();
        if (installAdapters) {
            this.installAdapters();
        }
    }

    @Override
    public void destroy() {
        if (this.sc != null) {
            Main.unregisterActionShortcut(this);
        }
        MapView.removeLayerChangeListener(this.layerChangeAdapter);
        DataSet.removeSelectionListener(this.selectionChangeAdapter);
    }

    private void setHelpId() {
        String helpId = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (helpId.endsWith("Action")) {
            helpId = helpId.substring(0, helpId.length() - 6);
        }
        this.putValue("help", helpId);
    }

    public final void setTooltip(String tooltip) {
        if (tooltip != null) {
            this.putValue("ShortDescription", Main.platform.makeTooltip(tooltip, this.sc));
        }
    }

    protected static OsmDataLayer getEditLayer() {
        return Main.main != null ? Main.main.getEditLayer() : null;
    }

    protected static DataSet getCurrentDataSet() {
        return Main.main != null ? Main.main.getCurrentDataSet() : null;
    }

    protected void installAdapters() {
        this.layerChangeAdapter = new LayerChangeAdapter();
        this.selectionChangeAdapter = new SelectionChangeAdapter();
        MapView.addLayerChangeListener(this.layerChangeAdapter);
        DataSet.addSelectionListener(this.selectionChangeAdapter);
        this.initEnabledState();
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
    }

    private class SelectionChangeAdapter
    implements SelectionChangedListener {
        private SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            JosmAction.this.updateEnabledState(newSelection);
        }
    }

    private class LayerChangeAdapter
    implements MapView.LayerChangeListener {
        private LayerChangeAdapter() {
        }

        private void updateEnabledStateInEDT() {
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    JosmAction.this.updateEnabledState();
                }
            });
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledStateInEDT();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.updateEnabledStateInEDT();
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledStateInEDT();
        }
    }
}

