/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;

public class JoinNodeWayAction
extends JosmAction {
    protected final boolean joinWayToNode;

    protected JoinNodeWayAction(boolean joinWayToNode, String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar);
        this.joinWayToNode = joinWayToNode;
    }

    public static JoinNodeWayAction createJoinNodeToWayAction() {
        JoinNodeWayAction action = new JoinNodeWayAction(false, I18n.tr("Join Node to Way", new Object[0]), "joinnodeway", I18n.tr("Include a node into the nearest way segments", new Object[0]), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way", new Object[0])), 74, 5003), true);
        action.putValue("help", HelpUtil.ht("/Action/JoinNodeWay"));
        return action;
    }

    public static JoinNodeWayAction createMoveNodeOntoWayAction() {
        JoinNodeWayAction action = new JoinNodeWayAction(true, I18n.tr("Move Node onto Way", new Object[0]), "movenodeontoway", I18n.tr("Move the node onto the nearest way segments and include it", new Object[0]), Shortcut.registerShortcut("tools:movenodeontoway", I18n.tr("Tool: {0}", I18n.tr("Move Node onto Way", new Object[0])), 78, 5003), true);
        action.putValue("help", HelpUtil.ht("/Action/MoveNodeWay"));
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<Node> selectedNodes = JoinNodeWayAction.getCurrentDataSet().getSelectedNodes();
        LinkedList<Command> cmds = new LinkedList<Command>();
        HashMap<Way, MultiMap> data = new HashMap<Way, MultiMap>();
        boolean restrictToSelectedWays = !JoinNodeWayAction.getCurrentDataSet().getSelectedWays().isEmpty();
        for (Node node : selectedNodes) {
            List<WaySegment> wss = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node), OsmPrimitive.isSelectablePredicate);
            MultiMap<Way, Integer> insertPoints = new MultiMap<Way, Integer>();
            for (WaySegment waySegment : wss) {
                if (restrictToSelectedWays && !waySegment.way.isSelected() || waySegment.getFirstNode().equals(node) || waySegment.getSecondNode().equals(node)) continue;
                insertPoints.put(waySegment.way, waySegment.lowerIndex);
            }
            for (Map.Entry entry : insertPoints.entrySet()) {
                Way w = (Way)entry.getKey();
                Set insertPointsForWay = (Set)entry.getValue();
                Iterator i$ = JoinNodeWayAction.pruneSuccs(insertPointsForWay).iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    MultiMap innerMap = !data.containsKey(w) ? new MultiMap() : (MultiMap)data.get(w);
                    innerMap.put(i, node);
                    data.put(w, innerMap);
                }
            }
        }
        for (Map.Entry entry : data.entrySet()) {
            Way w = (Way)entry.getKey();
            MultiMap innerEntry = (MultiMap)entry.getValue();
            LinkedList segmentIndexes = new LinkedList();
            segmentIndexes.addAll(innerEntry.keySet());
            Collections.sort(segmentIndexes, Collections.reverseOrder());
            List<Node> list = w.getNodes();
            for (Integer segmentIndex : segmentIndexes) {
                Set nodesInSegment = innerEntry.get(segmentIndex);
                if (this.joinWayToNode) {
                    for (Node node : nodesInSegment) {
                        EastNorth newPosition = Geometry.closestPointToSegment(w.getNode(segmentIndex).getEastNorth(), w.getNode(segmentIndex + 1).getEastNorth(), node.getEastNorth());
                        cmds.add(new MoveCommand(node, Projections.inverseProject(newPosition)));
                    }
                }
                LinkedList nodesToAdd = new LinkedList();
                nodesToAdd.addAll(nodesInSegment);
                Collections.sort(nodesToAdd, new NodeDistanceToRefNodeComparator(w.getNode(segmentIndex), w.getNode(segmentIndex + 1), !this.joinWayToNode));
                list.addAll(segmentIndex + 1, nodesToAdd);
            }
            Way wnew = new Way(w);
            wnew.setNodes(list);
            cmds.add(new ChangeCommand(w, wnew));
        }
        if (cmds.isEmpty()) {
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(this.getValue("Name").toString(), cmds));
        Main.map.repaint();
    }

    private static SortedSet<Integer> pruneSuccs(Collection<Integer> is) {
        TreeSet<Integer> is2 = new TreeSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        return is2;
    }

    @Override
    protected void updateEnabledState() {
        if (JoinNodeWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(JoinNodeWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private static class NodeDistanceToRefNodeComparator
    implements Comparator<Node> {
        private final EastNorth refPoint;
        private EastNorth refPoint2;
        private final boolean projectToSegment;

        NodeDistanceToRefNodeComparator(Node referenceNode, Node referenceNode2, boolean projectFirst) {
            this.refPoint = referenceNode.getEastNorth();
            this.refPoint2 = referenceNode2.getEastNorth();
            this.projectToSegment = projectFirst;
        }

        @Override
        public int compare(Node first, Node second) {
            double distanceSecond;
            double distanceFirst;
            double difference;
            EastNorth firstPosition = first.getEastNorth();
            EastNorth secondPosition = second.getEastNorth();
            if (this.projectToSegment) {
                firstPosition = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, firstPosition);
                secondPosition = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, secondPosition);
            }
            if ((difference = (distanceFirst = firstPosition.distance(this.refPoint)) - (distanceSecond = secondPosition.distance(this.refPoint))) > 0.0) {
                return 1;
            }
            if (difference < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

