/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class JoinAreasAction
extends JosmAction {
    private final LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;
    private final List<Relation> addedRelations = new LinkedList<Relation>();

    public JoinAreasAction() {
        super(I18n.tr("Join overlapping Areas", new Object[0]), "joinareas", I18n.tr("Joins areas that overlap each other", new Object[0]), Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tool: {0}", I18n.tr("Join overlapping Areas", new Object[0])), 74, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.join(Main.main.getCurrentDataSet().getSelectedWays());
    }

    public void join(Collection<Way> ways) {
        this.addedRelations.clear();
        if (ways.isEmpty()) {
            new Notification(I18n.tr("Please select at least one closed way that should be joined.", new Object[0])).setIcon(1).show();
            return;
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way way : ways) {
            if (!way.isClosed()) {
                new Notification(I18n.tr("One of the selected ways is not closed and therefore cannot be joined.", new Object[0])).setIcon(1).show();
                return;
            }
            allNodes.addAll(way.getNodes());
        }
        boolean ok = Command.checkAndConfirmOutlyingOperation("joinarea", I18n.tr("Join area confirmation", new Object[0]), I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", ways.size(), new Object[0]) + "<br/>" + I18n.tr("This can lead to nodes being deleted accidentally.", new Object[0]) + "<br/>" + I18n.tr("Are you really sure to continue?", new Object[0]) + I18n.tr("Please abort if you are not sure", new Object[0]), I18n.tr("The selected area is incomplete. Continue?", new Object[0]), allNodes, null);
        if (!ok) {
            return;
        }
        List<Multipolygon> areas = this.collectMultipolygons(ways);
        if (areas == null) {
            return;
        }
        if (!this.testJoin(areas)) {
            new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            return;
        }
        if (!this.resolveTagConflicts(areas)) {
            return;
        }
        try {
            DataSet ds = ways.iterator().next().getDataSet();
            JoinAreasResult result = this.joinAreas(areas);
            if (result.hasChanges) {
                for (Relation r : this.addedRelations) {
                    this.cmds.addAll(CreateMultipolygonAction.removeTagsFromWaysIfNeeded(r));
                }
                this.commitCommands(I18n.tr("Move tags from ways to relations", new Object[0]));
                ArrayList<Way> allWays = new ArrayList<Way>();
                for (Multipolygon pol : result.polygons) {
                    allWays.add(pol.outerWay);
                    allWays.addAll(pol.innerWays);
                }
                if (ds != null) {
                    ds.setSelected(allWays);
                    Main.map.mapView.repaint();
                }
            } else {
                new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            }
        }
        catch (UserCancelException exception) {
            this.makeCommitsOneAction(I18n.tr("Reverting changes", new Object[0]));
            Main.main.undoRedo.undo();
            Main.main.undoRedo.redoCommands.clear();
        }
    }

    private boolean testJoin(List<Multipolygon> areas) {
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            allStartingWays.add(area.outerWay);
            allStartingWays.addAll(area.innerWays);
        }
        Set<Node> nodes = Geometry.addIntersections(allStartingWays, true, this.cmds);
        return !nodes.isEmpty();
    }

    private JoinAreasResult joinAreas(List<Multipolygon> areas) throws UserCancelException {
        Command deleteCmd;
        List<Way> splitWays;
        Set<Node> nodes;
        JoinAreasResult result = new JoinAreasResult();
        result.hasChanges = false;
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        ArrayList<Way> innerStartingWays = new ArrayList<Way>();
        ArrayList<Way> outerStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            outerStartingWays.add(area.outerWay);
            innerStartingWays.addAll(area.innerWays);
        }
        allStartingWays.addAll(innerStartingWays);
        allStartingWays.addAll(outerStartingWays);
        boolean removedDuplicates = false;
        if (removedDuplicates |= this.removeDuplicateNodes(allStartingWays)) {
            result.hasChanges = true;
            this.commitCommands(I18n.marktr("Removed duplicate nodes"));
        }
        if ((nodes = Geometry.addIntersections(allStartingWays, false, this.cmds)).isEmpty()) {
            return result;
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> relations = new ArrayList<RelationRole>();
        for (Way way : allStartingWays) {
            relations.addAll(this.removeFromAllRelations(way));
        }
        boolean warnAboutRelations = !relations.isEmpty() && allStartingWays.size() > 1;
        ArrayList<WayInPolygon> preparedWays = new ArrayList<WayInPolygon>();
        for (Way way : outerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes);
            preparedWays.addAll(this.markWayInsideSide(splitWays, false));
        }
        for (Way way : innerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes);
            preparedWays.addAll(this.markWayInsideSide(splitWays, true));
        }
        ArrayList<Way> discardedWays = new ArrayList<Way>();
        List<AssembledPolygon> bounadries = JoinAreasAction.findBoundaryPolygons(preparedWays, discardedWays);
        List<AssembledMultipolygon> preparedPolygons = this.findPolygons(bounadries);
        ArrayList<Multipolygon> polygons = new ArrayList<Multipolygon>();
        LinkedHashSet<Relation> relationsToDelete = new LinkedHashSet<Relation>();
        for (AssembledMultipolygon pol : preparedPolygons) {
            Multipolygon resultPol = this.joinPolygon(pol);
            RelationRole ownMultipolygonRelation = this.addOwnMultigonRelation(resultPol.innerWays, resultPol.outerWay);
            this.fixRelations(relations, resultPol.outerWay, ownMultipolygonRelation, relationsToDelete);
            this.stripTags(resultPol.innerWays);
            polygons.add(resultPol);
        }
        this.commitCommands(I18n.marktr("Assemble new polygons"));
        for (Relation rel : relationsToDelete) {
            this.cmds.add(new DeleteCommand(rel));
        }
        this.commitCommands(I18n.marktr("Delete relations"));
        if (!discardedWays.isEmpty() && (deleteCmd = DeleteCommand.delete(Main.main.getEditLayer(), discardedWays, true)) != null) {
            this.cmds.add(deleteCmd);
            this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        }
        this.makeCommitsOneAction(I18n.marktr("Joined overlapping areas"));
        if (warnAboutRelations) {
            new Notification(I18n.tr("Some of the ways were part of relations that have been modified.<br>Please verify no errors have been introduced.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
        }
        result.hasChanges = true;
        result.polygons = polygons;
        return result;
    }

    private boolean resolveTagConflicts(List<Multipolygon> polygons) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (Multipolygon pol : polygons) {
            ways.add(pol.outerWay);
            ways.addAll(pol.innerWays);
        }
        if (ways.size() < 2) {
            return true;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        try {
            this.cmds.addAll(CombinePrimitiveResolverDialog.launchIfNecessary(wayTags, ways, ways));
            this.commitCommands(I18n.marktr("Fix tag conflicts"));
            return true;
        }
        catch (UserCancelException ex) {
            return false;
        }
    }

    private boolean removeDuplicateNodes(List<Way> ways) {
        TreeMap<Node, Node> nodeMap = new TreeMap<Node, Node>(new NodePositionComparator());
        int totalNodesRemoved = 0;
        for (Way way : ways) {
            if (way.getNodes().size() < 2) continue;
            int nodesRemoved = 0;
            ArrayList<Node> newNodes = new ArrayList<Node>();
            Node prevNode = null;
            for (Node node : way.getNodes()) {
                if (!nodeMap.containsKey(node)) {
                    nodeMap.put(node, node);
                    if (prevNode != node) {
                        newNodes.add(node);
                    } else {
                        ++nodesRemoved;
                    }
                } else {
                    Node representator = (Node)nodeMap.get(node);
                    if (representator != node) {
                        ++nodesRemoved;
                    }
                    if (prevNode != representator) {
                        newNodes.add(representator);
                    }
                }
                prevNode = node;
            }
            if (nodesRemoved <= 0) continue;
            if (newNodes.size() == 1) {
                newNodes.add((Node)newNodes.get(0));
            }
            Way newWay = new Way(way);
            newWay.setNodes(newNodes);
            this.cmds.add(new ChangeCommand(way, newWay));
            totalNodesRemoved += nodesRemoved;
        }
        return totalNodesRemoved > 0;
    }

    private void commitCommands(String description) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand c = new SequenceCommand(I18n.tr(description, new Object[0]), this.cmds);
                Main.main.undoRedo.add(c);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    private List<WayInPolygon> markWayInsideSide(List<Way> parts, boolean isInner) {
        boolean wayClockwise;
        ArrayList<WayInPolygon> result = new ArrayList<WayInPolygon>();
        HashMap<Way, Way> nextWayMap = new HashMap<Way, Way>();
        HashMap<Way, Way> prevWayMap = new HashMap<Way, Way>();
        for (int pos = 0; pos < parts.size(); ++pos) {
            if (!parts.get(pos).lastNode().equals(parts.get((pos + 1) % parts.size()).firstNode())) {
                throw new RuntimeException("Way not circular");
            }
            nextWayMap.put(parts.get(pos), parts.get((pos + 1) % parts.size()));
            prevWayMap.put(parts.get(pos), parts.get((pos + parts.size() - 1) % parts.size()));
        }
        Way topWay = null;
        OsmPrimitive topNode = null;
        int topIndex = 0;
        double minY = Double.POSITIVE_INFINITY;
        for (Way way : parts) {
            for (int pos = 0; pos < way.getNodesCount(); ++pos) {
                Node node = way.getNode(pos);
                if (!(node.getEastNorth().getY() < minY)) continue;
                minY = node.getEastNorth().getY();
                topWay = way;
                topNode = node;
                topIndex = pos;
            }
        }
        if (topNode.equals(topWay.firstNode()) || topNode.equals(topWay.lastNode())) {
            OsmPrimitive headNode = null;
            Node prevNode = null;
            wayClockwise = false;
            headNode = topNode;
            prevNode = new Node(new EastNorth(((Node)headNode).getEastNorth().getX(), ((Node)headNode).getEastNorth().getY() - 100000.0));
            topWay = null;
            wayClockwise = false;
            Node bestWayNextNode = null;
            for (Way way : parts) {
                Node nextNode;
                if (way.firstNode().equals(headNode)) {
                    nextNode = way.getNode(1);
                    if (topWay == null || !Geometry.isToTheRightSideOfLine(prevNode, (Node)headNode, bestWayNextNode, nextNode)) {
                        topWay = way;
                        wayClockwise = true;
                        bestWayNextNode = nextNode;
                    }
                }
                if (!way.lastNode().equals(headNode)) continue;
                nextNode = way.getNode(way.getNodesCount() - 2);
                if (topWay != null && Geometry.isToTheRightSideOfLine(prevNode, (Node)headNode, bestWayNextNode, nextNode)) continue;
                topWay = way;
                wayClockwise = false;
                bestWayNextNode = nextNode;
            }
        } else {
            Node prev = topWay.getNode(topIndex - 1);
            Node next = topWay.getNode(topIndex + 1);
            wayClockwise = Geometry.angleIsClockwise(prev, (Node)topNode, next);
        }
        Way curWay = topWay;
        boolean curWayInsideToTheRight = wayClockwise ^ isInner;
        while (true) {
            WayInPolygon resultWay = new WayInPolygon(curWay, curWayInsideToTheRight);
            result.add(resultWay);
            Way nextWay = (Way)nextWayMap.get(curWay);
            Node prevNode = curWay.getNode(curWay.getNodesCount() - 2);
            Node headNode = curWay.lastNode();
            Node nextNode = nextWay.getNode(1);
            if (nextWay == topWay) break;
            int intersectionCount = 0;
            for (Way wayA : parts) {
                boolean wayBToTheRight;
                if (wayA == curWay || !wayA.lastNode().equals(headNode)) continue;
                Way wayB = (Way)nextWayMap.get(wayA);
                Node wayANode = wayA.getNode(wayA.getNodesCount() - 2);
                Node wayBNode = wayB.getNode(1);
                boolean wayAToTheRight = Geometry.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayANode);
                if (wayAToTheRight == (wayBToTheRight = Geometry.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayBNode))) continue;
                ++intersectionCount;
            }
            if (intersectionCount % 2 != 0) {
                curWayInsideToTheRight = !curWayInsideToTheRight;
            }
            curWay = nextWay;
        }
        return result;
    }

    private List<Way> splitWayOnNodes(Way way, Set<Node> nodes) {
        ArrayList<Way> result = new ArrayList<Way>();
        List<List<Node>> chunks = this.buildNodeChunks(way, nodes);
        if (chunks.size() > 1) {
            SplitWayAction.SplitWayResult split = SplitWayAction.splitWay(JoinAreasAction.getEditLayer(), way, chunks, Collections.emptyList());
            this.cmds.add(split.getCommand());
            this.commitCommands(I18n.marktr("Split ways into fragments"));
            result.add(split.getOriginalWay());
            result.addAll(split.getNewWays());
        } else {
            result.add(way);
        }
        return result;
    }

    private List<List<Node>> buildNodeChunks(Way way, Collection<Node> splitNodes) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        ArrayList<Node> curList = new ArrayList<Node>();
        for (Node node : way.getNodes()) {
            curList.add(node);
            if (curList.size() <= 1 || !splitNodes.contains(node)) continue;
            result.add(curList);
            curList = new ArrayList();
            curList.add(node);
        }
        if (curList.size() > 1) {
            result.add(curList);
        }
        return result;
    }

    private List<AssembledMultipolygon> findPolygons(Collection<AssembledPolygon> boundaries) {
        List<PolygonLevel> list = this.findOuterWaysImpl(0, boundaries);
        ArrayList<AssembledMultipolygon> result = new ArrayList<AssembledMultipolygon>();
        for (PolygonLevel pol : list) {
            if (pol.level % 2 != 0) continue;
            result.add(pol.pol);
        }
        return result;
    }

    private List<PolygonLevel> findOuterWaysImpl(int level, Collection<AssembledPolygon> boundaryWays) {
        ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
        for (AssembledPolygon outerWay : boundaryWays) {
            boolean outerGood = true;
            ArrayList<AssembledPolygon> innerCandidates = new ArrayList<AssembledPolygon>();
            for (AssembledPolygon innerWay : boundaryWays) {
                if (innerWay == outerWay) continue;
                if (JoinAreasAction.wayInsideWay(outerWay, innerWay)) {
                    outerGood = false;
                    break;
                }
                if (!JoinAreasAction.wayInsideWay(innerWay, outerWay)) continue;
                innerCandidates.add(innerWay);
            }
            if (!outerGood) continue;
            AssembledMultipolygon pol = new AssembledMultipolygon(outerWay);
            PolygonLevel polLev = new PolygonLevel(pol, level);
            if (!innerCandidates.isEmpty()) {
                List<PolygonLevel> innerList = this.findOuterWaysImpl(level + 1, innerCandidates);
                result.addAll(innerList);
                for (PolygonLevel pl : innerList) {
                    if (pl.level != level + 1) continue;
                    pol.innerWays.add(pl.pol.outerWay);
                }
            }
            result.add(polLev);
        }
        return result;
    }

    public static List<AssembledPolygon> findBoundaryPolygons(Collection<WayInPolygon> multigonWays, List<Way> discardedResult) {
        WayInPolygon startWay;
        ArrayList<WayInPolygon> discardedWays = new ArrayList<WayInPolygon>();
        ArrayList<WayInPolygon> cleanMultigonWays = new ArrayList<WayInPolygon>();
        for (WayInPolygon way : multigonWays) {
            if (way.way.getNodesCount() == 2 && way.way.firstNode() == way.way.lastNode()) {
                discardedWays.add(way);
                continue;
            }
            cleanMultigonWays.add(way);
        }
        WayTraverser traverser = new WayTraverser(cleanMultigonWays);
        ArrayList<AssembledPolygon> result = new ArrayList<AssembledPolygon>();
        block1: while ((startWay = traverser.startNewWay()) != null) {
            ArrayList<WayInPolygon> path = new ArrayList<WayInPolygon>();
            ArrayList<WayInPolygon> startWays = new ArrayList<WayInPolygon>();
            path.add(startWay);
            while (true) {
                WayInPolygon nextWay;
                WayInPolygon leftComing;
                if ((leftComing = traverser.leftComingWay()) != null && !startWays.contains(leftComing)) {
                    path.clear();
                    path.add(leftComing);
                    traverser.setStartWay(leftComing);
                    startWays.add(leftComing);
                }
                if ((nextWay = traverser.walk()) == null) {
                    throw new RuntimeException("Join areas internal error.");
                }
                if (path.get(0) == nextWay) {
                    AssembledPolygon ring = new AssembledPolygon(path);
                    if (ring.getNodes().size() <= 2) {
                        traverser.removeWays(path);
                        for (WayInPolygon way : path) {
                            discardedResult.add(way.way);
                        }
                        continue block1;
                    }
                    result.add(ring);
                    traverser.removeWays(path);
                    continue block1;
                }
                if (path.contains(nextWay)) {
                    int index = path.indexOf(nextWay);
                    while (path.size() > index) {
                        WayInPolygon currentWay = path.get(index);
                        discardedResult.add(currentWay.way);
                        traverser.removeWay(currentWay);
                        path.remove(index);
                    }
                    traverser.setStartWay(path.get(index - 1));
                    continue;
                }
                path.add(nextWay);
            }
        }
        return JoinAreasAction.fixTouchingPolygons(result);
    }

    public static List<AssembledPolygon> fixTouchingPolygons(List<AssembledPolygon> polygons) {
        ArrayList<AssembledPolygon> newPolygons = new ArrayList<AssembledPolygon>();
        for (AssembledPolygon ring : polygons) {
            WayInPolygon startWay;
            ring.reverse();
            WayTraverser traverser = new WayTraverser(ring.ways);
            while ((startWay = traverser.startNewWay()) != null) {
                WayInPolygon nextWay;
                ArrayList<WayInPolygon> simpleRingWays = new ArrayList<WayInPolygon>();
                simpleRingWays.add(startWay);
                while ((nextWay = traverser.walk()) != startWay) {
                    if (nextWay == null) {
                        throw new RuntimeException("Join areas internal error.");
                    }
                    simpleRingWays.add(nextWay);
                }
                traverser.removeWays(simpleRingWays);
                AssembledPolygon simpleRing = new AssembledPolygon(simpleRingWays);
                simpleRing.reverse();
                newPolygons.add(simpleRing);
            }
        }
        return newPolygons;
    }

    public static boolean wayInsideWay(AssembledPolygon inside, AssembledPolygon outside) {
        HashSet<Node> outsideNodes = new HashSet<Node>(outside.getNodes());
        List<Node> insideNodes = inside.getNodes();
        for (Node insideNode : insideNodes) {
            if (outsideNodes.contains(insideNode)) continue;
            return Geometry.nodeInsidePolygon(insideNode, outside.getNodes());
        }
        return false;
    }

    private Multipolygon joinPolygon(AssembledMultipolygon polygon) throws UserCancelException {
        Multipolygon result = new Multipolygon(this.joinWays(polygon.outerWay.ways));
        for (AssembledPolygon pol : polygon.innerWays) {
            result.innerWays.add(this.joinWays(pol.ways));
        }
        return result;
    }

    private Way joinWays(List<WayInPolygon> ways) throws UserCancelException {
        Way joinedWay;
        boolean allReverse = true;
        for (WayInPolygon way : ways) {
            allReverse &= !way.insideToTheRight;
        }
        if (allReverse) {
            for (WayInPolygon way : ways) {
                way.insideToTheRight = !way.insideToTheRight;
            }
        }
        if ((joinedWay = this.joinOrientedWays(ways)) == null || !joinedWay.isClosed()) {
            throw new RuntimeException("Join areas internal error.");
        }
        return joinedWay;
    }

    private Way joinOrientedWays(List<WayInPolygon> ways) throws UserCancelException {
        if (ways.size() < 2) {
            return ways.get((int)0).way;
        }
        ArrayList<Way> actionWays = new ArrayList<Way>(ways.size());
        for (WayInPolygon way : ways) {
            actionWays.add(way.way);
            if (way.insideToTheRight) continue;
            ReverseWayAction.ReverseWayResult res = ReverseWayAction.reverseWay(way.way);
            Main.main.undoRedo.add(res.getReverseCommand());
            ++this.cmdsCount;
        }
        Pair<Way, Command> result = CombineWayAction.combineWaysWorker(actionWays);
        Main.main.undoRedo.add((Command)result.b);
        ++this.cmdsCount;
        return (Way)result.a;
    }

    private List<Multipolygon> collectMultipolygons(Collection<Way> selectedWays) {
        ArrayList<Multipolygon> result = new ArrayList<Multipolygon>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        ArrayList<Way> innerWays = new ArrayList<Way>();
        LinkedHashSet<Way> processedOuterWays = new LinkedHashSet<Way>();
        LinkedHashSet<Way> processedInnerWays = new LinkedHashSet<Way>();
        for (Relation r : OsmPrimitive.getParentRelations(selectedWays)) {
            if (r.isDeleted() || !r.isMultipolygon()) continue;
            boolean hasKnownOuter = false;
            outerWays.clear();
            innerWays.clear();
            for (RelationMember rm : r.getMembers()) {
                if ("outer".equalsIgnoreCase(rm.getRole())) {
                    outerWays.add(rm.getWay());
                    hasKnownOuter |= selectedWays.contains(rm.getWay());
                    continue;
                }
                if (!"inner".equalsIgnoreCase(rm.getRole())) continue;
                innerWays.add(rm.getWay());
            }
            if (!hasKnownOuter) continue;
            if (outerWays.size() > 1) {
                new Notification(I18n.tr("Sorry. Cannot handle multipolygon relations with multiple outer ways.", new Object[0])).setIcon(1).show();
                return null;
            }
            Way outerWay = (Way)outerWays.get(0);
            innerWays.retainAll(selectedWays);
            if (processedOuterWays.contains(outerWay)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is outer in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            if (processedInnerWays.contains(outerWay)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            for (Way way : innerWays) {
                if (processedOuterWays.contains(way)) {
                    new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                    return null;
                }
                if (!processedInnerWays.contains(way)) continue;
                new Notification(I18n.tr("Sorry. Cannot handle way that is inner in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            processedOuterWays.add(outerWay);
            processedInnerWays.addAll(innerWays);
            Multipolygon pol = new Multipolygon(outerWay);
            pol.innerWays.addAll(innerWays);
            result.add(pol);
        }
        for (Way way : selectedWays) {
            if (processedOuterWays.contains(way) || processedInnerWays.contains(way)) continue;
            result.add(new Multipolygon(way));
        }
        return result;
    }

    private RelationRole addOwnMultigonRelation(Collection<Way> inner, Way outer) {
        if (inner.isEmpty()) {
            return null;
        }
        Relation newRel = new Relation();
        newRel.put("type", "multipolygon");
        for (Way w : inner) {
            newRel.addMember(new RelationMember("inner", w));
        }
        this.cmds.add(new AddCommand(newRel));
        this.addedRelations.add(newRel);
        return new RelationRole(newRel, "outer");
    }

    private List<RelationRole> removeFromAllRelations(OsmPrimitive osm) {
        ArrayList<RelationRole> result = new ArrayList<RelationRole>();
        block0: for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (r.isDeleted()) continue;
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember() != osm) continue;
                Relation newRel = new Relation(r);
                List<RelationMember> members = newRel.getMembers();
                members.remove(rm);
                newRel.setMembers(members);
                this.cmds.add(new ChangeCommand(r, newRel));
                RelationRole saverel = new RelationRole(r, rm.getRole());
                if (result.contains(saverel)) continue block0;
                result.add(saverel);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return result;
    }

    private void fixRelations(List<RelationRole> rels, Way outer, RelationRole ownMultipol, Set<Relation> relationsToDelete) {
        Relation newRel;
        ArrayList<RelationRole> multiouters = new ArrayList<RelationRole>();
        if (ownMultipol != null) {
            multiouters.add(ownMultipol);
        }
        for (RelationRole r : rels) {
            if (r.rel.isMultipolygon() && "outer".equalsIgnoreCase(r.role)) {
                multiouters.add(r);
                continue;
            }
            Relation newRel2 = new Relation(r.rel);
            newRel2.addMember(new RelationMember(r.role, outer));
            this.cmds.add(new ChangeCommand(r.rel, newRel2));
        }
        switch (multiouters.size()) {
            case 0: {
                return;
            }
            case 1: {
                newRel = new Relation(((RelationRole)multiouters.get((int)0)).rel);
                newRel.addMember(new RelationMember(((RelationRole)multiouters.get((int)0)).role, outer));
                this.cmds.add(new ChangeCommand(((RelationRole)multiouters.get((int)0)).rel, newRel));
                return;
            }
        }
        newRel = new Relation();
        for (RelationRole r : multiouters) {
            for (RelationMember rm : r.rel.getMembers()) {
                if (newRel.getMembers().contains(rm)) continue;
                newRel.addMember(rm);
            }
            for (String key : r.rel.keySet()) {
                newRel.put(key, r.rel.get(key));
            }
            relationsToDelete.add(r.rel);
        }
        newRel.addMember(new RelationMember("outer", outer));
        this.cmds.add(new AddCommand(newRel));
    }

    private void stripTags(Collection<Way> ways) {
        for (Way w : ways) {
            this.stripTags(w);
        }
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    private void stripTags(Way x) {
        Way y = new Way(x);
        for (String key : x.keySet()) {
            y.remove(key);
        }
        this.cmds.add(new ChangeCommand(x, y));
    }

    private void makeCommitsOneAction(String message) {
        int i;
        UndoRedoHandler ur = Main.main.undoRedo;
        this.cmds.clear();
        for (i = Math.max(ur.commands.size() - this.cmdsCount, 0); i < ur.commands.size(); ++i) {
            this.cmds.add(ur.commands.get(i));
        }
        for (i = 0; i < this.cmds.size(); ++i) {
            ur.undo();
        }
        this.commitCommands(message == null ? I18n.marktr("Join Areas Function") : message);
        this.cmdsCount = 0;
    }

    @Override
    protected void updateEnabledState() {
        if (JoinAreasAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(JoinAreasAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    static class PolygonLevel {
        public final int level;
        public final AssembledMultipolygon pol;

        public PolygonLevel(AssembledMultipolygon pol, int level) {
            this.pol = pol;
            this.level = level;
        }
    }

    private static class WayTraverser {
        private Set<WayInPolygon> availableWays;
        private WayInPolygon lastWay;
        private boolean lastWayReverse;

        public WayTraverser(Collection<WayInPolygon> ways) {
            this.availableWays = new HashSet<WayInPolygon>(ways);
            this.lastWay = null;
        }

        public void removeWays(Collection<WayInPolygon> ways) {
            this.availableWays.removeAll(ways);
        }

        public void removeWay(WayInPolygon way) {
            this.availableWays.remove(way);
        }

        public void setStartWay(WayInPolygon way) {
            this.lastWay = way;
            this.lastWayReverse = !way.insideToTheRight;
        }

        public WayInPolygon startNewWay() {
            if (this.availableWays.isEmpty()) {
                this.lastWay = null;
            } else {
                this.lastWay = this.availableWays.iterator().next();
                this.lastWayReverse = !this.lastWay.insideToTheRight;
            }
            return this.lastWay;
        }

        private Node getHeadNode() {
            return !this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
        }

        private Node getPrevNode() {
            return !this.lastWayReverse ? this.lastWay.way.getNode(this.lastWay.way.getNodesCount() - 2) : this.lastWay.way.getNode(1);
        }

        private static double getAngle(Node N1, Node N2, Node N3) {
            double angle;
            EastNorth en1 = N1.getEastNorth();
            EastNorth en2 = N2.getEastNorth();
            EastNorth en3 = N3.getEastNorth();
            for (angle = Math.atan2(en3.getY() - en1.getY(), en3.getX() - en1.getX()) - Math.atan2(en2.getY() - en1.getY(), en2.getX() - en1.getX()); angle >= Math.PI * 2; angle -= Math.PI * 2) {
            }
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            return angle;
        }

        public WayInPolygon walk() {
            Node headNode = this.getHeadNode();
            Node prevNode = this.getPrevNode();
            double headAngle = Math.atan2(headNode.getEastNorth().east() - prevNode.getEastNorth().east(), headNode.getEastNorth().north() - prevNode.getEastNorth().north());
            double bestAngle = 0.0;
            WayInPolygon bestWay = null;
            boolean bestWayReverse = false;
            for (WayInPolygon way : this.availableWays) {
                Node nextNode;
                if (way.way.firstNode().equals(headNode) && way.insideToTheRight) {
                    nextNode = way.way.getNode(1);
                } else {
                    if (!way.way.lastNode().equals(headNode) || way.insideToTheRight) continue;
                    nextNode = way.way.getNode(way.way.getNodesCount() - 2);
                }
                if (nextNode == prevNode) {
                    this.lastWay = way;
                    this.lastWayReverse = !way.insideToTheRight;
                    return this.lastWay;
                }
                double angle = Math.atan2(nextNode.getEastNorth().east() - headNode.getEastNorth().east(), nextNode.getEastNorth().north() - headNode.getEastNorth().north()) - headAngle;
                if (angle > Math.PI) {
                    angle -= Math.PI * 2;
                }
                if (angle <= -Math.PI) {
                    angle += Math.PI * 2;
                }
                if (bestWay != null && !(angle > bestAngle)) continue;
                bestWay = way;
                bestWayReverse = !way.insideToTheRight;
                bestAngle = angle;
            }
            this.lastWay = bestWay;
            this.lastWayReverse = bestWayReverse;
            return this.lastWay;
        }

        public WayInPolygon leftComingWay() {
            Node headNode = this.getHeadNode();
            Node prevNode = this.getPrevNode();
            WayInPolygon mostLeft = null;
            boolean comingToHead = false;
            double angle = Math.PI * 2;
            for (WayInPolygon candidateWay : this.availableWays) {
                Node candidatePrevNode;
                boolean candidateComingToHead;
                if (candidateWay.way.firstNode().equals(headNode)) {
                    candidateComingToHead = !candidateWay.insideToTheRight;
                    candidatePrevNode = candidateWay.way.getNode(1);
                } else {
                    if (!candidateWay.way.lastNode().equals(headNode)) continue;
                    candidateComingToHead = candidateWay.insideToTheRight;
                    candidatePrevNode = candidateWay.way.getNode(candidateWay.way.getNodesCount() - 2);
                }
                if (candidateWay.equals(this.lastWay) && candidateComingToHead) continue;
                double candidateAngle = WayTraverser.getAngle(headNode, candidatePrevNode, prevNode);
                if (mostLeft != null && !(candidateAngle < angle) && (candidateAngle != angle || candidateComingToHead)) continue;
                mostLeft = candidateWay;
                comingToHead = candidateComingToHead;
                angle = candidateAngle;
            }
            return comingToHead ? mostLeft : null;
        }
    }

    public static class AssembledMultipolygon {
        public AssembledPolygon outerWay;
        public List<AssembledPolygon> innerWays;

        public AssembledMultipolygon(AssembledPolygon way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<AssembledPolygon>();
        }
    }

    public static class AssembledPolygon {
        public List<WayInPolygon> ways;

        public AssembledPolygon(List<WayInPolygon> boundary) {
            this.ways = boundary;
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (WayInPolygon way : this.ways) {
                int pos;
                if (way.insideToTheRight) {
                    for (pos = 0; pos < way.way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.way.getNode(pos));
                }
            }
            return nodes;
        }

        public void reverse() {
            for (WayInPolygon way : this.ways) {
                way.insideToTheRight = !way.insideToTheRight;
            }
            Collections.reverse(this.ways);
        }
    }

    public static class WayInPolygon {
        public final Way way;
        public boolean insideToTheRight;

        public WayInPolygon(Way way, boolean insideRight) {
            this.way = way;
            this.insideToTheRight = insideRight;
        }

        public int hashCode() {
            return this.way.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof WayInPolygon)) {
                return false;
            }
            WayInPolygon otherMember = (WayInPolygon)other;
            return otherMember.way.equals(this.way) && otherMember.insideToTheRight == this.insideToTheRight;
        }
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        public RelationRole(Relation rel, String role) {
            this.rel = rel;
            this.role = role;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelationRole)) {
                return false;
            }
            RelationRole otherMember = (RelationRole)other;
            return otherMember.role.equals(this.role) && otherMember.rel.equals(this.rel);
        }
    }

    public static class Multipolygon {
        public Way outerWay;
        public List<Way> innerWays;

        public Multipolygon(Way way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<Way>();
        }
    }

    public static class JoinAreasResult {
        public boolean hasChanges;
        public List<Multipolygon> polygons;
    }
}

