/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryAdjustAction
extends MapMode
implements AWTEventListener,
MouseListener,
MouseMotionListener {
    private static volatile ImageryOffsetDialog offsetDialog;
    private static Cursor cursor;
    private double oldDx;
    private double oldDy;
    private EastNorth prevEastNorth;
    private ImageryLayer layer;
    private MapMode oldMapMode;

    public ImageryAdjustAction(ImageryLayer layer) {
        super(I18n.tr("New offset", new Object[0]), "adjustimg", I18n.tr("Adjust the position of this imagery layer", new Object[0]), Main.map, cursor);
        this.putValue("toolbar", false);
        this.layer = layer;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        this.oldDx = this.layer.getDx();
        this.oldDy = this.layer.getDy();
        this.addListeners();
        offsetDialog = new ImageryOffsetDialog();
        offsetDialog.setVisible(true);
    }

    protected void addListeners() {
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Main.error(ex);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            if (this.layer != null) {
                this.layer.setOffset(this.oldDx, this.oldDy);
            }
            offsetDialog.setVisible(false);
            offsetDialog = null;
        }
        this.removeListeners();
    }

    protected void removeListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Main.error(ex);
        }
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.removeMouseMotionListener(this);
            Main.map.mapView.removeMouseListener(this);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof KeyEvent) || event.getID() != 401 || this.layer == null || offsetDialog != null && ImageryAdjustAction.offsetDialog.areFieldsInFocus()) {
            return;
        }
        KeyEvent kev = (KeyEvent)event;
        int dx = 0;
        int dy = 0;
        switch (kev.getKeyCode()) {
            case 38: {
                dy = 1;
                break;
            }
            case 40: {
                dy = -1;
                break;
            }
            case 37: {
                dx = -1;
                break;
            }
            case 39: {
                dx = 1;
            }
        }
        if (dx != 0 || dy != 0) {
            double ppd = this.layer.getPPD();
            this.layer.displace((double)dx / ppd, (double)dy / ppd);
            if (offsetDialog != null) {
                ImageryAdjustAction.offsetDialog.updateOffset();
            }
            kev.consume();
            Main.map.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.requestFocusInMapView();
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            Main.map.mapView.setNewCursor(13, (Object)this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        double dx = this.layer.getDx() + eastNorth.east() - this.prevEastNorth.east();
        double dy = this.layer.getDy() + eastNorth.north() - this.prevEastNorth.north();
        this.layer.setOffset(dx, dy);
        if (offsetDialog != null) {
            ImageryAdjustAction.offsetDialog.updateOffset();
        }
        Main.map.repaint();
        this.prevEastNorth = eastNorth;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.resetCursor(this);
        this.prevEastNorth = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (offsetDialog != null || this.layer == null || Main.map == null) {
            return;
        }
        this.oldMapMode = Main.map.mapMode;
        super.actionPerformed(e);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeListeners();
        this.layer = null;
        this.oldMapMode = null;
    }

    static {
        cursor = ImageProvider.getCursor("normal", "move");
    }

    private class ImageryOffsetDialog
    extends ExtendedDialog
    implements FocusListener {
        private final JosmTextField tOffset;
        private final JosmTextField tBookmarkName;
        private boolean ignoreListener;

        public ImageryOffsetDialog() {
            super(Main.parent, I18n.tr("Adjust imagery offset", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.tOffset = new JosmTextField();
            this.tBookmarkName = new JosmTextField();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.contentInsets = new Insets(10, 15, 5, 15);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)new JMultilineLabel(I18n.tr("Use arrow keys or drag the imagery layer with mouse to adjust the imagery offset.\nYou can also enter east and north offset in the {0} coordinates.\nIf you want to save the offset as bookmark, enter the bookmark name below", Main.getProjection().toString())), GBC.eop());
            pnl.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0])), GBC.std());
            pnl.add((Component)this.tOffset, GBC.eol().fill(2).insets(0, 0, 0, 5));
            pnl.add((Component)new JLabel(I18n.tr("Bookmark name: ", new Object[0])), GBC.std());
            pnl.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.tOffset.setColumns(16);
            this.updateOffsetIntl();
            this.tOffset.addFocusListener(this);
            this.setContent(pnl);
            this.setupDialog();
            this.addWindowListener(new WindowEventHandler());
        }

        private boolean areFieldsInFocus() {
            return this.tOffset.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.ignoreListener) {
                return;
            }
            String ostr = this.tOffset.getText();
            int semicolon = ostr.indexOf(59);
            if (semicolon >= 0 && semicolon + 1 < ostr.length()) {
                try {
                    String easting = ostr.substring(0, semicolon).trim().replace(',', '.');
                    String northing = ostr.substring(semicolon + 1).trim().replace(',', '.');
                    double dx = Double.parseDouble(easting);
                    double dy = Double.parseDouble(northing);
                    ImageryAdjustAction.this.layer.setOffset(dx, dy);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.updateOffsetIntl();
            if (Main.isDisplayingMapView()) {
                Main.map.repaint();
            }
        }

        private final void updateOffset() {
            this.ignoreListener = true;
            this.updateOffsetIntl();
            this.ignoreListener = false;
        }

        private final void updateOffsetIntl() {
            int precision = Main.getProjection().getDefaultZoomInPPD() >= 1.0 ? 2 : 7;
            try (Formatter us = new Formatter(Locale.US);){
                this.tOffset.setText(us.format("%1." + precision + "f; %1." + precision + "f", ImageryAdjustAction.this.layer.getDx(), ImageryAdjustAction.this.layer.getDy()).toString());
            }
        }

        private boolean confirmOverwriteBookmark() {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    this.contentInsets = new Insets(10, 15, 10, 15);
                }
            };
            dialog.setContent(I18n.tr("Offset bookmark already exists. Overwrite?", new Object[0]));
            dialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
            dialog.setupDialog();
            dialog.setVisible(true);
            return dialog.getValue() == 1;
        }

        @Override
        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            if (buttonIndex == 0 && this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty() && OffsetBookmark.getBookmarkByName(ImageryAdjustAction.this.layer, this.tBookmarkName.getText()) != null && !this.confirmOverwriteBookmark()) {
                return;
            }
            super.buttonAction(buttonIndex, evt);
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                return;
            }
            offsetDialog = null;
            if (this.getValue() != 1) {
                ImageryAdjustAction.this.layer.setOffset(ImageryAdjustAction.this.oldDx, ImageryAdjustAction.this.oldDy);
            } else if (this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty()) {
                OffsetBookmark.bookmarkOffset(this.tBookmarkName.getText(), ImageryAdjustAction.this.layer);
            }
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            if (Main.map == null) {
                return;
            }
            if (ImageryAdjustAction.this.oldMapMode != null) {
                Main.map.selectMapMode(ImageryAdjustAction.this.oldMapMode);
                ImageryAdjustAction.this.oldMapMode = null;
            } else {
                Main.map.selectSelectTool(false);
            }
        }

        class WindowEventHandler
        extends WindowAdapter {
            WindowEventHandler() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ImageryOffsetDialog.this.setVisible(false);
            }
        }
    }
}

