/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class FullscreenToggleAction
extends ToggleAction {
    private GraphicsDevice gd;
    private Rectangle prevBounds;

    public FullscreenToggleAction() {
        super(I18n.tr("Fullscreen view", new Object[0]), null, I18n.tr("Toggle fullscreen view", new Object[0]), Shortcut.registerShortcut("menu:view:fullscreen", I18n.tr("Toggle fullscreen view", new Object[0]), 122, 5003), false);
        this.putValue("help", HelpUtil.ht("/Action/FullscreenView"));
        this.putValue("toolbar", "fullscreen");
        Main.toolbar.register(this);
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.setSelected(Main.pref.getBoolean("draw.fullscreen", false));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        Main.pref.put("draw.fullscreen", this.isSelected());
        this.notifySelectedState();
        this.setMode();
    }

    public void initial() {
        if (this.isSelected()) {
            this.setMode();
        }
    }

    protected void setMode() {
        String exclusive;
        JFrame frame = (JFrame)Main.parent;
        ArrayList<Window> visibleWindows = new ArrayList<Window>();
        visibleWindows.add(frame);
        for (Window w : Frame.getWindows()) {
            if (!w.isVisible() || w == frame) continue;
            visibleWindows.add(w);
        }
        boolean selected = this.isSelected();
        frame.dispose();
        frame.setUndecorated(selected);
        if (selected) {
            this.prevBounds = frame.getBounds();
            frame.setBounds(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        }
        if ("true".equals(exclusive = Main.pref.get("draw.fullscreen.exclusive-mode", "auto")) || "auto".equals(exclusive) && !Main.isPlatformWindows()) {
            this.gd.setFullScreenWindow(selected ? frame : null);
        }
        if (!selected && this.prevBounds != null) {
            frame.setBounds(this.prevBounds);
        }
        for (Window wind : visibleWindows) {
            wind.setVisible(true);
        }
        frame.getJMenuBar().getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
    }
}

