/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.FileImporter;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    public static final ArrayList<FileImporter> importers;
    public static final ArrayList<FileExporter> exporters;
    private final String extensions;
    private final String description;
    private final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> filters) {
        Collections.sort(filters, new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter o1, ExtensionFileFilter o2) {
                if (o1.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (o2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
    }

    public static void updateAllFormatsImporter() {
        for (int i = 0; i < importers.size(); ++i) {
            if (!(importers.get(i) instanceof AllFormatsImporter)) continue;
            importers.set(i, new AllFormatsImporter());
        }
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        ExtensionFileFilter.updateAllFormatsImporter();
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileImporter importer : importers) {
            filters.add(importer.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileExporter exporter : exporters) {
            if (filters.contains(exporter.filter) || !exporter.isEnabled()) continue;
            filters.add(exporter.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter importer : importers) {
            if (!extension.equals(importer.filter.getDefaultExtension())) continue;
            return importer.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter exporter : exporters) {
            if (!extension.equals(exporter.filter.getDefaultExtension())) continue;
            return exporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(AbstractFileChooser fileChooser, String extension, boolean allTypes) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            if (!allTypes && !filter.acceptName("file." + extension)) continue;
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(extension));
    }

    public static void applyChoosableExportFileFilters(AbstractFileChooser fileChooser, String extension, boolean allTypes) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            if (!allTypes && !filter.acceptName("file." + extension)) continue;
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(extension));
    }

    public ExtensionFileFilter(String extension, String defaultExtension, String description) {
        this.extensions = extension;
        this.defaultExtension = defaultExtension;
        this.description = description;
    }

    public boolean acceptName(String filename) {
        String name = filename.toLowerCase();
        for (String ext : this.extensions.split(",")) {
            if (!name.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        return this.acceptName(pathname.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultExtension == null ? 0 : this.defaultExtension.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionFileFilter other = (ExtensionFileFilter)obj;
        if (this.defaultExtension == null ? other.defaultExtension != null : !this.defaultExtension.equals(other.defaultExtension)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions));
    }

    static {
        String[] exporterNames;
        String[] importerNames;
        importers = new ArrayList();
        for (String classname : importerNames = new String[]{"org.openstreetmap.josm.io.OsmImporter", "org.openstreetmap.josm.io.OsmGzipImporter", "org.openstreetmap.josm.io.OsmZipImporter", "org.openstreetmap.josm.io.OsmChangeImporter", "org.openstreetmap.josm.io.GpxImporter", "org.openstreetmap.josm.io.NMEAImporter", "org.openstreetmap.josm.io.NoteImporter", "org.openstreetmap.josm.io.OsmBzip2Importer", "org.openstreetmap.josm.io.JpgImporter", "org.openstreetmap.josm.io.WMSLayerImporter", "org.openstreetmap.josm.io.AllFormatsImporter", "org.openstreetmap.josm.io.session.SessionImporter"}) {
            try {
                FileImporter importer = (FileImporter)Class.forName(classname).newInstance();
                importers.add(importer);
                MapView.addLayerChangeListener(importer);
            }
            catch (Exception e) {
                if (!Main.isDebugEnabled()) continue;
                Main.debug(e.getMessage());
            }
            catch (ServiceConfigurationError e) {
                Main.error(e);
            }
        }
        exporters = new ArrayList();
        for (String classname : exporterNames = new String[]{"org.openstreetmap.josm.io.GpxExporter", "org.openstreetmap.josm.io.OsmExporter", "org.openstreetmap.josm.io.OsmGzipExporter", "org.openstreetmap.josm.io.OsmBzip2Exporter", "org.openstreetmap.josm.io.GeoJSONExporter", "org.openstreetmap.josm.io.WMSLayerExporter", "org.openstreetmap.josm.io.NoteExporter"}) {
            try {
                FileExporter exporter = (FileExporter)Class.forName(classname).newInstance();
                exporters.add(exporter);
                MapView.addLayerChangeListener(exporter);
            }
            catch (Exception e) {
                if (!Main.isDebugEnabled()) continue;
                Main.debug(e.getMessage());
            }
            catch (ServiceConfigurationError e) {
                Main.error(e);
            }
        }
    }
}

