/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.tools.I18n;

public class ExpertToggleAction
extends ToggleAction {
    private static final List<WeakReference<ExpertModeChangeListener>> listeners = new ArrayList<WeakReference<ExpertModeChangeListener>>();
    private static final List<WeakReference<Component>> visibilityToggleListeners = new ArrayList<WeakReference<Component>>();
    private static final ExpertToggleAction INSTANCE = new ExpertToggleAction();

    private static synchronized void fireExpertModeChanged(boolean isExpert) {
        Iterator<WeakReference<ExpertModeChangeListener>> it1 = listeners.iterator();
        while (it1.hasNext()) {
            WeakReference<ExpertModeChangeListener> wr = it1.next();
            ExpertModeChangeListener listener = (ExpertModeChangeListener)wr.get();
            if (listener == null) {
                it1.remove();
                continue;
            }
            listener.expertChanged(isExpert);
        }
        Iterator<WeakReference<Component>> it2 = visibilityToggleListeners.iterator();
        while (it2.hasNext()) {
            WeakReference<Component> wr = it2.next();
            Component c = (Component)wr.get();
            if (c == null) {
                it2.remove();
                continue;
            }
            c.setVisible(isExpert);
        }
    }

    public static void addExpertModeChangeListener(ExpertModeChangeListener listener) {
        ExpertToggleAction.addExpertModeChangeListener(listener, false);
    }

    public static synchronized void addExpertModeChangeListener(ExpertModeChangeListener listener, boolean fireWhenAdding) {
        if (listener == null) {
            return;
        }
        for (WeakReference<ExpertModeChangeListener> wr : listeners) {
            if (wr.get() != listener) continue;
            return;
        }
        listeners.add(new WeakReference<ExpertModeChangeListener>(listener));
        if (fireWhenAdding) {
            listener.expertChanged(ExpertToggleAction.isExpert());
        }
    }

    public static synchronized void removeExpertModeChangeListener(ExpertModeChangeListener listener) {
        if (listener == null) {
            return;
        }
        Iterator<WeakReference<ExpertModeChangeListener>> it = listeners.iterator();
        while (it.hasNext()) {
            WeakReference<ExpertModeChangeListener> wr = it.next();
            if (wr.get() != null && wr.get() != listener) continue;
            it.remove();
        }
    }

    public static synchronized void addVisibilitySwitcher(Component c) {
        if (c == null) {
            return;
        }
        for (WeakReference<Component> wr : visibilityToggleListeners) {
            if (wr.get() != c) continue;
            return;
        }
        visibilityToggleListeners.add(new WeakReference<Component>(c));
        c.setVisible(ExpertToggleAction.isExpert());
    }

    public static synchronized void removeVisibilitySwitcher(Component c) {
        if (c == null) {
            return;
        }
        Iterator<WeakReference<Component>> it = visibilityToggleListeners.iterator();
        while (it.hasNext()) {
            WeakReference<Component> wr = it.next();
            if (wr.get() != null && wr.get() != c) continue;
            it.remove();
        }
    }

    public ExpertToggleAction() {
        super(I18n.tr("Expert Mode", new Object[0]), "expert", I18n.tr("Enable/disable expert mode", new Object[0]), null, false);
        this.putValue("toolbar", "expertmode");
        Main.toolbar.register(this);
        this.setSelected(Main.pref.getBoolean("expert", false));
        this.notifySelectedState();
    }

    @Override
    protected final void notifySelectedState() {
        super.notifySelectedState();
        ExpertToggleAction.fireExpertModeChanged(this.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        Main.pref.put("expert", this.isSelected());
        this.notifySelectedState();
    }

    public static ExpertToggleAction getInstance() {
        return INSTANCE;
    }

    public static boolean isExpert() {
        return INSTANCE.isSelected();
    }

    public static interface ExpertModeChangeListener {
        public void expertChanged(boolean var1);
    }
}

