/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.download.DownloadObjectDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadPrimitiveAction
extends JosmAction {
    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object...", new Object[0]), "downloadprimitive", I18n.tr("Download OSM object by ID.", new Object[0]), Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download object...", new Object[0])), 79, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DownloadObjectDialog dialog = new DownloadObjectDialog();
        if (dialog.showDialog().getValue() != dialog.getContinueButtonIndex()) {
            return;
        }
        DownloadPrimitiveAction.processItems(dialog.isNewLayerRequested(), dialog.getOsmIds(), dialog.isReferrersRequested(), dialog.isFullRelationRequested());
    }

    public static void processItems(boolean newLayer, List<PrimitiveId> ids, boolean downloadReferrers, boolean full) {
        final DownloadPrimitivesWithReferrersTask task = new DownloadPrimitivesWithReferrersTask(newLayer, ids, downloadReferrers, full, null);
        Main.worker.submit(task);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                final List<PrimitiveId> downloaded = task.getDownloadedId();
                if (downloaded != null) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            Main.main.getCurrentDataSet().setSelected(downloaded);
                        }
                    });
                }
            }
        });
    }
}

