/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadAction
extends JosmAction {
    public DownloadAction() {
        super(I18n.tr("Download from OSM...", new Object[0]), "download", I18n.tr("Download map data from the OSM server.", new Object[0]), Shortcut.registerShortcut("file:download", I18n.tr("File: {0}", I18n.tr("Download from OSM...", new Object[0])), 40, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Download"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DownloadDialog dialog = DownloadDialog.getInstance();
        dialog.restoreSettings();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            Future<?> future;
            AbstractDownloadTask task;
            dialog.rememberSettings();
            Bounds area = dialog.getSelectedDownloadArea();
            if (dialog.isDownloadOsmData()) {
                task = new DownloadOsmTask();
                future = ((DownloadOsmTask)task).download(dialog.isNewLayerRequired(), area, null);
                Main.worker.submit(new PostDownloadHandler((DownloadTask)task, future));
            }
            if (dialog.isDownloadGpxData()) {
                task = new DownloadGpsTask();
                future = ((DownloadGpsTask)task).download(dialog.isNewLayerRequired(), area, null);
                Main.worker.submit(new PostDownloadHandler((DownloadTask)task, future));
            }
            if (dialog.isDownloadNotes()) {
                task = new DownloadNotesTask();
                future = ((DownloadNotesTask)task).download(false, area, null);
                Main.worker.submit(new PostDownloadHandler((DownloadTask)task, future));
            }
        }
    }
}

