/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class DistributeAction
extends JosmAction {
    public DistributeAction() {
        super(I18n.tr("Distribute Nodes", new Object[0]), "distribute", I18n.tr("Distribute the selected nodes to equal distances along a line.", new Object[0]), Shortcut.registerShortcut("tools:distribute", I18n.tr("Tool: {0}", I18n.tr("Distribute Nodes", new Object[0])), 66, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/DistributeNodes"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = DistributeAction.getCurrentDataSet().getSelected();
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Node> itnodes = new LinkedList<Node>();
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            nodes.add((Node)osm);
            itnodes.add((Node)osm);
        }
        if (nodes.isEmpty() && sel.size() == 1) {
            for (OsmPrimitive osm : sel) {
                if (!(osm instanceof Way)) continue;
                nodes.addAll(((Way)osm).getNodes());
                itnodes.addAll(((Way)osm).getNodes());
            }
        }
        Set<Node> ignoredNodes = this.removeNodesWithoutCoordinates(nodes);
        ignoredNodes.addAll(this.removeNodesWithoutCoordinates(itnodes));
        if (!ignoredNodes.isEmpty()) {
            Main.warn(I18n.tr("Ignoring {0} nodes with null coordinates", ignoredNodes.size()));
            ignoredNodes.clear();
        }
        if (nodes.size() < 3) {
            new Notification(I18n.tr("Please select at least three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        double distance = 0.0;
        Node nodea = null;
        Node nodeb = null;
        for (Node n : nodes) {
            itnodes.remove(n);
            for (Node m : itnodes) {
                double dist = Math.sqrt(n.getEastNorth().distance(m.getEastNorth()));
                if (!(dist > distance)) continue;
                nodea = n;
                nodeb = m;
                distance = dist;
            }
        }
        nodes.remove(nodea);
        nodes.remove(nodeb);
        double ax = nodea.getEastNorth().east();
        double ay = nodea.getEastNorth().north();
        double bx = nodeb.getEastNorth().east();
        double by = nodeb.getEastNorth().north();
        LinkedList<Command> cmds = new LinkedList<Command>();
        int num = nodes.size() + 1;
        int pos = 0;
        while (!nodes.isEmpty()) {
            ++pos;
            Node s = null;
            distance = 0.0;
            for (Node n : nodes) {
                double dist = Math.sqrt(nodeb.getEastNorth().distance(n.getEastNorth()));
                if (!(dist > distance)) continue;
                s = n;
                distance = dist;
            }
            double dx = ax - s.getEastNorth().east() + (bx - ax) * (double)pos / (double)num;
            double dy = ay - s.getEastNorth().north() + (by - ay) * (double)pos / (double)num;
            cmds.add(new MoveCommand((OsmPrimitive)s, dx, dy));
            nodes.remove(s);
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Distribute Nodes", new Object[0]), cmds));
        Main.map.repaint();
    }

    private Set<Node> removeNodesWithoutCoordinates(Collection<Node> col) {
        HashSet<Node> result = new HashSet<Node>();
        Iterator<Node> it = col.iterator();
        while (it.hasNext()) {
            Node n = it.next();
            if (n.isLatLonKnown()) continue;
            it.remove();
            result.add(n);
        }
        return result;
    }

    @Override
    protected void updateEnabledState() {
        if (DistributeAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(DistributeAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

