/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DialogsToggleAction
extends ToggleAction {
    public DialogsToggleAction() {
        super(I18n.tr("Toggle dialogs panel", new Object[0]), (ImageProvider)null, I18n.tr("Toggle dialogs panel, maximize mapview", new Object[0]), Shortcut.registerShortcut("menu:view:dialogspanel", I18n.tr("Toggle dialogs panel", new Object[0]), 9, 5003), true, "dialogspanel", false);
        this.putValue("help", HelpUtil.ht("/Action/ToggleDialogsPanel"));
        this.setSelected(Main.pref.getBoolean("draw.dialogspanel", true));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        Main.pref.put("draw.dialogspanel", this.isSelected());
        this.notifySelectedState();
        this.setMode();
    }

    public void initial() {
        if (this.isSelected()) {
            this.setMode();
        }
    }

    protected void setMode() {
        if (Main.isDisplayingMapView()) {
            boolean selected = this.isSelected();
            Main.map.setDialogsPanelVisible(selected);
            Main.map.statusLine.setVisible(selected || Main.pref.getBoolean("statusbar.always-visible", true));
            Main.toolbar.control.setVisible(selected || Main.pref.getBoolean("toolbar.always-visible", true));
            Main.main.menu.setVisible(selected || Main.pref.getBoolean("menu.always-visible", true));
            if (!Main.pref.getBoolean("sidetoolbar.always-visible", true)) {
                Main.pref.put("sidetoolbar.visible", selected);
            }
            Main.map.mapView.rememberLastPositionOnScreen();
        }
    }
}

