/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class CreateMultipolygonAction
extends JosmAction {
    private final boolean update;
    public static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "fence_type", "source");

    public CreateMultipolygonAction(boolean update) {
        super(CreateMultipolygonAction.getName(update), "multipoly_create", CreateMultipolygonAction.getName(update), update ? Shortcut.registerShortcut("tools:multipoly_update", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(true)), 66, 5009) : Shortcut.registerShortcut("tools:multipoly_create", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(false)), 66, 5006), true, update ? "multipoly_update" : "multipoly_create", true);
        this.update = update;
    }

    private static String getName(boolean update) {
        return update ? I18n.tr("Update multipolygon", new Object[0]) : I18n.tr("Create multipolygon", new Object[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation multipolygonRelation;
        if (!Main.main.hasEditLayer()) {
            new Notification(I18n.tr("No data loaded.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Way> selectedWays = Main.main.getCurrentDataSet().getSelectedWays();
        Collection<Relation> selectedRelations = Main.main.getCurrentDataSet().getSelectedRelations();
        if (selectedWays.isEmpty()) {
            new Notification(I18n.tr("You must select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Relation relation = multipolygonRelation = this.update ? CreateMultipolygonAction.getSelectedMultipolygonRelation(selectedWays, selectedRelations) : null;
        if (multipolygonRelation != null) {
            if (!multipolygonRelation.isNew() && multipolygonRelation.isIncomplete()) {
                Main.worker.submit(new DownloadRelationTask(Collections.singleton(multipolygonRelation), Main.main.getEditLayer()));
            } else if (multipolygonRelation.hasIncompleteMembers()) {
                Main.worker.submit(new DownloadRelationMemberTask(multipolygonRelation, DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(Collections.singleton(multipolygonRelation)), Main.main.getEditLayer()));
            }
        }
        Main.worker.submit(new CreateUpdateMultipolygonTask(selectedWays, multipolygonRelation));
    }

    private Relation getSelectedMultipolygonRelation() {
        return CreateMultipolygonAction.getSelectedMultipolygonRelation(CreateMultipolygonAction.getCurrentDataSet().getSelectedWays(), CreateMultipolygonAction.getCurrentDataSet().getSelectedRelations());
    }

    private static Relation getSelectedMultipolygonRelation(Collection<Way> selectedWays, Collection<Relation> selectedRelations) {
        if (selectedRelations.size() == 1 && "multipolygon".equals(selectedRelations.iterator().next().get("type"))) {
            return selectedRelations.iterator().next();
        }
        HashSet relatedRelations = new HashSet();
        for (Way w : selectedWays) {
            relatedRelations.addAll(Utils.filteredCollection(w.getReferrers(), Relation.class));
        }
        return relatedRelations.size() == 1 ? (Relation)relatedRelations.iterator().next() : null;
    }

    public static Pair<Relation, Relation> updateMultipolygonRelation(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        HashSet<Way> ways = new HashSet<Way>(selectedWays);
        ways.addAll(selectedMultipolygonRelation.getMemberPrimitives(Way.class));
        MultipolygonBuilder polygon = CreateMultipolygonAction.analyzeWays(ways, true);
        if (polygon == null) {
            return null;
        }
        return Pair.create(selectedMultipolygonRelation, CreateMultipolygonAction.createRelation(polygon, new Relation(selectedMultipolygonRelation)));
    }

    public static Pair<Relation, Relation> createMultipolygonRelation(Collection<Way> selectedWays, boolean showNotif) {
        MultipolygonBuilder polygon = CreateMultipolygonAction.analyzeWays(selectedWays, showNotif);
        if (polygon == null) {
            return null;
        }
        return Pair.create(null, CreateMultipolygonAction.createRelation(polygon, new Relation()));
    }

    public static Pair<SequenceCommand, Relation> createMultipolygonCommand(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        String commandName;
        Pair<Relation, Relation> rr;
        Pair<Relation, Relation> pair = rr = selectedMultipolygonRelation == null ? CreateMultipolygonAction.createMultipolygonRelation(selectedWays, true) : CreateMultipolygonAction.updateMultipolygonRelation(selectedWays, selectedMultipolygonRelation);
        if (rr == null) {
            return null;
        }
        Relation existingRelation = (Relation)rr.a;
        Relation relation = (Relation)rr.b;
        List<Command> list = CreateMultipolygonAction.removeTagsFromWaysIfNeeded(relation);
        if (existingRelation == null) {
            list.add(new AddCommand(relation));
            commandName = CreateMultipolygonAction.getName(false);
        } else {
            list.add(new ChangeCommand(existingRelation, relation));
            commandName = CreateMultipolygonAction.getName(true);
        }
        return Pair.create(new SequenceCommand(commandName, list), relation);
    }

    @Override
    protected void updateEnabledState() {
        if (CreateMultipolygonAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateMultipolygonAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (this.update) {
            this.setEnabled(this.getSelectedMultipolygonRelation() != null);
        } else {
            this.setEnabled(!CreateMultipolygonAction.getCurrentDataSet().getSelectedWays().isEmpty());
        }
    }

    private static MultipolygonBuilder analyzeWays(Collection<Way> selectedWays, boolean showNotif) {
        MultipolygonBuilder pol = new MultipolygonBuilder();
        final String error = pol.makeFromWays(selectedWays);
        if (error != null) {
            if (showNotif) {
                GuiHelper.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        new Notification(error).setIcon(1).show();
                    }
                });
            }
            return null;
        }
        return pol;
    }

    private static Relation createRelation(MultipolygonBuilder pol, Relation rel) {
        rel.put("type", "multipolygon");
        for (MultipolygonBuilder.JoinedPolygon jway : pol.outerWays) {
            CreateMultipolygonAction.addMembers(jway, rel, "outer");
        }
        for (MultipolygonBuilder.JoinedPolygon jway : pol.innerWays) {
            CreateMultipolygonAction.addMembers(jway, rel, "inner");
        }
        return rel;
    }

    private static void addMembers(MultipolygonBuilder.JoinedPolygon polygon, Relation rel, String role) {
        int count = rel.getMembersCount();
        HashSet<Way> ways = new HashSet<Way>(polygon.ways);
        for (int i = 0; i < count; ++i) {
            RelationMember m = rel.getMember(i);
            if (!ways.contains(m.getMember()) || role.equals(m.getRole())) continue;
            rel.setMember(i, new RelationMember(role, m.getMember()));
        }
        ways.removeAll(rel.getMemberPrimitives());
        for (Way way : ways) {
            rel.addMember(new RelationMember(role, way));
        }
    }

    public static List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        HashMap<String, String> values = new HashMap<String, String>(relation.getKeys());
        ArrayList<Way> innerWays = new ArrayList<Way>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        TreeSet<String> conflictingKeys = new TreeSet<String>();
        for (RelationMember m : relation.getMembers()) {
            if (m.hasRole() && "inner".equals(m.getRole()) && m.isWay() && m.getWay().hasKeys()) {
                innerWays.add(m.getWay());
            }
            if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay() || !m.getWay().hasKeys()) continue;
            Way way = m.getWay();
            outerWays.add(way);
            for (String key : way.keySet()) {
                if (!values.containsKey(key)) {
                    values.put(key, way.get(key));
                    continue;
                }
                if (relation.hasKey(key) || ((String)values.get(key)).equals(way.get(key))) continue;
                conflictingKeys.add(key);
            }
        }
        if (!Main.pref.getBoolean("multipoly.alltags", false)) {
            for (RelationMember m : relation.getMembers()) {
                if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay()) continue;
                for (String string : values.keySet()) {
                    if (m.getWay().hasKey(string) || relation.hasKey(string)) continue;
                    conflictingKeys.add(string);
                }
            }
        }
        for (String key : conflictingKeys) {
            values.remove(key);
        }
        for (String linearTag : Main.pref.getCollection("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            values.remove(linearTag);
        }
        if ("coastline".equals(values.get("natural"))) {
            values.remove("natural");
        }
        values.put("area", "yes");
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean moveTags = Main.pref.getBoolean("multipoly.movetags", true);
        for (Map.Entry entry : values.entrySet()) {
            ArrayList<Way> affectedWays = new ArrayList<Way>();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            for (Way way : innerWays) {
                if (!value.equals(way.get(key))) continue;
                affectedWays.add(way);
            }
            if (moveTags) {
                for (Way way : outerWays) {
                    if (!way.hasKey(key)) continue;
                    affectedWays.add(way);
                }
            }
            if (affectedWays.isEmpty()) continue;
            commands.add(new ChangePropertyCommand(affectedWays, key, null));
        }
        if (moveTags) {
            boolean fixed = false;
            Relation relation2 = new Relation(relation);
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (relation2.hasKey(key) || "area".equals(key)) continue;
                if (relation.isNew()) {
                    relation.put(key, (String)entry.getValue());
                } else {
                    relation2.put(key, (String)entry.getValue());
                }
                fixed = true;
            }
            if (fixed && !relation.isNew()) {
                commands.add(new ChangeCommand(relation, relation2));
            }
        }
        return commands;
    }

    private static class CreateUpdateMultipolygonTask
    implements Runnable {
        private final Collection<Way> selectedWays;
        private final Relation multipolygonRelation;

        private CreateUpdateMultipolygonTask(Collection<Way> selectedWays, Relation multipolygonRelation) {
            this.selectedWays = selectedWays;
            this.multipolygonRelation = multipolygonRelation;
        }

        @Override
        public void run() {
            Pair<SequenceCommand, Relation> commandAndRelation = CreateMultipolygonAction.createMultipolygonCommand(this.selectedWays, this.multipolygonRelation);
            if (commandAndRelation == null) {
                return;
            }
            final Command command = (Command)commandAndRelation.a;
            final Relation relation = (Relation)commandAndRelation.b;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.main.undoRedo.add(command);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Main.map.relationListDialog.selectRelation(relation);
                            if (Main.pref.getBoolean("multipoly.show-relation-editor", false)) {
                                RelationEditor editor = RelationEditor.getEditor(Main.main.getEditLayer(), relation, null);
                                editor.setModal(true);
                                editor.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }
}

