/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "aligncircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true, "createcircle", true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private int[] distributeNodes(PolarNode[] angles, int nodesCount) {
        int[] count = new int[angles.length];
        double[] width = new double[angles.length];
        double[] remainder = new double[angles.length];
        for (int i = 0; i < angles.length; ++i) {
            width[i] = angles[(i + 1) % angles.length].a - angles[i].a;
            if (!(width[i] < 0.0)) continue;
            int n = i;
            width[n] = width[n] + Math.PI * 2;
        }
        int assign = 0;
        for (int i = 0; i < angles.length; ++i) {
            double part = width[i] / 2.0 / Math.PI * (double)nodesCount;
            count[i] = (int)Math.floor(part);
            remainder[i] = part - (double)count[i];
            assign += count[i];
        }
        while (assign < nodesCount) {
            int imax = 0;
            for (int i = 1; i < angles.length; ++i) {
                if (!(remainder[i] > remainder[imax])) continue;
                imax = i;
            }
            int n = imax;
            count[n] = count[n] + 1;
            remainder[imax] = 0.0;
            ++assign;
        }
        return count;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object n1;
        if (!this.isEnabled()) {
            return;
        }
        int numberOfNodesInCircle = Main.pref.getInteger("createcircle.nodecount", 16);
        if (numberOfNodesInCircle < 1) {
            numberOfNodesInCircle = 1;
        } else if (numberOfNodesInCircle > 100) {
            numberOfNodesInCircle = 100;
        }
        Collection<OsmPrimitive> sel = CreateCircleAction.getCurrentDataSet().getSelected();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Way existingWay = null;
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            nodes.add((Node)osm);
        }
        if (nodes.isEmpty() && sel.size() == 1) {
            for (OsmPrimitive osm : sel) {
                if (!(osm instanceof Way)) continue;
                existingWay = (Way)osm;
                for (Node n : ((Way)osm).getNodes()) {
                    if (nodes.contains(n)) continue;
                    nodes.add(n);
                }
            }
        }
        if (nodes.size() < 2 || nodes.size() > 3) {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        EastNorth center = null;
        if (nodes.size() == 2) {
            n1 = (Node)nodes.get(0);
            double x1 = ((Node)n1).getEastNorth().east();
            double y1 = ((Node)n1).getEastNorth().north();
            Node n2 = (Node)nodes.get(1);
            double x2 = n2.getEastNorth().east();
            double y2 = n2.getEastNorth().north();
            double xc = 0.5 * (x1 + x2);
            double yc = 0.5 * (y1 + y2);
            center = new EastNorth(xc, yc);
        } else {
            center = Geometry.getCenter(nodes);
            if (center == null) {
                CreateCircleAction.notifyNodesNotOnCircle();
                return;
            }
        }
        n1 = ((Node)nodes.get(0)).getEastNorth();
        double r = Math.sqrt(Math.pow(center.east() - ((EastNorth)n1).east(), 2.0) + Math.pow(center.north() - ((EastNorth)n1).north(), 2.0));
        PolarNode[] angles = new PolarNode[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            angles[i] = new PolarNode(center, (Node)nodes.get(i));
        }
        Arrays.sort(angles, new PolarNodeComparator());
        int[] count = this.distributeNodes(angles, numberOfNodesInCircle >= nodes.size() ? numberOfNodesInCircle - nodes.size() : 0);
        ArrayList<Node> wayToAdd = new ArrayList<Node>();
        for (int i = 0; i < nodes.size(); ++i) {
            wayToAdd.add(angles[i].node);
            double delta = angles[(i + 1) % nodes.size()].a - angles[i].a;
            if (delta < 0.0) {
                delta += Math.PI * 2;
            }
            for (int j = 0; j < count[i]; ++j) {
                double alpha = angles[i].a + (double)(j + 1) * delta / (double)(count[i] + 1);
                double x = center.east() + r * Math.cos(alpha);
                double y = center.north() + r * Math.sin(alpha);
                LatLon ll = Main.getProjection().eastNorth2latlon(new EastNorth(x, y));
                if (ll.isOutSideWorld()) {
                    CreateCircleAction.notifyNodesNotOnCircle();
                    return;
                }
                Node n = new Node(ll);
                wayToAdd.add(n);
                cmds.add(new AddCommand(n));
            }
        }
        wayToAdd.add((Node)wayToAdd.get(0));
        if (existingWay == null) {
            Way newWay = new Way();
            newWay.setNodes(wayToAdd);
            cmds.add(new AddCommand(newWay));
        } else {
            Way newWay = new Way(existingWay);
            newWay.setNodes(wayToAdd);
            cmds.add(new ChangeCommand(existingWay, newWay));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), cmds));
        Main.map.repaint();
    }

    private static void notifyNodesNotOnCircle() {
        new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
    }

    @Override
    protected void updateEnabledState() {
        if (CreateCircleAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateCircleAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private static class PolarNodeComparator
    implements Comparator<PolarNode> {
        private PolarNodeComparator() {
        }

        @Override
        public int compare(PolarNode pc1, PolarNode pc2) {
            if (pc1.a < pc2.a) {
                return -1;
            }
            if (pc1.a == pc2.a) {
                return 0;
            }
            return 1;
        }
    }

    private static class PolarNode {
        double a;
        Node node;

        PolarNode(EastNorth center, Node n) {
            EastNorth pt = n.getEastNorth();
            this.a = Math.atan2(pt.north() - center.north(), pt.east() - center.east());
            this.node = n;
        }
    }
}

