/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class CopyAction
extends JosmAction {
    public static final String CLIPBOARD_REGEXP = "((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+";

    public CopyAction() {
        super(I18n.tr("Copy", new Object[0]), "copy", I18n.tr("Copy selected objects to paste buffer.", new Object[0]), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 67, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
        Main.registerActionShortcut(this, Shortcut.registerShortcut("system:copy:cua", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 155, 5006));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection<OsmPrimitive> selection = CopyAction.getCurrentDataSet().getSelected();
        CopyAction.copy(CopyAction.getEditLayer(), selection);
    }

    public static void copy(OsmDataLayer source, Collection<OsmPrimitive> primitives) {
        StringBuilder idsBuilder = new StringBuilder();
        for (OsmPrimitive p : primitives) {
            idsBuilder.append(OsmPrimitiveType.from(p).getAPIName()).append(" ");
            idsBuilder.append(p.getId()).append(",");
        }
        String ids = idsBuilder.substring(0, idsBuilder.length() - 1);
        Utils.copyToClipboard(ids);
        Main.pasteBuffer.makeCopy(primitives);
        Main.pasteSource = source;
    }

    @Override
    protected void updateEnabledState() {
        if (CopyAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CopyAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection<OsmPrimitive> sel = CopyAction.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return true;
        }
        return false;
    }
}

