/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final Collection<String> MODES = Collections.unmodifiableList(Arrays.asList(I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download"), I18n.marktr("problem"), I18n.marktr("previous"), I18n.marktr("next")));
    private final String mode;
    protected ZoomChangeAdapter zoomChangeAdapter;
    protected MapFrameAdapter mapFrameAdapter;

    public static void zoomToSelection() {
        if (Main.main == null || !Main.main.hasEditLayer()) {
            return;
        }
        Collection<OsmPrimitive> sel = Main.main.getEditLayer().data.getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing selected to zoom to.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        AutoScaleAction.zoomTo(sel);
    }

    public static void zoomTo(Collection<OsmPrimitive> sel) {
        BoundingXYVisitor bboxCalculator = new BoundingXYVisitor();
        bboxCalculator.computeBoundingBox(sel);
        bboxCalculator.enlargeBoundingBox();
        if (bboxCalculator.getBounds() != null) {
            Main.map.mapView.zoomTo(bboxCalculator);
        }
    }

    public static void autoScale(String mode) {
        new AutoScaleAction(mode, false).autoScale();
    }

    private static int getModeShortcut(String mode) {
        int shortcut = -1;
        if (mode.equals("data")) {
            shortcut = 49;
        } else if (mode.equals("layer")) {
            shortcut = 50;
        } else if (mode.equals("selection")) {
            shortcut = 51;
        } else if (mode.equals("conflict")) {
            shortcut = 52;
        } else if (mode.equals("download")) {
            shortcut = 53;
        } else if (mode.equals("problem")) {
            shortcut = 54;
        } else if (mode.equals("previous")) {
            shortcut = 56;
        } else if (mode.equals("next")) {
            shortcut = 57;
        }
        return shortcut;
    }

    private AutoScaleAction(String mode, boolean marker) {
        super(false);
        this.mode = mode;
    }

    public AutoScaleAction(String mode) {
        super(I18n.tr("Zoom to {0}", I18n.tr(mode, new Object[0])), "dialogs/autoscale/" + mode, I18n.tr("Zoom the view to {0}.", I18n.tr(mode, new Object[0])), Shortcut.registerShortcut("view:zoom" + mode, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(mode, new Object[0]))), AutoScaleAction.getModeShortcut(mode), 5003), true, null, false);
        String modeHelp = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
        this.putValue("help", "Action/AutoScale/" + modeHelp);
        this.mode = mode;
        switch (mode) {
            case "data": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToData"));
                break;
            }
            case "layer": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToLayer"));
                break;
            }
            case "selection": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToSelection"));
                break;
            }
            case "conflict": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToConflict"));
                break;
            }
            case "problem": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToProblem"));
                break;
            }
            case "download": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToDownload"));
                break;
            }
            case "previous": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToPrevious"));
                break;
            }
            case "next": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToNext"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        this.installAdapters();
    }

    public void autoScale() {
        if (Main.isDisplayingMapView()) {
            switch (this.mode) {
                case "previous": {
                    Main.map.mapView.zoomPrevious();
                    break;
                }
                case "next": {
                    Main.map.mapView.zoomNext();
                    break;
                }
                default: {
                    BoundingXYVisitor bbox = this.getBoundingBox();
                    if (bbox == null || bbox.getBounds() == null) break;
                    Main.map.mapView.zoomTo(bbox);
                }
            }
        }
        this.putValue("active", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.autoScale();
    }

    protected Layer getFirstSelectedLayer() {
        List<Layer> layers = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (layers.isEmpty()) {
            return null;
        }
        return layers.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor v = "problem".equals(this.mode) ? new ValidatorDialog.ValidatorBoundingXYVisitor() : new BoundingXYVisitor();
        switch (this.mode) {
            case "problem": {
                TestError error = Main.map.validatorDialog.getSelectedError();
                if (error == null) {
                    return null;
                }
                ((ValidatorDialog.ValidatorBoundingXYVisitor)v).visit(error);
                if (v.getBounds() == null) {
                    return null;
                }
                v.enlargeBoundingBox(Main.pref.getDouble("validator.zoom-enlarge-bbox", 2.0E-4));
                break;
            }
            case "data": {
                for (Layer l : Main.map.mapView.getAllLayers()) {
                    l.visitBoundingBox(v);
                }
                break;
            }
            case "layer": {
                if (Main.main.getActiveLayer() == null) {
                    return null;
                }
                Layer l = this.getFirstSelectedLayer();
                if (l == null) {
                    return null;
                }
                l.visitBoundingBox(v);
                break;
            }
            case "selection": 
            case "conflict": {
                Collection<Object> sel = new HashSet();
                if ("selection".equals(this.mode)) {
                    sel = AutoScaleAction.getCurrentDataSet().getSelected();
                } else {
                    Conflict<? extends OsmPrimitive> c = Main.map.conflictDialog.getSelectedConflict();
                    if (c != null) {
                        sel.add(c.getMy());
                    } else if (Main.map.conflictDialog.getConflicts() != null) {
                        sel = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                    }
                }
                if (sel.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, "selection".equals(this.mode) ? I18n.tr("Nothing selected to zoom to.", new Object[0]) : I18n.tr("No conflicts to zoom to", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : sel) {
                    osmPrimitive.accept(v);
                }
                v.enlargeBoundingBoxLogarithmically(100.0);
                v.enlargeToMinSize(Main.pref.getDouble("zoom_to_selection_min_size_in_meter", 100.0));
                break;
            }
            case "download": {
                Bounds bounds = DownloadDialog.getSavedDownloadBounds();
                if (bounds == null) break;
                try {
                    v.visit(bounds);
                    break;
                }
                catch (Exception exception) {
                    Main.warn(exception);
                }
            }
        }
        return v;
    }

    @Override
    protected void updateEnabledState() {
        switch (this.mode) {
            case "selection": {
                this.setEnabled(AutoScaleAction.getCurrentDataSet() != null && !AutoScaleAction.getCurrentDataSet().getSelected().isEmpty());
                break;
            }
            case "layer": {
                if (!Main.isDisplayingMapView() || Main.map.mapView.getAllLayersAsList().isEmpty()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case "conflict": {
                this.setEnabled(Main.map != null && Main.map.conflictDialog.getSelectedConflict() != null);
                break;
            }
            case "problem": {
                this.setEnabled(Main.map != null && Main.map.validatorDialog.getSelectedError() != null);
                break;
            }
            case "previous": {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomUndoEntries());
                break;
            }
            case "next": {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomRedoEntries());
                break;
            }
            default: {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasLayers());
            }
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }
    }

    @Override
    protected final void installAdapters() {
        super.installAdapters();
        this.zoomChangeAdapter = new ZoomChangeAdapter();
        MapView.addZoomChangeListener(this.zoomChangeAdapter);
        this.mapFrameAdapter = new MapFrameAdapter();
        Main.addMapFrameListener(this.mapFrameAdapter);
        this.initEnabledState();
    }

    private class MapFrameAdapter
    implements MapFrameListener {
        private ListSelectionListener conflictSelectionListener;
        private TreeSelectionListener validatorSelectionListener;

        public MapFrameAdapter() {
            if ("conflict".equals(AutoScaleAction.this.mode)) {
                this.conflictSelectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            } else if ("problem".equals(AutoScaleAction.this.mode)) {
                this.validatorSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            }
        }

        @Override
        public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
            if (this.conflictSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.conflictDialog.addListSelectionListener(this.conflictSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.conflictDialog.removeListSelectionListener(this.conflictSelectionListener);
                }
            } else if (this.validatorSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.validatorDialog.addTreeSelectionListener(this.validatorSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.validatorDialog.removeTreeSelectionListener(this.validatorSelectionListener);
                }
            }
        }
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        @Override
        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

