/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.actionsupport.AlignImageryPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo info) {
        super(info.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", info.getName()), null, false, false);
        this.putValue("toolbar", "imagery_" + info.getToolbarName());
        this.putValue("help", HelpUtil.ht("/Preferences/Imagery"));
        this.info = info;
        this.installAdapters();
        try {
            String icon = info.getIcon();
            if (icon != null) {
                new ImageProvider(icon).setOptional(true).getInBackground(new ImageProvider.ImageResourceCallback(){

                    @Override
                    public void finished(final ImageResource result) {
                        if (result != null) {
                            GuiHelper.runInEDT(new Runnable(){

                                @Override
                                public void run() {
                                    result.getImageIcon(AddImageryLayerAction.this);
                                }
                            });
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ImageryInfo infoToAdd;
            ImageryInfo imageryInfo = infoToAdd = ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()) ? this.getWMSLayerInfo() : this.info;
            if (infoToAdd != null) {
                Main.main.addLayer(ImageryLayer.create(infoToAdd));
                AlignImageryPanel.addNagPanelIfNeeded();
            }
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage() == null || ex.getMessage().isEmpty()) {
                throw ex;
            }
            JOptionPane.showMessageDialog(Main.parent, ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected ImageryInfo getWMSLayerInfo() {
        try {
            assert (ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()));
            WMSImagery wms = new WMSImagery();
            wms.attemptGetCapabilities(this.info.getUrl());
            final WMSLayerTree tree = new WMSLayerTree();
            tree.updateTree(wms);
            final JComboBox<String> formats = new JComboBox<String>(wms.getFormats().toArray(new String[0]));
            formats.setSelectedItem(wms.getPreferredFormats());
            formats.setToolTipText(I18n.tr("Select image format for WMS layer", new Object[0]));
            if (1 != new ExtendedDialog(Main.parent, I18n.tr("Select WMS layers", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    super(x0, x1, x2);
                    JScrollPane scrollPane = new JScrollPane(tree.getLayerTree());
                    scrollPane.setPreferredSize(new Dimension(400, 400));
                    JPanel panel = new JPanel(new GridBagLayout());
                    panel.add((Component)scrollPane, GBC.eol().fill());
                    panel.add((Component)formats, GBC.eol().fill(2));
                    this.setContent(panel);
                }
            }.showDialog().getValue()) {
                return null;
            }
            String url = wms.buildGetMapUrl(tree.getSelectedLayers(), (String)formats.getSelectedItem());
            return new ImageryInfo(this.info.getName(), url, "wms", this.info.getEulaAcceptanceRequired(), this.info.getCookies());
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (WMSImagery.WMSGetCapabilitiesException ex) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            Main.error("Could not parse WMS layer list. Incoming data:\n" + ex.getIncomingData());
        }
        return null;
    }

    protected boolean isLayerAlreadyPresent() {
        if (Main.isDisplayingMapView()) {
            for (ImageryLayer layer : Main.map.mapView.getLayersOfType(ImageryLayer.class)) {
                if (!this.info.equals(layer.getInfo())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateEnabledState() {
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else if (this.info.getImageryType() == ImageryInfo.ImageryType.TMS || this.info.getImageryType() == ImageryInfo.ImageryType.BING || this.info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            this.setEnabled(true);
        } else if (Main.isDisplayingMapView() && !Main.map.mapView.getAllLayers().isEmpty()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

