/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction(boolean installAdapters) {
        super(installAdapters);
    }

    public AbstractInfoAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, installAdapters);
    }

    public static boolean confirmLaunchMultiple(int numBrowsers) {
        String msg = I18n.trn("You are about to launch {0} browser window.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", "You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", numBrowsers, numBrowsers);
        msg = "<html>" + msg + "</html>";
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.trn("Click to continue and to open {0} browser", "Click to continue and to open {0} browsers", numBrowsers, numBrowsers), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Warning", new Object[0]), 2, null, spec, spec[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
        return ret == 0;
    }

    protected void launchInfoBrowsersForSelectedPrimitives() {
        ArrayList<OsmPrimitive> primitivesToShow = new ArrayList<OsmPrimitive>(AbstractInfoAction.getCurrentDataSet().getAllSelected());
        Iterator it = primitivesToShow.iterator();
        while (it.hasNext()) {
            if (!((OsmPrimitive)it.next()).isNew()) continue;
            it.remove();
        }
        if (primitivesToShow.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int max = Math.min(10, primitivesToShow.size());
        if (primitivesToShow.size() > max && !AbstractInfoAction.confirmLaunchMultiple(primitivesToShow.size())) {
            return;
        }
        for (int i = 0; i < max; ++i) {
            OpenBrowser.displayUrl(this.createInfoUrl(primitivesToShow.get(i)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.launchInfoBrowsersForSelectedPrimitives();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AbstractInfoAction.getCurrentDataSet() != null && !AbstractInfoAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

