/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitorExecutor;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;
import org.openstreetmap.josm.gui.util.RedirectInputMap;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public abstract class Main {
    public static Component parent;
    public static volatile Main main;
    public static String[] commandLineArgs;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static final PrimitiveDeepCopy pasteBuffer;
    public static Layer pasteSource;
    public static MapFrame map;
    public static volatile ToolbarPreferences toolbar;
    public final UndoRedoHandler undoRedo = new UndoRedoHandler();
    public static PleaseWaitProgressMonitor currentProgressMonitor;
    public MainMenu menu;
    public OsmValidator validator;
    public static final FileWatcher fileWatcher;
    public final GettingStarted gettingStarted = new GettingStarted();
    private static final Collection<MapFrameListener> mapFrameListeners;
    protected static final Map<String, Throwable> NETWORK_ERRORS;
    private static final List<String> ERRORS_AND_WARNINGS;
    private static final Set<OnlineResource> OFFLINE_RESOURCES;
    public static int logLevel;
    public static volatile PlatformHook platform;
    public static boolean isOpenjdk;
    private static volatile InitStatusListener initListener;
    protected static final JPanel contentPanePrivate;
    public static final JPanel panel;
    protected static volatile WindowGeometry geometry;
    protected static int windowState;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        @Override
        public void commandChanged(int queueSize, int redoSize) {
            Main.this.menu.undo.setEnabled(queueSize > 0);
            Main.this.menu.redo.setEnabled(redoSize > 0);
        }
    };
    private static volatile Projection proj;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;
    private static final List<WeakReference<WindowSwitchListener>> windowSwitchListeners;

    public static boolean isDisplayingMapView() {
        if (map == null) {
            return false;
        }
        return Main.map.mapView != null;
    }

    private static void rememberWarnErrorMsg(String msg) {
        int idx = msg.indexOf(10);
        if (idx > 0) {
            ERRORS_AND_WARNINGS.add(msg.substring(0, idx));
        } else {
            ERRORS_AND_WARNINGS.add(msg);
        }
        while (ERRORS_AND_WARNINGS.size() > 5) {
            ERRORS_AND_WARNINGS.remove(0);
        }
    }

    public static final Collection<String> getLastErrorAndWarnings() {
        return Collections.unmodifiableList(ERRORS_AND_WARNINGS);
    }

    public static void error(String msg) {
        if (logLevel < 1) {
            return;
        }
        if (msg != null && !msg.isEmpty()) {
            System.err.println(I18n.tr("ERROR: {0}", msg));
            Main.rememberWarnErrorMsg("E: " + msg);
        }
    }

    public static void warn(String msg) {
        if (logLevel < 2) {
            return;
        }
        if (msg != null && !msg.isEmpty()) {
            System.err.println(I18n.tr("WARNING: {0}", msg));
            Main.rememberWarnErrorMsg("W: " + msg);
        }
    }

    public static void info(String msg) {
        if (logLevel < 3) {
            return;
        }
        if (msg != null && !msg.isEmpty()) {
            System.out.println(I18n.tr("INFO: {0}", msg));
        }
    }

    public static void debug(String msg) {
        if (logLevel < 4) {
            return;
        }
        if (msg != null && !msg.isEmpty()) {
            System.out.println(I18n.tr("DEBUG: {0}", msg));
        }
    }

    public static void trace(String msg) {
        if (logLevel < 5) {
            return;
        }
        if (msg != null && !msg.isEmpty()) {
            System.out.print("TRACE: ");
            System.out.println(msg);
        }
    }

    public static boolean isDebugEnabled() {
        return logLevel >= 4;
    }

    public static boolean isTraceEnabled() {
        return logLevel >= 5;
    }

    public static void error(String msg, Object ... objects) {
        Main.error(MessageFormat.format(msg, objects));
    }

    public static void warn(String msg, Object ... objects) {
        Main.warn(MessageFormat.format(msg, objects));
    }

    public static void info(String msg, Object ... objects) {
        Main.info(MessageFormat.format(msg, objects));
    }

    public static void debug(String msg, Object ... objects) {
        Main.debug(MessageFormat.format(msg, objects));
    }

    public static void trace(String msg, Object ... objects) {
        Main.trace(MessageFormat.format(msg, objects));
    }

    public static void error(Throwable t) {
        Main.error(t, true);
    }

    public static void warn(Throwable t) {
        Main.warn(t, true);
    }

    public static void error(Throwable t, boolean stackTrace) {
        Main.error(Main.getErrorMessage(t));
        if (stackTrace) {
            t.printStackTrace();
        }
    }

    public static void warn(Throwable t, boolean stackTrace) {
        Main.warn(Main.getErrorMessage(t));
        if (stackTrace) {
            t.printStackTrace();
        }
    }

    public static String getErrorMessage(Throwable t) {
        Throwable cause;
        if (t == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(t.getClass().getName());
        String msg = t.getMessage();
        if (msg != null) {
            sb.append(": ").append(msg.trim());
        }
        if ((cause = t.getCause()) != null && !cause.equals(t)) {
            sb.append(". ").append(I18n.tr("Cause: ", new Object[0])).append(Main.getErrorMessage(cause));
        }
        return sb.toString();
    }

    public static void initApplicationPreferences() {
        pref = new Preferences();
    }

    public final void setMapFrame(MapFrame map) {
        MapFrame old = Main.map;
        panel.setVisible(false);
        panel.removeAll();
        if (map != null) {
            map.fillPanel(panel);
        } else {
            old.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        Main.map = map;
        for (MapFrameListener listener : mapFrameListeners) {
            listener.mapFrameInitialized(old, map);
        }
        if (map == null && currentProgressMonitor != null) {
            currentProgressMonitor.showForegroundDialog();
        }
    }

    public final synchronized void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (Main.isDisplayingMapView() && Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public static void setInitStatusListener(InitStatusListener listener) {
        initListener = listener;
    }

    public Main() {
        main = this;
        boolean bl = isOpenjdk = System.getProperty("java.vm.name").toUpperCase().indexOf("OPENJDK") != -1;
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Executing platform startup hook", new Object[0]));
        }
        platform.startupHook();
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Building main menu", new Object[0]));
        }
        contentPanePrivate.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        this.menu = new MainMenu();
        this.undoRedo.addCommandQueueListener(this.redoUndoListener);
        contentPanePrivate.add((Component)Main.toolbar.control, "North");
        Main.registerActionShortcut(this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        ArrayList<InitializationTask> tasks = new ArrayList<InitializationTask>();
        tasks.add(new InitializationTask(I18n.tr("Initializing OSM API", new Object[0])){

            @Override
            public void initialize() throws Exception {
                try {
                    OsmApi.getOsmApi().initialize(null, true);
                }
                catch (Exception e) {
                    Main.warn(Main.getErrorMessage(Utils.getRootCause(e)));
                }
            }
        });
        tasks.add(new InitializationTask(I18n.tr("Initializing validator", new Object[0])){

            @Override
            public void initialize() throws Exception {
                Main.this.validator = new OsmValidator();
                MapView.addLayerChangeListener(Main.this.validator);
            }
        });
        tasks.add(new InitializationTask(I18n.tr("Initializing presets", new Object[0])){

            @Override
            public void initialize() throws Exception {
                TaggingPresets.initialize();
            }
        });
        tasks.add(new InitializationTask(I18n.tr("Initializing map styles", new Object[0])){

            @Override
            public void initialize() throws Exception {
                MapPaintPreference.initialize();
            }
        });
        tasks.add(new InitializationTask(I18n.tr("Loading imagery preferences", new Object[0])){

            @Override
            public void initialize() throws Exception {
                ImageryPreference.initialize();
            }
        });
        try {
            for (Future i : Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()).invokeAll(tasks)) {
                i.get();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        FeatureAdapter.registerBrowserAdapter(new FeatureAdapter.BrowserAdapter(){

            @Override
            public void openLink(String url) {
                OpenBrowser.displayUrl(url);
            }
        });
        FeatureAdapter.registerTranslationAdapter(I18n.getTranslationAdapter());
        FeatureAdapter.registerLoggingAdapter(new FeatureAdapter.LoggingAdapter(){

            @Override
            public Logger getLogger(String name) {
                Logger logger = Logger.getAnonymousLogger();
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                if (logger.getHandlers().length == 0) {
                    logger.addHandler(new Handler(){

                        @Override
                        public void publish(LogRecord record) {
                            String msg = MessageFormat.format(record.getMessage(), record.getParameters());
                            if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                                Main.error(msg);
                            } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                                Main.warn(msg);
                            } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                                Main.info(msg);
                            } else if (record.getLevel().intValue() >= Level.FINE.intValue()) {
                                Main.debug(msg);
                            } else {
                                Main.trace(msg);
                            }
                        }

                        @Override
                        public void flush() {
                        }

                        @Override
                        public void close() throws SecurityException {
                        }
                    });
                }
                return logger;
            }
        });
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Updating user interface", new Object[0]));
        }
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPanePrivate.updateUI();
    }

    public final void addLayer(Layer layer) {
        BoundingXYVisitor v = new BoundingXYVisitor();
        layer.visitBoundingBox(v);
        this.addLayer(layer, v.getBounds());
    }

    public final synchronized void addLayer(Layer layer, ProjectionBounds bounds) {
        this.addLayer(layer, bounds == null ? null : new ViewportData(bounds));
    }

    public final synchronized void addLayer(Layer layer, ViewportData viewport) {
        boolean noMap;
        boolean bl = noMap = map == null;
        if (noMap) {
            this.createMapFrame(layer, viewport);
        }
        layer.hookUpMapView();
        Main.map.mapView.addLayer(layer);
        if (noMap) {
            map.setVisible(true);
        } else if (viewport != null) {
            Main.map.mapView.zoomTo(viewport);
        }
    }

    public synchronized void createMapFrame(Layer firstLayer, ViewportData viewportData) {
        MapFrame mapFrame = new MapFrame(contentPanePrivate, viewportData);
        this.setMapFrame(mapFrame);
        if (firstLayer != null) {
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction(), firstLayer);
        }
        mapFrame.initializeDialogsPane();
        if (firstLayer != null) {
            firstLayer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
    }

    public boolean hasEditLayer() {
        return this.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        if (map != null && Main.map.mapMode instanceof DrawAction) {
            return ((DrawAction)Main.map.mapMode).getInProgressSelection();
        }
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        return ds.getSelected();
    }

    public Layer getActiveLayer() {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        return Main.map.mapView.getActiveLayer();
    }

    public static void redirectToMainContentPane(JComponent source) {
        RedirectInputMap.redirect(source, contentPanePrivate);
    }

    public static void registerActionShortcut(JosmAction action) {
        Main.registerActionShortcut(action, action.getShortcut());
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object existing = inputMap.get(keyStroke);
        if (existing != null && !existing.equals(action)) {
            Main.info(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, existing, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction action) {
        Main.unregisterActionShortcut(action, action.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        Main.unregisterShortcut(shortcut);
        contentPanePrivate.getActionMap().remove(action);
    }

    public static Action getRegisteredActionShortcut(Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return null;
        }
        Object action = contentPanePrivate.getInputMap(2).get(keyStroke);
        if (action instanceof Action) {
            return (Action)action;
        }
        return null;
    }

    public static void preConstructorInit(Map<MainApplication.Option, Collection<String>> args) {
        ProjectionPreference.setProjection();
        try {
            String defaultlaf = platform.getDefaultStyle();
            String laf = pref.get("laf", defaultlaf);
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Class<?> klass = null;
                for (ClassLoader cl : PluginHandler.getResourceClassLoaders()) {
                    try {
                        klass = cl.loadClass(laf);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (klass != null && LookAndFeel.class.isAssignableFrom(klass)) {
                    try {
                        UIManager.setLookAndFeel((LookAndFeel)klass.newInstance());
                    }
                    catch (Exception ex) {
                        Main.warn("Cannot set Look and Feel: " + laf + ": " + ex.getMessage());
                    }
                } else {
                    Main.info("Look and Feel not found: " + laf);
                    pref.put("laf", defaultlaf);
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                Main.info("Look and Feel not supported: " + laf);
                pref.put("laf", defaultlaf);
            }
            toolbar = new ToolbarPreferences();
            contentPanePrivate.updateUI();
            panel.updateUI();
        }
        catch (Exception e) {
            Main.error(e);
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        I18n.translateJavaInternalMessages();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException iae) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        geometry = WindowGeometry.mainWindow("gui.geometry", args.containsKey((Object)MainApplication.Option.GEOMETRY) ? args.get((Object)MainApplication.Option.GEOMETRY).iterator().next() : null, !args.containsKey((Object)MainApplication.Option.NO_MAXIMIZE) && pref.getBoolean("gui.maximized", false));
    }

    protected static void postConstructorProcessCmdLine(Map<MainApplication.Option, Collection<String>> args) {
        if (args.containsKey((Object)MainApplication.Option.DOWNLOAD)) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (String s : args.get((Object)MainApplication.Option.DOWNLOAD)) {
                File f = null;
                switch (Main.paramType(s)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(false, s);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(false, s);
                        break;
                    }
                    case fileUrl: {
                        try {
                            f = new File(new URI(s));
                        }
                        catch (URISyntaxException e) {
                            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", s), I18n.tr("Warning", new Object[0]), 2);
                        }
                        if (f == null) break;
                        fileList.add(f);
                        break;
                    }
                    case fileName: {
                        f = new File(s);
                        fileList.add(f);
                    }
                }
            }
            if (!fileList.isEmpty()) {
                OpenFileAction.openFiles(fileList, true);
            }
        }
        if (args.containsKey((Object)MainApplication.Option.DOWNLOADGPS)) {
            for (String s : args.get((Object)MainApplication.Option.DOWNLOADGPS)) {
                switch (Main.paramType(s)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(true, s);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(true, s);
                        break;
                    }
                    case fileUrl: 
                    case fileName: {
                        JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    }
                }
            }
        }
        if (args.containsKey((Object)MainApplication.Option.SELECTION)) {
            for (String s : args.get((Object)MainApplication.Option.SELECTION)) {
                SearchAction.search(s, SearchAction.SearchMode.add);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (!Main.isDisplayingMapView()) {
            return true;
        }
        return Main.saveUnsavedModifications(Main.map.mapView.getLayersOfType(AbstractModifiableLayer.class), true);
    }

    public static boolean saveUnsavedModifications(Iterable<? extends Layer> selectedLayers, boolean exit) {
        SaveLayersDialog dialog = new SaveLayersDialog(parent);
        ArrayList<AbstractModifiableLayer> layersWithUnmodifiedChanges = new ArrayList<AbstractModifiableLayer>();
        for (Layer layer : selectedLayers) {
            AbstractModifiableLayer odl;
            if (!(layer instanceof AbstractModifiableLayer) || !(odl = (AbstractModifiableLayer)layer).requiresSaveToFile() && (!odl.requiresUploadToServer() || odl.isUploadDiscouraged()) || !odl.isModified()) continue;
            layersWithUnmodifiedChanges.add(odl);
        }
        if (exit) {
            dialog.prepareForSavingAndUpdatingLayersBeforeExit();
        } else {
            dialog.prepareForSavingAndUpdatingLayersBeforeDelete();
        }
        if (!layersWithUnmodifiedChanges.isEmpty()) {
            dialog.getModel().populate(layersWithUnmodifiedChanges);
            dialog.setVisible(true);
            switch (dialog.getUserAction()) {
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean exitJosm(boolean exit, int exitCode) {
        JCSCacheManager.shutdown();
        if (Main.saveUnsavedModifications()) {
            geometry.remember("gui.geometry");
            if (map != null) {
                map.rememberToggleDialogWidth();
            }
            pref.put("gui.maximized", (windowState & 6) != 0);
            if (Main.isDisplayingMapView()) {
                ArrayList<Layer> layers = new ArrayList<Layer>(Main.map.mapView.getAllLayers());
                for (Layer l : layers) {
                    main.removeLayer(l);
                }
            }
            if (exit) {
                System.exit(exitCode);
            }
            return true;
        }
        return false;
    }

    private static DownloadParamType paramType(String s) {
        if (s.startsWith("http:") || s.startsWith("https:")) {
            return DownloadParamType.httpUrl;
        }
        if (s.startsWith("file:")) {
            return DownloadParamType.fileUrl;
        }
        String coorPattern = "\\s*[+-]?[0-9]+(\\.[0-9]+)?\\s*";
        if (s.matches(coorPattern + "(," + coorPattern + "){3}")) {
            return DownloadParamType.bounds;
        }
        return DownloadParamType.fileName;
    }

    private static void downloadFromParamHttp(boolean rawGps, String s) {
        Bounds b = OsmUrlToBounds.parse(s);
        if (b == null) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", s), I18n.tr("Warning", new Object[0]), 2);
        } else {
            Main.downloadFromParamBounds(rawGps, b);
        }
    }

    private static void downloadFromParamBounds(boolean rawGps, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.countTokens() == 4) {
            Bounds b = new Bounds(new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())), new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
            Main.downloadFromParamBounds(rawGps, b);
        }
    }

    private static void downloadFromParamBounds(boolean rawGps, Bounds b) {
        AbstractDownloadTask task = rawGps ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = task.download(true, b, null);
        worker.execute(new PostDownloadHandler((DownloadTask)task, future));
    }

    public static void determinePlatformHook() {
        String os = System.getProperty("os.name");
        if (os == null) {
            Main.warn("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if ("Linux".equals(os) || "Solaris".equals(os) || "SunOS".equals(os) || "AIX".equals(os) || "FreeBSD".equals(os) || "NetBSD".equals(os) || "OpenBSD".equals(os)) {
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            Main.warn("I don't know your operating system '" + os + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    protected static void addListener() {
        parent.addComponentListener(new WindowPositionSizeListener());
        ((JFrame)parent).addWindowStateListener(new WindowPositionSizeListener());
    }

    public static boolean isJava8orLater() {
        String version = System.getProperty("java.version");
        return version != null && !version.matches("^(1\\.)?[7].*");
    }

    public static void checkJavaVersion() {
        String version = System.getProperty("java.version");
        if (version != null) {
            if (version.matches("^(1\\.)?[789].*")) {
                return;
            }
            if (version.matches("^(1\\.)?[56].*")) {
                JMultilineLabel ho = new JMultilineLabel("<html>" + I18n.tr("<h2>JOSM requires Java version {0}.</h2>Detected Java version: {1}.<br>You can <ul><li>update your Java (JRE) or</li><li>use an earlier (Java {2} compatible) version of JOSM.</li></ul>More Info:", "7", version, "6") + "</html>");
                JTextArea link = new JTextArea(HelpUtil.getWikiBaseHelpUrl() + "/Help/SystemRequirements");
                link.setEditable(false);
                link.setBackground(panel.getBackground());
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.anchor = 17;
                gbc.weightx = 1.0;
                panel.add((Component)ho, gbc);
                panel.add((Component)link, gbc);
                String EXIT = I18n.tr("Exit JOSM", new Object[0]);
                String CONTINUE = I18n.tr("Continue, try anyway", new Object[0]);
                int ret = JOptionPane.showOptionDialog(null, panel, I18n.tr("Error", new Object[0]), 0, 0, null, new String[]{EXIT, CONTINUE}, EXIT);
                if (ret == 0) {
                    System.exit(0);
                }
                return;
            }
        }
        Main.error("Could not recognize Java Version: " + version);
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection p) {
        CheckParameterUtil.ensureParameterNotNull(p);
        Projection oldValue = proj;
        Bounds b = Main.isDisplayingMapView() ? Main.map.mapView.getRealBounds() : null;
        proj = p;
        Main.fireProjectionChanged(oldValue, proj, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection oldValue, Projection newValue, Bounds oldBounds) {
        if (!(newValue == null ^ oldValue == null) && (newValue == null || oldValue == null || Objects.equals(newValue.toCode(), oldValue.toCode()))) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> it = listeners.iterator();
            while (it.hasNext()) {
                WeakReference<ProjectionChangeListener> wr = it.next();
                ProjectionChangeListener listener = (ProjectionChangeListener)wr.get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                listener.projectionChanged(oldValue, newValue);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (newValue == null || oldBounds == null) return;
            Main.map.mapView.zoomTo(oldBounds);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> wr : listeners) {
                if (wr.get() != listener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listeners.add(new WeakReference<ProjectionChangeListener>(listener));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> it = listeners.iterator();
            while (it.hasNext()) {
                WeakReference<ProjectionChangeListener> wr = it.next();
                if (wr.get() != null && wr.get() != listener) continue;
                it.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWindowSwitchListener(WindowSwitchListener listener) {
        if (listener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<WindowSwitchListener> wr : windowSwitchListeners) {
                if (wr.get() != listener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            boolean wasEmpty = windowSwitchListeners.isEmpty();
            windowSwitchListeners.add(new WeakReference<WindowSwitchListener>(listener));
            if (wasEmpty) {
                MasterWindowListener.setup();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWindowSwitchListener(WindowSwitchListener listener) {
        if (listener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<WindowSwitchListener>> it = windowSwitchListeners.iterator();
            while (it.hasNext()) {
                WeakReference<WindowSwitchListener> wr = it.next();
                if (wr.get() != null && wr.get() != listener) continue;
                it.remove();
            }
            if (windowSwitchListeners.isEmpty()) {
                MasterWindowListener.teardown();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean addMapFrameListener(MapFrameListener listener, boolean fireWhenMapViewPresent) {
        boolean changed;
        boolean bl = changed = listener != null ? mapFrameListeners.add(listener) : false;
        if (fireWhenMapViewPresent && changed && map != null) {
            listener.mapFrameInitialized(null, map);
        }
        return changed;
    }

    public static boolean addMapFrameListener(MapFrameListener listener) {
        return Main.addMapFrameListener(listener, false);
    }

    public static boolean removeMapFrameListener(MapFrameListener listener) {
        return listener != null ? mapFrameListeners.remove(listener) : false;
    }

    public static Throwable addNetworkError(URL url, Throwable t) {
        if (url != null && t != null) {
            Throwable old = Main.addNetworkError(url.toExternalForm(), t);
            if (old != null) {
                Main.warn("Already here " + old);
            }
            return old;
        }
        return null;
    }

    public static Throwable addNetworkError(String url, Throwable t) {
        if (url != null && t != null) {
            return NETWORK_ERRORS.put(url, t);
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static String getJOSMWebsite() {
        if (pref != null) {
            return pref.get("josm.url", "https://josm.openstreetmap.de");
        }
        return "https://josm.openstreetmap.de";
    }

    public static String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    public static String getOSMWebsite() {
        if (pref != null) {
            return pref.get("osm.url", "https://www.openstreetmap.org");
        }
        return "https://www.openstreetmap.org";
    }

    public static String getBaseBrowseUrl() {
        if (pref != null) {
            return pref.get("osm-browse.url", Main.getOSMWebsite());
        }
        return Main.getOSMWebsite();
    }

    public static String getBaseUserUrl() {
        if (pref != null) {
            return pref.get("osm-user.url", Main.getOSMWebsite() + "/user");
        }
        return Main.getOSMWebsite() + "/user";
    }

    public static boolean isPlatformOsx() {
        return platform instanceof PlatformHookOsx;
    }

    public static boolean isPlatformWindows() {
        return platform instanceof PlatformHookWindows;
    }

    public static boolean isOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.contains((Object)r) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.add(r);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return new HashSet<OnlineResource>(OFFLINE_RESOURCES);
    }

    static {
        worker = new ProgressMonitorExecutor();
        pasteBuffer = new PrimitiveDeepCopy();
        fileWatcher = new FileWatcher();
        mapFrameListeners = new ArrayList<MapFrameListener>();
        NETWORK_ERRORS = new HashMap<String, Throwable>();
        ERRORS_AND_WARNINGS = Collections.synchronizedList(new ArrayList());
        OFFLINE_RESOURCES = new HashSet<OnlineResource>();
        logLevel = 3;
        initListener = null;
        contentPanePrivate = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
        windowState = 0;
        listeners = new ArrayList<WeakReference<ProjectionChangeListener>>();
        windowSwitchListeners = new ArrayList<WeakReference<WindowSwitchListener>>();
    }

    protected static class MasterWindowListener
    extends WindowAdapter {
        private static MasterWindowListener INSTANCE;

        protected MasterWindowListener() {
        }

        public static synchronized MasterWindowListener getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new MasterWindowListener();
            }
            return INSTANCE;
        }

        public static void setup() {
            if (!windowSwitchListeners.isEmpty()) {
                for (Window w : Window.getWindows()) {
                    if (!w.isShowing() || Arrays.asList(w.getWindowListeners()).contains(MasterWindowListener.getInstance())) continue;
                    w.addWindowListener(MasterWindowListener.getInstance());
                }
            }
        }

        public static void teardown() {
            for (Window w : Window.getWindows()) {
                w.removeWindowListener(MasterWindowListener.getInstance());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void windowActivated(WindowEvent e) {
            if (e.getOppositeWindow() != null) return;
            Class<Main> clazz = Main.class;
            synchronized (Main.class) {
                Iterator it = windowSwitchListeners.iterator();
                while (it.hasNext()) {
                    WeakReference wr = (WeakReference)it.next();
                    WindowSwitchListener listener = (WindowSwitchListener)wr.get();
                    if (listener == null) {
                        it.remove();
                        continue;
                    }
                    listener.fromOtherApplication();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void windowDeactivated(WindowEvent e) {
            for (Window w : Window.getWindows()) {
                if (!w.isShowing()) {
                    w.removeWindowListener(MasterWindowListener.getInstance());
                    continue;
                }
                if (Arrays.asList(w.getWindowListeners()).contains(MasterWindowListener.getInstance())) continue;
                w.addWindowListener(MasterWindowListener.getInstance());
            }
            if (e.getOppositeWindow() != null) return;
            Class<Main> clazz = Main.class;
            synchronized (Main.class) {
                Iterator it = windowSwitchListeners.iterator();
                while (it.hasNext()) {
                    WeakReference wr = (WeakReference)it.next();
                    WindowSwitchListener listener = (WindowSwitchListener)wr.get();
                    if (listener == null) {
                        it.remove();
                        continue;
                    }
                    listener.toOtherApplication();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static interface WindowSwitchListener {
        public void toOtherApplication();

        public void fromOtherApplication();
    }

    private static class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            windowState = e.getNewState();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        private void handleComponentEvent(ComponentEvent e) {
            Component c = e.getComponent();
            if (c instanceof JFrame && c.isVisible()) {
                if (windowState == 0) {
                    geometry = new WindowGeometry((JFrame)c);
                } else {
                    geometry.fixScreen((JFrame)c);
                }
            }
        }
    }

    private static enum DownloadParamType {
        httpUrl,
        fileUrl,
        bounds,
        fileName;

    }

    private abstract class InitializationTask
    implements Callable<Void> {
        private final String name;

        protected InitializationTask(String name) {
            this.name = name;
        }

        public abstract void initialize() throws Exception;

        @Override
        public Void call() throws Exception {
            if (initListener != null) {
                initListener.updateStatus(this.name);
            }
            long startTime = System.currentTimeMillis();
            this.initialize();
            if (Main.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                Main.debug(I18n.tr("{0} completed in {1}", this.name, Utils.getDurationString(elapsedTime)));
            }
            return null;
        }
    }

    public static interface InitStatusListener {
        public void updateStatus(String var1);
    }
}

