/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TemplatedWMSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private Map<String, String> headers = new HashMap<String, String>();
    private ImageryInfo info;
    private static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}", "\\{proj(\\([^})]+\\))?\\}", "\\{bbox\\}", "\\{w\\}", "\\{s\\}", "\\{e\\}", "\\{n\\}", "\\{width\\}", "\\{height\\}"};

    public TemplatedWMSTileSource(ImageryInfo info) {
        super(info.getName(), info.getUrl(), info.getId(), info.getMinZoom(), info.getMaxZoom());
        this.info = info;
        if (info.getCookies() != null) {
            this.headers.put("Cookie", info.getCookies());
        }
        this.handleTemplate();
    }

    private void handleTemplate() {
        Pattern pattern = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        this.baseUrl = output.toString();
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        Projection myProj = Main.getProjection();
        String myProjCode = Main.getProjection().toCode();
        EastNorth sw = myProj.latlon2eastNorth(new LatLon(this.tileYToLat(tiley + 1, zoom), this.tileXToLon(tilex, zoom)));
        EastNorth ne = myProj.latlon2eastNorth(new LatLon(this.tileYToLat(tiley, zoom), this.tileXToLon(tilex + 1, zoom)));
        double w = sw.getX();
        double s = sw.getY();
        double e = ne.getX();
        double n = ne.getY();
        if (!this.info.getServerProjections().contains(myProjCode) && "EPSG:3857".equals(Main.getProjection().toCode())) {
            LatLon swll = Main.getProjection().eastNorth2latlon(new EastNorth(w, s));
            LatLon nell = Main.getProjection().eastNorth2latlon(new EastNorth(e, n));
            myProjCode = "EPSG:4326";
            s = swll.lat();
            w = swll.lon();
            n = nell.lat();
            e = nell.lon();
        }
        if ("EPSG:4326".equals(myProjCode) && !this.info.getServerProjections().contains(myProjCode) && this.info.getServerProjections().contains("CRS:84")) {
            myProjCode = "CRS:84";
        }
        boolean switchLatLon = false;
        if (this.baseUrl.toLowerCase().contains("crs=epsg:4326")) {
            switchLatLon = true;
        } else if (this.baseUrl.toLowerCase().contains("crs=") && "EPSG:4326".equals(myProjCode)) {
            switchLatLon = true;
        }
        String bbox = switchLatLon ? String.format("%s,%s,%s,%s", latLonFormat.format(s), latLonFormat.format(w), latLonFormat.format(n), latLonFormat.format(e)) : String.format("%s,%s,%s,%s", latLonFormat.format(w), latLonFormat.format(s), latLonFormat.format(e), latLonFormat.format(n));
        return this.baseUrl.replaceAll("\\{proj(\\([^})]+\\))?\\}", myProjCode).replaceAll("\\{bbox\\}", bbox).replaceAll("\\{w\\}", latLonFormat.format(w)).replaceAll("\\{s\\}", latLonFormat.format(s)).replaceAll("\\{e\\}", latLonFormat.format(e)).replaceAll("\\{n\\}", latLonFormat.format(n)).replaceAll("\\{width\\}", String.valueOf(this.getTileSize())).replaceAll("\\{height\\}", String.valueOf(this.getTileSize())).replace(" ", "%20");
    }

    public static void checkUrl(String url) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        Matcher m = Pattern.compile("\\{[^}]*\\}").matcher(url);
        while (m.find()) {
            boolean isSupportedPattern = false;
            for (String pattern : ALL_PATTERNS) {
                if (!m.group().matches(pattern)) continue;
                isSupportedPattern = true;
                break;
            }
            if (isSupportedPattern) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", m.group(), url));
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

