/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.InputSource;

public class CachedAttributionBingAerialTileSource
extends BingAerialTileSource {
    public CachedAttributionBingAerialTileSource(String id) {
        super(id);
    }

    @Override
    protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
        return new Callable<List<BingAerialTileSource.Attribution>>(){

            @Override
            public List<BingAerialTileSource.Attribution> call() throws Exception {
                BingAttributionData attributionLoader = new BingAttributionData();
                int waitTimeSec = 1;
                while (true) {
                    try {
                        String xml = attributionLoader.updateIfRequiredString();
                        return CachedAttributionBingAerialTileSource.this.parseAttributionText(new InputSource(new StringReader(xml)));
                    }
                    catch (IOException ex) {
                        Main.warn("Could not connect to Bing API. Will retry in " + waitTimeSec + " seconds.");
                        Thread.sleep((long)waitTimeSec * 1000L);
                        waitTimeSec *= 2;
                        continue;
                    }
                    break;
                }
            }
        };
    }

    class BingAttributionData
    extends CacheCustomContent<IOException> {
        public BingAttributionData() {
            super("bing.attribution.xml", 3600);
        }

        @Override
        protected byte[] updateData() throws IOException {
            URL u = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
            try (Scanner scanner = new Scanner(UTFInputStreamReader.create(Utils.openURL(u)));){
                String r = scanner.useDelimiter("\\A").next();
                Main.info("Successfully loaded Bing attribution data.");
                byte[] byArray = r.getBytes("UTF-8");
                return byArray;
            }
        }
    }
}

