/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.CachedAttributionBingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.ScanexTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;

    public AbstractTMSTileSource(String name, String base_url, String id) {
        this.name = name;
        this.baseUrl = base_url;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        return "/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTileType() {
        return "png";
    }

    @Override
    public int getTileSize() {
        return OsmMercator.TILE_SIZE;
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return OsmMercator.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public int LonToX(double lon, int zoom) {
        return (int)OsmMercator.LonToX(lon, zoom);
    }

    @Override
    public int LatToY(double lat, int zoom) {
        return (int)OsmMercator.LatToY(lat, zoom);
    }

    @Override
    public double XToLon(int x, int zoom) {
        return OsmMercator.XToLon(x, zoom);
    }

    @Override
    public double YToLat(int y, int zoom) {
        return OsmMercator.YToLat(y, zoom);
    }

    @Override
    public double latToTileY(double lat, int zoom) {
        return OsmMercator.LatToY(lat, zoom) / (double)OsmMercator.TILE_SIZE;
    }

    @Override
    public double lonToTileX(double lon, int zoom) {
        return OsmMercator.LonToX(lon, zoom) / (double)OsmMercator.TILE_SIZE;
    }

    @Override
    public double tileYToLat(int y, int zoom) {
        return OsmMercator.YToLat(y * OsmMercator.TILE_SIZE, zoom);
    }

    @Override
    public double tileXToLon(int x, int zoom) {
        return OsmMercator.XToLon(x * OsmMercator.TILE_SIZE, zoom);
    }

    public static TileSource getTileSource(ImageryInfo info) throws IllegalArgumentException {
        if (info.getImageryType() == ImageryInfo.ImageryType.TMS) {
            TemplatedTMSTileSource.checkUrl(info.getUrl());
            TemplatedTMSTileSource t = new TemplatedTMSTileSource(info.getName(), info.getUrl(), info.getId(), info.getMinZoom(), info.getMaxZoom(), info.getCookies());
            info.setAttribution(t);
            return t;
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new CachedAttributionBingAerialTileSource(info.getId());
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new ScanexTileSource(info.getName(), info.getUrl(), info.getId(), info.getMaxZoom());
        }
        return null;
    }
}

