/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.props.PropertyLoader;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static PoolConfiguration.WhenBlockedPolicy whenBlockedPolicy_DEFAULT = PoolConfiguration.WhenBlockedPolicy.RUN;
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    public static final String DEFAULT_PROPS_FILE_NAME = "cache.ccf";
    private static String propsFileName;
    public static String PROP_NAME_ROOT;
    private static String DEFAULT_PROP_NAME_ROOT;
    private static volatile Properties props;
    private static HashMap<String, ThreadPoolExecutor> pools;
    private static ThreadPoolManager INSTANCE;

    private ThreadPoolManager() {
        this.configure();
    }

    private ThreadPoolExecutor createPool(PoolConfiguration config) {
        ThreadPoolExecutor pool = null;
        LinkedBlockingQueue<Runnable> queue = null;
        if (config.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            queue = new LinkedBlockingQueue(config.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            queue = new LinkedBlockingQueue<Runnable>();
        }
        pool = new ThreadPoolExecutor(config.getStartUpSize(), config.getMaximumPoolSize(), (long)config.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory("JCS-ThreadPoolManager-"));
        switch (config.getWhenBlockedPolicy()) {
            case ABORT: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        pool.prestartAllCoreThreads();
        return pool;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPool(String name) {
        ThreadPoolExecutor pool = null;
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            pool = pools.get(name);
            if (pool == null) {
                PoolConfiguration config;
                if (log.isDebugEnabled()) {
                    log.debug("Creating pool for name [" + name + "]");
                }
                if ((pool = this.createPool(config = this.loadConfig(PROP_NAME_ROOT + "." + name))) != null) {
                    pools.put(name, pool);
                }
                if (log.isDebugEnabled()) {
                    log.debug("PoolName = " + this.getPoolNames());
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getPoolNames() {
        ArrayList<String> poolNames = new ArrayList<String>();
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            poolNames.addAll(pools.keySet());
        }
        return poolNames;
    }

    public static void setPropsFileName(String propsFileName) {
        ThreadPoolManager.propsFileName = propsFileName;
    }

    public static String getPropsFileName() {
        return propsFileName;
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    public static Properties getProps() {
        return props;
    }

    protected void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            try {
                props = PropertyLoader.loadProperties(propsFileName);
                if (log.isDebugEnabled()) {
                    log.debug("File contained " + props.size() + " properties");
                }
            }
            catch (Exception e) {
                log.error("Problem loading properties. propsFileName [" + propsFileName + "]", e);
            }
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    protected PoolConfiguration loadConfig(String root) {
        PoolConfiguration config = (PoolConfiguration)defaultConfig.clone();
        if (props.containsKey(root + ".useBoundary")) {
            try {
                config.setUseBoundary(Boolean.valueOf((String)props.get(root + ".useBoundary")));
            }
            catch (NumberFormatException nfe) {
                log.error("useBoundary not a boolean.", nfe);
            }
        }
        if (props.containsKey(root + ".boundarySize")) {
            try {
                config.setBoundarySize(Integer.parseInt((String)props.get(root + ".boundarySize")));
            }
            catch (NumberFormatException nfe) {
                log.error("boundarySize not a number.", nfe);
            }
        }
        if (props.containsKey(root + ".maximumPoolSize")) {
            try {
                config.setMaximumPoolSize(Integer.parseInt((String)props.get(root + ".maximumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error("maximumPoolSize not a number.", nfe);
            }
        }
        if (props.containsKey(root + ".minimumPoolSize")) {
            try {
                config.setMinimumPoolSize(Integer.parseInt((String)props.get(root + ".minimumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error("minimumPoolSize not a number.", nfe);
            }
        }
        if (props.containsKey(root + ".keepAliveTime")) {
            try {
                config.setKeepAliveTime(Integer.parseInt((String)props.get(root + ".keepAliveTime")));
            }
            catch (NumberFormatException nfe) {
                log.error("keepAliveTime not a number.", nfe);
            }
        }
        if (props.containsKey(root + ".whenBlockedPolicy")) {
            config.setWhenBlockedPolicy((String)props.get(root + ".whenBlockedPolicy"));
        }
        if (props.containsKey(root + ".startUpSize")) {
            try {
                config.setStartUpSize(Integer.parseInt((String)props.get(root + ".startUpSize")));
            }
            catch (NumberFormatException nfe) {
                log.error("startUpSize not a number.", nfe);
            }
        }
        if (log.isInfoEnabled()) {
            log.info(root + " PoolConfiguration = " + config);
        }
        return config;
    }

    static {
        propsFileName = null;
        PROP_NAME_ROOT = "thread_pool";
        DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
        props = null;
        pools = new HashMap();
        INSTANCE = null;
    }
}

