/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortedPreferentialArray<T extends Comparable<? super T>> {
    private static final Log log = LogFactory.getLog(SortedPreferentialArray.class);
    private boolean preferLarge = true;
    private int maxSize = 0;
    private int curSize = 0;
    private final T[] array;
    private int insertCnt = 0;

    public SortedPreferentialArray(int maxSize) {
        this.maxSize = maxSize;
        Comparable[] ts = new Comparable[maxSize];
        this.array = ts;
    }

    public synchronized void add(T obj) {
        if (obj == null) {
            return;
        }
        if (this.curSize < this.maxSize) {
            this.insert(obj);
            return;
        }
        if (this.preferLarge) {
            T sma = this.getSmallest();
            if (obj.compareTo(sma) > 0) {
                this.insert(obj);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("New object is smaller than or equal to the smallest");
            }
            return;
        }
        T lar = this.getLargest();
        int diff = obj.compareTo(lar);
        if (diff > 0 || diff == 0) {
            if (log.isDebugEnabled()) {
                log.debug("New object is larger than or equal to the largest");
            }
            return;
        }
        this.insert(obj);
    }

    public synchronized T getLargest() {
        return this.array[this.curSize - 1];
    }

    public synchronized T getSmallest() {
        return this.array[0];
    }

    private void insert(T obj) {
        try {
            int nLar = this.findNearestLargerEqualOrLastPosition(obj);
            if (log.isDebugEnabled()) {
                log.debug("nLar = " + nLar + " obj = " + obj);
            }
            if (nLar == this.curSize && this.curSize < this.maxSize) {
                this.array[nLar] = obj;
                ++this.curSize;
                if (log.isDebugEnabled()) {
                    log.debug(this.dumpArray());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Inserted object at the end of the array");
                }
                return;
            }
            boolean isFull = false;
            if (this.curSize == this.maxSize) {
                isFull = true;
            }
            if (this.preferLarge) {
                if (isFull) {
                    int pnt = nLar - 1;
                    for (int i = 0; i < pnt; ++i) {
                        this.array[i] = this.array[i + 1];
                    }
                    this.array[nLar - 1] = obj;
                    if (log.isDebugEnabled()) {
                        log.debug("Inserted object at " + (nLar - 1));
                    }
                } else {
                    int pnt = nLar;
                    for (int i = this.curSize; i > pnt; --i) {
                        this.array[i] = this.array[i - 1];
                    }
                    this.array[nLar] = obj;
                    ++this.curSize;
                    if (log.isDebugEnabled()) {
                        log.debug("Inserted object at " + nLar);
                    }
                }
            } else {
                int pnt = nLar + 1;
                if (!isFull) {
                    pnt = nLar;
                }
                for (int i = this.curSize; i > pnt; --i) {
                    this.array[i] = this.array[i - 1];
                }
                this.array[nLar] = obj;
                if (log.isDebugEnabled()) {
                    log.debug("Inserted object at " + nLar);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(this.dumpArray());
            }
        }
        catch (Exception e) {
            log.error("Insertion problem" + this.dumpArray(), e);
        }
        ++this.insertCnt;
        if (this.insertCnt % 100 == 0 && log.isDebugEnabled()) {
            log.debug(this.dumpArray());
        }
    }

    public synchronized void setPreferLarge(boolean pref2) {
        this.preferLarge = pref2;
    }

    public synchronized T takeNearestLargerOrEqual(T obj) {
        if (obj == null) {
            return null;
        }
        T retVal = null;
        try {
            int pos = this.findNearestOccupiedLargerOrEqualPosition(obj);
            if (pos == -1) {
                return null;
            }
            try {
                retVal = this.array[pos];
                this.remove(pos);
            }
            catch (Exception e) {
                log.error("Problem removing from array. pos [" + pos + "] " + obj, e);
            }
            if (log.isDebugEnabled()) {
                log.debug("obj = " + obj + " || retVal = " + retVal);
            }
        }
        catch (Exception e) {
            log.error("Take problem" + this.dumpArray(), e);
        }
        return retVal;
    }

    public synchronized int size() {
        return this.curSize;
    }

    private int findNearestOccupiedLargerOrEqualPosition(T obj) {
        if (this.curSize == 0) {
            return -1;
        }
        int pos = this.findNearestLargerEqualOrLastPosition(obj);
        if (pos == this.curSize) {
            pos = obj.compareTo(this.array[pos - 1]) <= 0 ? --pos : -1;
        } else if (obj.compareTo(this.array[pos]) > 0) {
            return -1;
        }
        return pos;
    }

    private int findNearestLargerEqualOrLastPosition(T obj) {
        if (obj == null) {
            return -1;
        }
        if (this.curSize <= 0) {
            return 0;
        }
        int greaterPos = -1;
        int curPos = (this.curSize - 1) / 2;
        int prevPos = -1;
        try {
            boolean done = false;
            if (obj.compareTo(this.getSmallest()) <= 0) {
                if (log.isDebugEnabled()) {
                    log.debug(obj + " is smaller than or equal to " + this.getSmallest());
                }
                greaterPos = 0;
                done = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(obj + " is bigger than " + this.getSmallest());
                }
                if (obj.compareTo(this.getLargest()) >= 0) {
                    if (this.curSize == this.maxSize) {
                        greaterPos = this.curSize - 1;
                        done = true;
                    } else {
                        greaterPos = this.curSize;
                        done = true;
                    }
                } else {
                    greaterPos = this.curSize - 1;
                }
            }
            while (!done) {
                int newPos;
                if (log.isDebugEnabled()) {
                    log.debug("\n curPos = " + curPos + "; greaterPos = " + greaterPos + "; prevpos = " + prevPos);
                }
                if (curPos == prevPos || curPos >= this.curSize) {
                    done = true;
                    break;
                }
                if (this.array[curPos].compareTo(obj) == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.array[curPos] + " is equal to " + obj);
                    }
                    greaterPos = curPos;
                    done = true;
                    break;
                }
                if (this.array[curPos].compareTo(obj) > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.array[curPos] + " is greater than " + obj);
                    }
                    greaterPos = curPos;
                    newPos = Math.min(curPos, (curPos + prevPos) / 2);
                    prevPos = curPos;
                    curPos = newPos;
                    continue;
                }
                if (this.array[curPos].compareTo(obj) >= 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug(this.array[curPos] + " is less than " + obj);
                }
                if (greaterPos != -1 && greaterPos - curPos < 0) {
                    done = true;
                    break;
                }
                newPos = 0;
                if (prevPos > curPos) {
                    newPos = Math.min((curPos + prevPos) / 2, this.curSize);
                } else if (prevPos == -1) {
                    newPos = Math.min((this.curSize + curPos) / 2, this.curSize);
                }
                prevPos = curPos;
                curPos = newPos;
            }
            if (log.isDebugEnabled()) {
                log.debug("Greater Position is [" + greaterPos + "]" + " array[greaterPos] [" + this.array[greaterPos] + "]");
            }
        }
        catch (Exception e) {
            log.error("\n curPos = " + curPos + "; greaterPos = " + greaterPos + "; prevpos = " + prevPos + " " + this.dumpArray(), e);
        }
        return greaterPos;
    }

    private void remove(int position) {
        if (position >= this.curSize || position < 0) {
            throw new IndexOutOfBoundsException("position=" + position + " must be less than curSize=" + this.curSize);
        }
        --this.curSize;
        if (position < this.curSize) {
            try {
                System.arraycopy(this.array, position + 1, this.array, position, this.curSize - position);
            }
            catch (IndexOutOfBoundsException ibe) {
                log.warn("Caught index out of bounds exception. called 'System.arraycopy( array, position + 1, array, position, (curSize - position) );'  array.lengh [" + this.array.length + "] position [" + position + "] curSize [" + this.curSize + "]");
                throw ibe;
            }
        }
    }

    protected synchronized String dumpArray() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n ---------------------------");
        buf.append("\n curSize = " + this.curSize);
        buf.append("\n array.length = " + this.array.length);
        buf.append("\n ---------------------------");
        buf.append("\n Dump:");
        for (int i = 0; i < this.curSize; ++i) {
            buf.append("\n " + i + "=" + this.array[i]);
        }
        return buf.toString();
    }
}

