/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.props;

import java.io.InputStream;
import java.util.Properties;

public abstract class PropertyLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        String fileName;
        boolean isCCFSuffix = true;
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        ClassLoader classLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        String string = fileName = name.startsWith("/") ? name.substring(1) : name;
        if (fileName.endsWith(".ccf")) {
            fileName = fileName.substring(0, fileName.length() - ".ccf".length());
        }
        if (fileName.endsWith(".properties")) {
            fileName = fileName.substring(0, fileName.length() - ".properties".length());
            isCCFSuffix = false;
        }
        Properties result = null;
        InputStream in = null;
        try {
            fileName = fileName.replace('.', '/');
            if (!fileName.endsWith(".ccf") && isCCFSuffix) {
                fileName = fileName.concat(".ccf");
            } else if (!fileName.endsWith(".properties") && !isCCFSuffix) {
                fileName = fileName.concat(".properties");
            }
            in = classLoader.getResourceAsStream(fileName);
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + fileName + "]" + " as " + "a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertyLoader.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }
}

